public interface FancyList extends List {

  /** Destructively appends l to the end of this list to produce a
   * new FancyList, which is returned.  Both this list and l
   * will be destroyed (i.e., corrupted) by the operation and should
   * not be used thereafter.  
   *
   * @throws ClassCastException if the class of l does not
   *         permit it to be appended to this list.  (For example, only
   *         a NodeList can be appended to another NodeList.)
   */

  public FancyList append_destructive(List l);

  /** Destructively reverses this list to produce a new FancyList, as
   * discussed in class.  It is probably fastest to do this via
   * List.swapElements, but to get practice with pointers, you
   * you are required to do it by manipulating the nodes' prev
   * and next fields rather than their elements. 
   */

  public FancyList reverse_destructive();

  /** Returns an iterator over the elements of the list. */

  public java.util.Iterator iterator();

  /** Returns an iterator over the elements of the list in reverse
   * order. 
   */

  public java.util.Iterator iteratorReverse();

  /** Returns an iterator over the elements of the list in sorted
   * order.  Elements are compared using the compareTo method
   * and the least one is returned first.  Elements that compare
   * as equal should be returned in their original left-to-right
   * order (this is called a "stable sort").  See the assignment
   * for discussion and hints.
   *
   * @throws ClassCastException if the list contains elements that
   *   cannot be compared to one another (e.g., strings and
   *   integers, or objects that cannot be cast to Comparable).
   */

  public java.util.Iterator iteratorSorted();
}

