// An unchecked exception class assumed by the textbook (and available 
// online as part of the JDSL library).

/** An EmptyContainerException indicates (duh) that the Container
 * can't fulfill the requested operation because it is empty. In
 * general, it is thrown when the operation cannot be completed ONLY
 * when the container is empty (for instance, the only time there is
 * no first() in a sequence is when the sequence is empty). When
 * emptiness is just a special case of "not enough" of something, a
 * BoundaryViolationException is used instead.
 */

public class EmptyContainerException extends RuntimeException {
  public EmptyContainerException(String msg) {
    super(msg);
  }
}
