package graph;

/** A class used to find the weight of objects, such as graph edges.<p>
 *
 * Remember that a comparator is passed to methods that need to regard certain
 * objects as comparable.  Similarly, a weighter is passed to methods that 
 * need to regard certain objects as weighted.<p>
 * 
 * For example, an implementation might use any of the following
 * methods to find the weight of a graph edge e:<p>
 *
 * <ul>
 * <li>The edges in the graph in question might actually store their
 *     weights, in which case the Weighter can just look it up.
 *     (They could store it as the edge element, or as an attribute of
 *     the edge, or in a extra instance variable available in some
 *     edge implementations.)  A Weighter object might do this by
 *     calling some e.weight() method.
 * 
 * <li>The graph containing the edge might be a weighted graph that stores the 
 *     edge weights in some auxiliary data structure, rather than on the
 *     edge itself.  In that case the Weighter object should store a pointer to the
 *     graph g, so we can call g.edgeWeight(e).
 *
 * <li>The Weighter object might store the weights of edges ourselves in an 
 *     auxiliary structure inside the Weighter object.
 * 
 * <li>The Weighter object might get an edge's weight by some kind of
 *     computation involving other properties of the edge, such as its
 *     vertices or attributes.
 *
 * <li>A trivial Weighter might just say that all edges have weight 1.
 * </ul>
 */

public interface Weighter {

  /** Find the weight of this object in an appropriate way.
   * @throws ClassCastException - if we don't know how. */

  double weight(Object o);

}
