package graph;

/** A straightforward implementation of the Vertex interface. 
 * Other implementations are possible. 
 *
 * This class may be extended.  For example, in an adjacency-list
 * implementation of a graph, each vertex must also store its incident
 * edges.
 */

public class StoredVertex extends container.HashDecorable
                                implements Vertex {

  // ---------- INSTANCE VARIABLES ----------

  /** Element stored at this vertex. */
  Object element;

  // ---------- CONSTRUCTOR ----------

  /** Construct a new vertex storing object o.  Initially, the
   * vertex is not decorated with any attributes.
   */
  public StoredVertex(Object o) {
    element = o;
  }

  // ---------- ACCESSORS ----------

  /** Get the element at this position. */
  public Object element() {
    return element;
  }

  /** Replace the element at this position. */
  public void replaceElement(Object o) {
    element = o;
  }

  // ---------- OVERRIDING METHODS ----------

  /** A printable representation of this vertex, such as
   * [vertex @12345 - xyz].  xyz is the element stored at the 
   * vertex.<p>
   * 
   * The @12345 part is computed from the vertex's hash code,
   * just as in Object.toString().  It serves to distinguish
   * multiple distinct vertices that might happen to store
   * the same element (e.g., "xyz").  Also, it won't change
   * if we call replaceElement().
   */
  public String toString() {
    return "[vertex @"+Integer.toHexString(hashCode())+" - "+element()+"]";
  }
}
