package graph;

/** A straightforward implementation of the DirectedEdge interface. 
 * Other implementations are possible. */

public class StoredDirectedEdge extends container.HashDecorable
                                implements DirectedEdge {

  protected Vertex orig, dest;
  protected Object element;

  /** Creates a new edge from orig to dest, labeled with element. */
  public StoredDirectedEdge(Vertex orig, Vertex dest, Object element) {
    this.orig = orig;
    this.dest = dest;
    this.element = element;
  }

  /** Element stored on this edge. */
  public Object element() { return element; }

  public Vertex origin() { return orig; }
  public Vertex destination() { return dest; }

  /** A printable representation of this edge, such 
   * as [directed edge 999 from [vertex @12345 - xyz] 
   * to [vertex @54321 - abc]]; here
   * 999 is the element stored on the edge.<p>
   * 
   * The @12345 part is computed from the edge's hash code,
   * just as in Object.toString().  It serves to distinguish
   * multiple distinct edges that might happen to store
   * the same element (e.g., "xyz").  Also, it won't change
   * if we call replaceElement().
   */
  public String toString() {
    return "[directed edge "+element()+" from "+orig+" to "+dest+"]";
  }
}
