package graph;

/** A sequence of directed edges laid end to end.
 * We regard all length-0 paths as being the same (empty list), although this
 * violates the graph-theory tradition that a length-0 path is a single vertex.
 */

public class Path extends java.util.Vector {
  // default constructor, no special methods.
  // a Path is just a vector of edges, plus the toString() method below.

  /** Constructs a concise string representation of the path.  Example:
   *  <pre>
   *      x --1--> y --2--> z 
   *  </pre>
   * for a path whose vertices have elements x, y, z and whose
   * edges have elements 1 and 2.
   */
  public String toString() {
    if (isEmpty()) {
      return "(empty path)";
    } else {
      // We'll accumulate the result in a StringBuffer for efficiency
      // and convenience.
      StringBuffer result = new StringBuffer();

      // Start with the origin vertex of the first edge.
      Vertex vStart = ((DirectedEdge)get(0)).origin();
      result.append(vStart.element());       

      // For each remaining edge, add that edge and its 
      // destination vertex.
      java.util.Iterator iter = iterator();
      while (iter.hasNext()) {
	DirectedEdge e = (DirectedEdge) iter.next();
	result.append(" ---"+e.element()+"--> ");
	result.append(e.destination().element());
      }

      // All done!
      return result.toString();
    }    
  }  
}
