package graph;

/** A Digraph with keyed vertices.  When you add a vertex, you can give
 * it a unique key, by which you can look it up later.<p>
 *
 * A better version of this class would also support some other methods;
 * you are asked to suggest some in your Readme file.
 */

public interface KeyedDigraph extends Digraph {
  
  /** Return the vertex with key k. 
   * @throws NoSuchVertexException if there is no such vertex. 
   */
  public Vertex findKeyedVertex(Object k);

  /** Return the vertex with key k.  If there is none, create
   * a new vertex with key k, and return it.  The new vertex's
   * element is initially k as well, but can be changed using
   * Vertex.replaceElement().<p>
   *
   * This is the ONLY way to add a keyed vertex.  Unkeyed vertices can
   * be added with ordinary insertVertex(); but they do not have keys,
   * and cannot be looked up by findKeyedVertex().
   */
  public Vertex findOrInsertKeyedVertex(Object k);

  /** Convenience method: Add a directed edge between two keyed vertices,
   * which are looked up or added using findOrInsertKeyedVertex().
   */
  public DirectedEdge keyedInsertDirectedEdge(Object keyFrom, Object keyTo, Object element);
}
