package geography;

/** One kind of object that can be returned by address lookup (see the
 * AddressFinder class).  Represents a physical intersection. */

public class Intersection {

  /** Physical location of the address. */
  public Point point;

  /** A description of the address, e.g., "3400 Charles St"
   * or perhaps "Charles St at University Pkwy".
   */
  public String descrip;
  
  protected Intersection(Point p, String s) {
    point = p;
    descrip = s;
  }

  public String toString() {
    return descrip + " (near "+point+")";
  }
}
