package container;

/** This class should typically be extended so that it implements 
 * other interfaces besides Decorable.  So far, it stores only
 * decorations but no data!
 *
 * Each instance of the class is a position that stores its attributes
 * and their values in a hash table.  We assume there will be a lot of
 * positions, and probably not very many attributes per position, so
 * we try to keep the hash table at each position small or
 * nonexistent.  
 */

public class HashDecorable implements Decorable {

  /** Maps attributes of this object to their values.  If there
   * are no attributes, we save memory by making the map null 
   * rather than an empty HashMap.
   */
  protected java.util.Map m = null;

  /** Constructor.  No attributes to start with. */
  public HashDecorable() {
    // don't have to do anything; just leave m at null until 
    // some decorations are actually added.  
  }

  public boolean has(Attribute a) {
    return (m!=null) && m.containsKey(a);
  }

  public Object get(Attribute a) {
    throw new UnsupportedOperationException();   // replace this
  }

  public Object put(Attribute a, Object o) {
    throw new UnsupportedOperationException();   // replace this
  }

  public Object remove(Attribute a) {
    throw new UnsupportedOperationException();   // replace this
  }
}
