/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.team;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.ClarificationsPane;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.OptionsPanel;
import edu.csus.ecs.pc2.ui.RunsPanel;
import edu.csus.ecs.pc2.ui.SubmitClarificationPane;
import edu.csus.ecs.pc2.ui.SubmitRunPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TeamView
extends JFrame
implements UIPlugin {
    public static final String SVN_ID = "$Id: TeamView.java 1676 2008-11-19 05:22:53Z ashoos $";
    private IInternalContest contest = null;
    private IInternalController teamController = null;
    private static final long serialVersionUID = 8225187691479543638L;
    private JPanel mainViewPane = null;
    private JTabbedPane mainTabbedPane = null;
    private LogWindow logWindow = null;
    private JPanel northPane = null;
    private JPanel exitPane = null;
    private JPanel messagePane = null;
    private JPanel clockPane = null;
    private JLabel clockLabel = null;
    private JLabel messageLabel = null;
    private JButton exitButton = null;
    private ContestClockDisplay contestClockDisplay = null;

    public TeamView() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(556, 521));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getMainViewPane());
        this.setTitle("The TeamView");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TeamView.this.promptAndExit();
            }
        });
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
        this.setTitle("PC^2 Team - Not Logged In ");
        FrameUtilities.waitCursor(this);
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.contest.getSiteNumber();
    }

    private void updateFrameTitle(final boolean turnButtonsOn) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (turnButtonsOn) {
                    TeamView.this.setTitle("PC^2 Team " + TeamView.this.contest.getTitle() + " [STARTED] Build " + new VersionInfo().getBuildNumber());
                } else {
                    TeamView.this.setTitle("PC^2 Team " + TeamView.this.contest.getTitle() + " [STOPPED] Build " + new VersionInfo().getBuildNumber());
                }
                if (TeamView.this.contestClockDisplay.getClientFrame() == null) {
                    TeamView.this.contestClockDisplay.setClientFrame(TeamView.this.getThisFrame());
                }
                TeamView.this.contestClockDisplay.fireClockStateChange(TeamView.this.contest.getContestTime());
            }
        });
        if (turnButtonsOn) {
            this.updateClockLabel("");
        } else {
            this.updateClockLabel("STOPPED");
        }
        FrameUtilities.regularCursor(this);
    }

    private JPanel getMainViewPane() {
        if (this.mainViewPane == null) {
            this.mainViewPane = new JPanel();
            this.mainViewPane.setLayout(new BorderLayout());
            this.mainViewPane.add((Component)this.getMainTabbedPane(), "Center");
            this.mainViewPane.add((Component)this.getNorthPane(), "North");
        }
        return this.mainViewPane;
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    protected TeamView getThisFrame() {
        return this;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.teamController = inController;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TeamView.this.logWindow == null) {
                    TeamView.this.logWindow = new LogWindow();
                }
                TeamView.this.logWindow.setContestAndController(TeamView.this.contest, TeamView.this.teamController);
                TeamView.this.logWindow.setTitle("Log " + TeamView.this.contest.getClientId().toString());
                TeamView.this.contest.addContestTimeListener(new ContestTimeListenerImplementation());
                SubmitRunPane submitRunPane = new SubmitRunPane();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "Submit Run", submitRunPane);
                RunsPanel runsPanel = new RunsPanel();
                runsPanel.setShowJudgesInfo(false);
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "View Runs", runsPanel);
                SubmitClarificationPane submitClarificationPane = new SubmitClarificationPane();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "Request Clarification", submitClarificationPane);
                ClarificationsPane clarificationsPane = new ClarificationsPane();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "View Clarifications", clarificationsPane);
                OptionsPanel optionsPanel = new OptionsPanel();
                TeamView.this.addUIPlugin(TeamView.this.getMainTabbedPane(), "Options", optionsPanel);
                optionsPanel.setLogWindow(TeamView.this.logWindow);
                TeamView.this.updateFrameTitle(TeamView.this.contest.getContestTime().isContestRunning());
                TeamView.this.contestClockDisplay = new ContestClockDisplay(TeamView.this.teamController.getLog(), TeamView.this.contest.getContestTime(), TeamView.this.contest.getSiteNumber(), TeamView.this.isTeam(), null);
                TeamView.this.contestClockDisplay.addLabeltoUpdateList(TeamView.this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, TeamView.this.contest.getSiteNumber());
                TeamView.this.setVisible(true);
                TeamView.this.getMainTabbedPane().setSelectedComponent(submitClarificationPane);
                TeamView.this.getMainTabbedPane().doLayout();
                TeamView.this.getMainTabbedPane().setSelectedComponent(submitRunPane);
            }
        });
    }

    private boolean isTeam(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    private boolean isTeam() {
        return this.isTeam(this.contest.getClientId());
    }

    public String getPluginTitle() {
        return "Team Main GUI";
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        plugin.setParentFrame(this);
        plugin.setContestAndController(this.contest, this.teamController);
        tabbedPane.add((Component)plugin, tabTitle);
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.northPane = new JPanel();
            this.northPane.setLayout(new BorderLayout());
            this.northPane.setPreferredSize(new Dimension(40, 40));
            this.northPane.add((Component)this.getExitPane(), "East");
            this.northPane.add((Component)this.getMessagePane(), "Center");
            this.northPane.add((Component)this.getClockPane(), "West");
        }
        return this.northPane;
    }

    private JPanel getExitPane() {
        if (this.exitPane == null) {
            this.exitPane = new JPanel();
            this.exitPane.add((Component)this.getExitButton(), null);
        }
        return this.exitPane;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getClockPane() {
        if (this.clockPane == null) {
            this.clockLabel = new JLabel();
            this.clockLabel.setText("STOPPED");
            this.clockLabel.setForeground(Color.red);
            this.clockLabel.setFont(new Font("Dialog", 1, 16));
            this.clockLabel.setPreferredSize(new Dimension(82, 21));
            this.clockLabel.setHorizontalAlignment(0);
            this.clockPane = new JPanel();
            this.clockPane.setLayout(new BorderLayout());
            this.clockPane.setPreferredSize(new Dimension(85, 34));
            this.clockPane.add((Component)this.clockLabel, "Center");
        }
        return this.clockPane;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TeamView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    private void updateClockLabel(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TeamView.this.clockLabel.setText(string);
                TeamView.this.clockLabel.setToolTipText(string);
            }
        });
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TeamView.this.messageLabel.setText(string);
                TeamView.this.messageLabel.setToolTipText(string);
            }
        });
    }

    private class ContestTimeListenerImplementation
    implements IContestTimeListener {
        private ContestTimeListenerImplementation() {
        }

        public void contestTimeAdded(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        public void contestTimeRemoved(ContestTimeEvent event) {
        }

        public void contestTimeChanged(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        public void contestStarted(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        public void contestStopped(ContestTimeEvent event) {
            if (TeamView.this.isThisSite(event.getSiteNumber())) {
                TeamView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }
    }
}

