/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.server;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.ui.ConnectionsPane;
import edu.csus.ecs.pc2.ui.ContestTimesPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.LoginsPane;
import edu.csus.ecs.pc2.ui.OptionsPanel;
import edu.csus.ecs.pc2.ui.PlaybackPane;
import edu.csus.ecs.pc2.ui.ReportPane;
import edu.csus.ecs.pc2.ui.SitesPanel;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ServerView
extends JFrame
implements UIPlugin {
    public static final String SVN_ID = "$Id: ServerView.java 1795 2009-02-28 19:42:45Z laned $";
    private IInternalContest model = null;
    private IInternalController controller = null;
    private static final long serialVersionUID = 4547574494017009634L;
    private JPanel mainViewPane = null;
    private JTabbedPane mainTabbedPane = null;
    private LogWindow logWindow = null;
    private Log log = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private JPanel exitPanel = null;
    private JButton exitButton = null;
    private LogWindow securityAlertLogWindow = null;

    public ServerView() {
        this.initialize();
    }

    private void logDebugMessage(String message) {
        this.log.log(Log.DEBUG, message);
    }

    private void initialize() {
        this.setSize(new Dimension(518, 400));
        this.setDefaultCloseOperation(0);
        this.setTitle("Server View");
        this.setContentPane(this.getMainViewPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ServerView.this.promptAndExit();
            }
        });
        this.overRideLookAndFeel();
        FrameUtilities.centerFrameTop(this);
        this.setVisible(true);
        VersionInfo versionInfo = new VersionInfo();
        this.showMessage("Version " + versionInfo.getVersionNumber() + " (Build " + versionInfo.getBuildNumber() + ")");
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2 Server Module");
        if (result == 0) {
            this.log.info("Server " + this.model.getSiteNumber() + " halted");
            System.exit(0);
        }
    }

    private String accountText(Account account) {
        if (account == null) {
            return "null";
        }
        return account.getClientId().toString();
    }

    private JPanel getMainViewPane() {
        if (this.mainViewPane == null) {
            this.mainViewPane = new JPanel();
            this.mainViewPane.setLayout(new BorderLayout());
            this.mainViewPane.add((Component)this.getMainTabbedPane(), "Center");
            this.mainViewPane.add((Component)this.getMessagePanel(), "North");
        }
        return this.mainViewPane;
    }

    public void windowToRight(JFrame sourceFrame) {
        int rightX = sourceFrame.getX() + sourceFrame.getWidth();
        this.setLocation(rightX, this.getY());
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    void updateFrameTitle(final boolean turnButtonsOn) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (turnButtonsOn) {
                    ServerView.this.setTitle("PC^2 Server (Site " + ServerView.this.model.getSiteNumber() + ") [STARTED] Build " + new VersionInfo().getBuildNumber());
                } else {
                    ServerView.this.setTitle("PC^2 Server (Site " + ServerView.this.model.getSiteNumber() + ") [STOPPED] Build " + new VersionInfo().getBuildNumber());
                }
            }
        });
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.model = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
        this.updateFrameTitle(this.model.getContestTime().isContestRunning());
        if (this.logWindow == null) {
            this.logWindow = new LogWindow();
        }
        this.logWindow.setContestAndController(this.model, this.controller);
        this.logWindow.setTitle("Log " + this.model.getClientId().toString());
        this.initializeSecurityAlertWindow(inContest);
        this.model.addRunListener(new RunListenerImplementation());
        this.model.addAccountListener(new AccountListenerImplementation());
        this.model.addLoginListener(new LoginListenerImplementation());
        this.model.addSiteListener(new SiteListenerImplementation());
        this.model.addContestTimeListener(new ContestTimeListenerImplementation());
        SitesPanel sitesPanel = new SitesPanel();
        this.addUIPlugin(this.getMainTabbedPane(), "Sites", sitesPanel);
        ContestTimesPane contestTimesPane = new ContestTimesPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Times", contestTimesPane);
        LoginsPane loginsPane = new LoginsPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Logins", loginsPane);
        ConnectionsPane connectionsPane = new ConnectionsPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Connections", connectionsPane);
        ReportPane reportPane = new ReportPane();
        this.addUIPlugin(this.getMainTabbedPane(), "Reports", reportPane);
        PlaybackPane playbackPane = new PlaybackPane();
        this.addUIPlugin("Replay", playbackPane);
        OptionsPanel optionsPanel = new OptionsPanel();
        this.addUIPlugin(this.getMainTabbedPane(), "Options", optionsPanel);
        optionsPanel.setLogWindow(this.logWindow);
        optionsPanel.setSecurityLogWindow(this.securityAlertLogWindow);
    }

    protected void initializeSecurityAlertWindow(IInternalContest inContest) {
        if (this.securityAlertLogWindow == null) {
            this.securityAlertLogWindow = new LogWindow(inContest.getSecurityAlertLog());
        }
        this.securityAlertLogWindow.setContestAndController(inContest, this.controller);
        this.securityAlertLogWindow.setTitle("Contest Security Alerts " + inContest.getClientId().toString());
        VersionInfo versionInfo = new VersionInfo();
        this.securityAlertLogWindow.getLog().info("Security Log Started " + versionInfo.getSystemVersionInfo());
    }

    public String getPluginTitle() {
        return "Server Main GUI";
    }

    protected void showLog(boolean showLogWindow) {
        this.logWindow.setVisible(showLogWindow);
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        plugin.setParentFrame(this);
        plugin.setContestAndController(this.model, this.controller);
        tabbedPane.add((Component)plugin, tabTitle);
    }

    public void addUIPlugin(String tabTitle, JPanePlugin plugin) {
        plugin.setParentFrame(this);
        plugin.setContestAndController(this.model, this.controller);
        this.getMainTabbedPane().add((Component)plugin, tabTitle);
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(5);
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(borderLayout);
            this.messagePanel.setPreferredSize(new Dimension(40, 40));
            this.messagePanel.add((Component)this.messageLabel, "Center");
            this.messagePanel.add((Component)this.getExitPanel(), "East");
        }
        return this.messagePanel;
    }

    private JPanel getExitPanel() {
        if (this.exitPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setVgap(5);
            this.exitPanel = new JPanel();
            this.exitPanel.setPreferredSize(new Dimension(75, 36));
            this.exitPanel.setLayout(flowLayout);
            this.exitPanel.add((Component)this.getExitButton(), null);
        }
        return this.exitPanel;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ServerView.this.messageLabel.setText(string);
            }
        });
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event Event " + (Object)((Object)accountEvent.getAction()) + " " + ServerView.this.accountText(accountEvent.getAccount()));
        }

        public void accountModified(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event Event " + (Object)((Object)accountEvent.getAction()) + " " + ServerView.this.accountText(accountEvent.getAccount()));
        }

        public void accountsAdded(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event Event " + (Object)((Object)accountEvent.getAction()) + " " + accountEvent.getAccounts().length + " accounts");
        }

        public void accountsModified(AccountEvent accountEvent) {
            ServerView.this.logDebugMessage("Account Event Event " + (Object)((Object)accountEvent.getAction()) + " " + accountEvent.getAccounts().length + " accounts");
        }
    }

    public class ContestTimeListenerImplementation
    implements IContestTimeListener {
        private int ignoreEvent = 0;

        public void contestTimeAdded(ContestTimeEvent event) {
            ++this.ignoreEvent;
        }

        public void contestTimeRemoved(ContestTimeEvent event) {
            ++this.ignoreEvent;
        }

        public void contestTimeChanged(ContestTimeEvent event) {
            ++this.ignoreEvent;
        }

        public void contestStarted(ContestTimeEvent event) {
            if (ServerView.this.model.getSiteNumber() == event.getSiteNumber()) {
                ServerView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }

        public void contestStopped(ContestTimeEvent event) {
            if (ServerView.this.model.getSiteNumber() == event.getSiteNumber()) {
                ServerView.this.updateFrameTitle(event.getContestTime().isContestRunning());
            }
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
            ServerView.this.logDebugMessage("Login Event " + (Object)((Object)event.getAction()) + " " + event.getClientId());
        }

        public void loginRemoved(LoginEvent event) {
            ServerView.this.logDebugMessage("Login Event " + (Object)((Object)event.getAction()) + " " + event.getClientId());
        }

        public void loginDenied(LoginEvent event) {
            ServerView.this.logDebugMessage("Login Event " + (Object)((Object)event.getAction()) + " " + event.getClientId());
        }
    }

    private class RunListenerImplementation
    implements IRunListener {
        private RunListenerImplementation() {
        }

        public void runAdded(RunEvent event) {
            ServerView.this.logDebugMessage("Run Event " + event.getRun() + " ADDED ");
        }

        public void runChanged(RunEvent event) {
            ServerView.this.logDebugMessage("Run Event " + event.getRun() + " CHANGED ");
        }

        public void runRemoved(RunEvent event) {
            ServerView.this.logDebugMessage("Run Event " + event.getRun() + " REMOVED ");
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        public void siteAdded(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteRemoved(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteLoggedOn(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteLoggedOff(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteChanged(SiteEvent event) {
            ServerView.this.logDebugMessage("Site Event " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }
    }
}

