/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.admin;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.AccountsPane;
import edu.csus.ecs.pc2.ui.AutoJudgesPane;
import edu.csus.ecs.pc2.ui.BalloonSettingsPane;
import edu.csus.ecs.pc2.ui.ClarificationsPane;
import edu.csus.ecs.pc2.ui.ConnectionsPane;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.ContestInformationPane;
import edu.csus.ecs.pc2.ui.ContestTimesPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.GroupsPane;
import edu.csus.ecs.pc2.ui.ICPCPane;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.JudgementsPanel;
import edu.csus.ecs.pc2.ui.LanguagesPane;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.LoginsPane;
import edu.csus.ecs.pc2.ui.OptionsPanel;
import edu.csus.ecs.pc2.ui.ProblemsPane;
import edu.csus.ecs.pc2.ui.ReportPane;
import edu.csus.ecs.pc2.ui.RunsPanel;
import edu.csus.ecs.pc2.ui.SitesPanel;
import edu.csus.ecs.pc2.ui.StandingsHTMLPane;
import edu.csus.ecs.pc2.ui.StandingsPane;
import edu.csus.ecs.pc2.ui.TeamStatusPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdministratorView
extends JFrame
implements UIPlugin,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private IInternalContest contest;
    private IInternalController controller;
    private JPanel jPanel = null;
    private JTabbedPane mainTabbedPanel = null;
    private JPanel statusPanel = null;
    private JPanel topPanel = null;
    private JButton exitButton = null;
    private LogWindow logWindow = null;
    private LogWindow securityAlertLogWindow = null;
    private JPanel clockPane = null;
    private JPanel exitButtonPane = null;
    private JLabel clockLabel = null;
    private JPanel padPane = null;
    private ContestClockDisplay contestClockDisplay = null;
    private JTabbedPane configureContestTabbedPane = null;
    private JTabbedPane runContestTabbedPane = null;
    private static final Color ACTIVE_TAB_COLOR = Color.BLUE;
    private static final Color INACTIVE_TAB_COLOR = Color.GRAY;

    public AdministratorView() {
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setBounds(new Rectangle(0, 0, 754, 500));
        this.setContentPane(this.getJPanel());
        this.setTitle("PC^2 Administrator");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AdministratorView.this.promptAndExit();
            }
        });
        this.getMainTabbedPanel().addChangeListener(this);
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AdministratorView.this.logWindow == null) {
                    AdministratorView.this.logWindow = new LogWindow();
                }
                AdministratorView.this.logWindow.setContestAndController(AdministratorView.this.contest, AdministratorView.this.controller);
                AdministratorView.this.logWindow.setTitle("Log " + AdministratorView.this.contest.getClientId().toString());
                AdministratorView.this.initializeSecurityAlertWindow(AdministratorView.this.contest);
                int fontSize = AdministratorView.this.getMainTabbedPanel().getFont().getSize();
                AdministratorView.this.getMainTabbedPanel().setFont(AdministratorView.this.getMainTabbedPanel().getFont().deriveFont(1, fontSize + 6));
                AdministratorView.this.getMainTabbedPanel().setTitleAt(0, "Configure Contest");
                AdministratorView.this.getMainTabbedPanel().setForegroundAt(0, ACTIVE_TAB_COLOR);
                AdministratorView.this.getMainTabbedPanel().setTitleAt(1, "Run Contest");
                AdministratorView.this.getMainTabbedPanel().setForegroundAt(1, INACTIVE_TAB_COLOR);
                AccountsPane accountsPane = new AccountsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Accounts", accountsPane);
                AutoJudgesPane autoJudgesPane = new AutoJudgesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Auto Judge", autoJudgesPane);
                GroupsPane groupsPane = new GroupsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Groups", groupsPane);
                ICPCPane icpcPane = new ICPCPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "ICPC", icpcPane);
                JudgementsPanel judgementsPanel = new JudgementsPanel();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Judgements", judgementsPanel);
                LanguagesPane languagesPane = new LanguagesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Languages", languagesPane);
                ReportPane reportPaneC = new ReportPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Reports", reportPaneC);
                BalloonSettingsPane balloonSettingsPane = new BalloonSettingsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Notifications", balloonSettingsPane);
                ProblemsPane problemsPane = new ProblemsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Problems", problemsPane);
                ContestTimesPane contestTimesPane = new ContestTimesPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Times", contestTimesPane);
                ContestInformationPane contestInformationPane = new ContestInformationPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getConfigureContestTabbedPane(), "Settings", contestInformationPane);
                RunsPanel runsPane = new RunsPanel();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Runs", runsPane);
                ClarificationsPane clarificationsPane = new ClarificationsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Clarifications", clarificationsPane);
                ConnectionsPane connectionsPane = new ConnectionsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Connections", connectionsPane);
                LoginsPane loginsPane = new LoginsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Logins", loginsPane);
                ReportPane reportPane = new ReportPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Reports", reportPane);
                SitesPanel sitesPanel = new SitesPanel();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Sites", sitesPanel);
                StandingsHTMLPane standingsHTMLPane = new StandingsHTMLPane("full.xsl");
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Standings HTML", standingsHTMLPane);
                StandingsPane standingsPane = new StandingsPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Standings", standingsPane);
                TeamStatusPane teamStatusPane = new TeamStatusPane();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Team Status", teamStatusPane);
                OptionsPanel optionsPanel = new OptionsPanel();
                AdministratorView.this.addUIPlugin(AdministratorView.this.getRunContestTabbedPane(), "Options", optionsPanel);
                optionsPanel.setLogWindow(AdministratorView.this.logWindow);
                optionsPanel.setSecurityLogWindow(AdministratorView.this.securityAlertLogWindow);
                AdministratorView.this.contestClockDisplay = new ContestClockDisplay(AdministratorView.this.controller.getLog(), AdministratorView.this.contest.getContestTime(), AdministratorView.this.contest.getSiteNumber(), false, null);
                AdministratorView.this.contestClockDisplay.setContestAndController(AdministratorView.this.contest, AdministratorView.this.controller);
                AdministratorView.this.contestClockDisplay.addLabeltoUpdateList(AdministratorView.this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, AdministratorView.this.contest.getSiteNumber());
                AdministratorView.this.setTitle("PC^2 " + AdministratorView.this.contest.getTitle() + " Build " + new VersionInfo().getBuildNumber());
                AdministratorView.this.setVisible(true);
            }
        });
    }

    protected void initializeSecurityAlertWindow(IInternalContest inContest) {
        if (this.securityAlertLogWindow == null) {
            this.securityAlertLogWindow = new LogWindow(inContest.getSecurityAlertLog());
        }
        this.securityAlertLogWindow.setContestAndController(inContest, this.controller);
        this.securityAlertLogWindow.setTitle("Contest Security Alerts " + inContest.getClientId().toString());
        VersionInfo versionInfo = new VersionInfo();
        this.securityAlertLogWindow.getLog().info("Security Log Started " + versionInfo.getSystemVersionInfo());
    }

    public String getPluginTitle() {
        return "Admin GUI";
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getMainTabbedPanel(), "Center");
            this.jPanel.add((Component)this.getTopPanel(), "North");
            this.jPanel.add((Component)this.getStatusPanel(), "South");
        }
        return this.jPanel;
    }

    private JTabbedPane getMainTabbedPanel() {
        if (this.mainTabbedPanel == null) {
            this.mainTabbedPanel = new JTabbedPane();
            this.mainTabbedPanel.addTab(null, null, this.getConfigureContestTabbedPane(), null);
            this.mainTabbedPanel.addTab(null, null, this.getRunContestTabbedPane(), null);
        }
        return this.mainTabbedPanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setPreferredSize(new Dimension(30, 30));
        }
        return this.statusPanel;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.setPreferredSize(new Dimension(45, 45));
            this.topPanel.add((Component)this.getClockPane(), "Center");
            this.topPanel.add((Component)this.getExitButtonPane(), "East");
            this.topPanel.add((Component)this.getPadPane(), "West");
        }
        return this.topPanel;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AdministratorView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        if (plugin == null) {
            return;
        }
        try {
            plugin.setParentFrame(this);
            plugin.setContestAndController(this.contest, this.controller);
            tabbedPane.add((Component)plugin, tabTitle);
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception loading plugin ", e);
            JOptionPane.showMessageDialog(this, "Error loading " + plugin.getPluginTitle());
        }
    }

    protected void showLog(boolean showLogWindow) {
        this.logWindow.setVisible(showLogWindow);
    }

    private JPanel getClockPane() {
        if (this.clockPane == null) {
            this.clockLabel = new JLabel();
            this.clockLabel.setText("JLabel");
            this.clockLabel.setFont(new Font("Dialog", 1, 18));
            this.clockPane = new JPanel();
            this.clockPane.setLayout(new BorderLayout());
            this.clockPane.add((Component)this.clockLabel, "Center");
        }
        return this.clockPane;
    }

    private JPanel getExitButtonPane() {
        if (this.exitButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setVgap(10);
            this.exitButtonPane = new JPanel();
            this.exitButtonPane.setLayout(flowLayout);
            this.exitButtonPane.add((Component)this.getExitButton(), null);
        }
        return this.exitButtonPane;
    }

    private JPanel getPadPane() {
        if (this.padPane == null) {
            this.padPane = new JPanel();
            this.padPane.setPreferredSize(new Dimension(10, 10));
        }
        return this.padPane;
    }

    private JTabbedPane getConfigureContestTabbedPane() {
        if (this.configureContestTabbedPane == null) {
            this.configureContestTabbedPane = new JTabbedPane();
            this.configureContestTabbedPane.setToolTipText("");
            this.configureContestTabbedPane.setName("Configure Contest");
        }
        return this.configureContestTabbedPane;
    }

    private JTabbedPane getRunContestTabbedPane() {
        if (this.runContestTabbedPane == null) {
            this.runContestTabbedPane = new JTabbedPane();
        }
        return this.runContestTabbedPane;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.getMainTabbedPanel()) {
            int tabCount = this.getMainTabbedPanel().getTabCount();
            int i = 0;
            while (i < tabCount) {
                this.getMainTabbedPanel().setForegroundAt(i, INACTIVE_TAB_COLOR);
                ++i;
            }
        } else {
            throw new RuntimeException("Unexpected ChangeEvent: " + e);
        }
        int selectedTab = this.getMainTabbedPanel().getSelectedIndex();
        this.getMainTabbedPanel().setForegroundAt(selectedTab, ACTIVE_TAB_COLOR);
    }

    public static void main(String[] args) {
        AdministratorView administratorView = new AdministratorView();
        administratorView.setVisible(true);
    }
}

