/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TeamStatusPane
extends JPanePlugin {
    private static final long serialVersionUID = -7316022621929111614L;
    private JPanel messagePane = null;
    private JPanel centerPane = null;
    private JLabel messageLabel = null;
    public static final Color NO_CONTACT_COLOR = Color.red;
    public static final Color HAS_LOGGED_IN_COLOR = Color.pink;
    public static final Color HAS_SUBMITTED_RUNS_ONLY_COLOR = Color.blue;
    public static final Color HAS_SUBMITTED_CLARS_ONLY_COLOR = Color.orange;
    public static final Color HAS_SUBMITTED_RUNS_AND_CLARS_COLOR = Color.green;
    private JPanel teamStatusPane = null;
    private JPanel buttonPane = null;
    private JButton clearButton = null;
    private JPanel statusTitlePane = null;
    private JLabel statusTitleLabel = null;
    private JPanel stateDescriptonPane = null;
    private JLabel nocontactLabel = null;
    private JLabel hasLoggedInLabel = null;
    private JLabel submittedRunsLabel = null;
    private JLabel submittedClarsLabel = null;
    private JLabel readyLabel = null;
    private JButton reloadButton = null;
    private JComboBox siteComboBox = null;
    private Site allSitesSite = new Site("All Sites", 0);
    private boolean populatingGUI = false;

    public TeamStatusPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(583, 193));
        this.add((Component)this.getTeamStatusPane(), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        FrameUtilities.centerFrameTop(this);
        this.nocontactLabel.setForeground(NO_CONTACT_COLOR);
        this.hasLoggedInLabel.setForeground(HAS_LOGGED_IN_COLOR);
        this.submittedRunsLabel.setForeground(HAS_SUBMITTED_RUNS_ONLY_COLOR);
        this.submittedClarsLabel.setForeground(HAS_SUBMITTED_CLARS_ONLY_COLOR);
        this.readyLabel.setForeground(HAS_SUBMITTED_RUNS_AND_CLARS_COLOR);
    }

    public String getPluginTitle() {
        return "Teams Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(30, 30));
            this.messagePane.add((Component)this.messageLabel, "North");
        }
        return this.messagePane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setVgap(5);
            gridLayout.setHgap(5);
            gridLayout.setColumns(8);
            this.centerPane = new JPanel();
            this.centerPane.setBorder(BorderFactory.createBevelBorder(1));
            this.centerPane.setLayout(gridLayout);
        }
        return this.centerPane;
    }

    private void populateGUI() {
        if (this.populatingGUI) {
            return;
        }
        this.populatingGUI = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    TeamStatusPane.this.repopulateSitePulldown();
                    TeamStatusPane.this.repopulateGrid(true);
                }
                catch (Exception e) {
                    TeamStatusPane.this.getController().getLog().log(Log.WARNING, "Exception logged ", e);
                }
                TeamStatusPane.this.populatingGUI = false;
            }
        });
    }

    protected void repopulateSitePulldown() {
        int selectedIndex = this.getSiteComboBox().getSelectedIndex();
        this.getSiteComboBox().removeAllItems();
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        this.getSiteComboBox().addItem(this.allSitesSite);
        Site[] siteArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            this.getSiteComboBox().addItem(site);
            ++n2;
        }
        if (selectedIndex > -1) {
            this.getSiteComboBox().setSelectedIndex(selectedIndex);
        } else {
            this.getSiteComboBox().setSelectedIndex(0);
        }
    }

    private void repopulateGrid(boolean populate) {
        boolean allSites = false;
        Site site = null;
        if (this.getSiteComboBox().getSelectedIndex() < 1) {
            allSites = true;
        } else {
            site = (Site)this.getSiteComboBox().getSelectedItem();
        }
        this.getCenterPane().removeAll();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setColumns(8);
        gridLayout.setRows(0);
        gridLayout.setVgap(5);
        gridLayout.setHgap(5);
        this.centerPane.setLayout(gridLayout);
        AccountList accountList = new AccountList();
        accountList.generateNewAccounts(ClientType.Type.TEAM, 25, 1, AccountList.PasswordType.JOE, 1, true);
        Vector<Account> vectorAccounts = allSites ? this.getContest().getAccounts(ClientType.Type.TEAM) : this.getContest().getAccounts(ClientType.Type.TEAM, site.getSiteNumber());
        Account[] accounts = vectorAccounts.toArray(new Account[vectorAccounts.size()]);
        Arrays.sort(accounts, new AccountComparator());
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            JLabel teamLabel = new JLabel();
            ClientId clientId = account.getClientId();
            String teamName = clientId.getName();
            if (allSites) {
                teamName = "S" + clientId.getSiteNumber() + " " + teamName;
            }
            String toolTipText = "No submissions";
            Color teamStatusColor = NO_CONTACT_COLOR;
            if (populate) {
                toolTipText = teamName;
                Run[] runs = this.getContest().getRuns(clientId);
                if (runs.length > 0) {
                    toolTipText = String.valueOf(toolTipText) + " " + runs.length + " runs";
                }
                Clarification[] clarifications = this.getContest().getClarifications(clientId);
                ArrayList<Clarification> myClarList = new ArrayList<Clarification>();
                if (clarifications.length > 0) {
                    int i = 0;
                    while (i < clarifications.length) {
                        Clarification clarification = clarifications[i];
                        if (clarification.getSubmitter().equals(clientId)) {
                            myClarList.add(clarification);
                        }
                        ++i;
                    }
                    clarifications = myClarList.toArray(new Clarification[myClarList.size()]);
                    if (clarifications.length > 0) {
                        toolTipText = String.valueOf(toolTipText) + " " + clarifications.length + " clarifications ";
                    }
                }
                teamStatusColor = this.getStatusColor(clientId, runs, clarifications);
            }
            toolTipText = String.valueOf(toolTipText) + " (" + account.getDisplayName() + ")";
            teamLabel.setText(teamName);
            teamLabel.setForeground(teamStatusColor);
            teamLabel.setToolTipText(toolTipText);
            this.centerPane.add(teamName, teamLabel);
            ++n2;
        }
        this.centerPane.repaint();
    }

    private Color getStatusColor(ClientId clientId, Run[] runs, Clarification[] clarifications) {
        Color outColor = NO_CONTACT_COLOR;
        if (runs.length > 0 && clarifications.length > 0) {
            outColor = HAS_SUBMITTED_RUNS_AND_CLARS_COLOR;
        } else if (runs.length > 0) {
            outColor = HAS_SUBMITTED_RUNS_ONLY_COLOR;
        } else if (clarifications.length > 0) {
            outColor = HAS_SUBMITTED_CLARS_ONLY_COLOR;
        } else if (this.getContest().isLocalLoggedIn(clientId)) {
            outColor = HAS_LOGGED_IN_COLOR;
        }
        return outColor;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.populateGUI();
        this.getContest().addLoginListener(new LoginListenerImplementation());
        this.getContest().addRunListener(new RunListenerImplementation());
        this.getContest().addClarificationListener(new ClarificationListenerImplementation());
    }

    private JPanel getTeamStatusPane() {
        if (this.teamStatusPane == null) {
            this.teamStatusPane = new JPanel();
            this.teamStatusPane.setLayout(new BorderLayout());
            this.teamStatusPane.add((Component)this.getStatusTitlePane(), "North");
            this.teamStatusPane.add((Component)this.getCenterPane(), "Center");
        }
        return this.teamStatusPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setHgap(25);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout1);
            this.buttonPane.add((Component)this.getClearButton(), null);
            this.buttonPane.add((Component)this.getReloadButton(), null);
            this.buttonPane.add((Component)this.getSiteComboBox(), null);
        }
        return this.buttonPane;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("Clear");
            this.clearButton.setToolTipText("Clear display");
            this.clearButton.setMnemonic(67);
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TeamStatusPane.this.promptAndClearButtons();
                }
            });
        }
        return this.clearButton;
    }

    protected void promptAndClearButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TeamStatusPane.this.repopulateGrid(false);
            }
        });
    }

    private JPanel getStatusTitlePane() {
        if (this.statusTitlePane == null) {
            this.statusTitleLabel = new JLabel();
            this.statusTitleLabel.setText("STATUS");
            this.statusTitleLabel.setPreferredSize(new Dimension(32, 22));
            this.statusTitleLabel.setFont(new Font("Dialog", 1, 14));
            this.statusTitleLabel.setHorizontalAlignment(0);
            this.statusTitlePane = new JPanel();
            this.statusTitlePane.setLayout(new BorderLayout());
            this.statusTitlePane.setPreferredSize(new Dimension(50, 50));
            this.statusTitlePane.add((Component)this.statusTitleLabel, "North");
            this.statusTitlePane.add((Component)this.getStateDescriptonPane(), "Center");
        }
        return this.statusTitlePane;
    }

    private JPanel getStateDescriptonPane() {
        if (this.stateDescriptonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(30);
            this.readyLabel = new JLabel();
            this.readyLabel.setText("READY");
            this.readyLabel.setFont(new Font("Dialog", 1, 14));
            this.submittedClarsLabel = new JLabel();
            this.submittedClarsLabel.setText("Submitted Clar(s)");
            this.submittedClarsLabel.setFont(new Font("Dialog", 1, 14));
            this.submittedRunsLabel = new JLabel();
            this.submittedRunsLabel.setText("Submitted Run(s)");
            this.submittedRunsLabel.setFont(new Font("Dialog", 1, 14));
            this.hasLoggedInLabel = new JLabel();
            this.hasLoggedInLabel.setText("Has Logged In");
            this.hasLoggedInLabel.setFont(new Font("Dialog", 1, 14));
            this.nocontactLabel = new JLabel();
            this.nocontactLabel.setText("No Contact");
            this.nocontactLabel.setFont(new Font("Dialog", 1, 14));
            this.stateDescriptonPane = new JPanel();
            this.stateDescriptonPane.setLayout(flowLayout);
            this.stateDescriptonPane.add((Component)this.nocontactLabel, null);
            this.stateDescriptonPane.add((Component)this.hasLoggedInLabel, null);
            this.stateDescriptonPane.add((Component)this.submittedRunsLabel, null);
            this.stateDescriptonPane.add((Component)this.submittedClarsLabel, null);
            this.stateDescriptonPane.add((Component)this.readyLabel, null);
        }
        return this.stateDescriptonPane;
    }

    private JButton getReloadButton() {
        if (this.reloadButton == null) {
            this.reloadButton = new JButton();
            this.reloadButton.setText("Reload");
            this.reloadButton.setToolTipText("Reload display");
            this.reloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TeamStatusPane.this.populateGUI();
                }
            });
        }
        return this.reloadButton;
    }

    private JComboBox getSiteComboBox() {
        if (this.siteComboBox == null) {
            this.siteComboBox = new JComboBox();
            this.siteComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TeamStatusPane.this.populateGUI();
                }
            });
        }
        return this.siteComboBox;
    }

    private class ClarificationListenerImplementation
    implements IClarificationListener {
        private ClarificationListenerImplementation() {
        }

        public void clarificationAdded(ClarificationEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void clarificationChanged(ClarificationEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void clarificationRemoved(ClarificationEvent event) {
            TeamStatusPane.this.populateGUI();
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void loginRemoved(LoginEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void loginDenied(LoginEvent event) {
            TeamStatusPane.this.populateGUI();
        }
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void runChanged(RunEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void runRemoved(RunEvent event) {
            TeamStatusPane.this.populateGUI();
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        public void siteAdded(SiteEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void siteRemoved(SiteEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void siteChanged(SiteEvent event) {
            TeamStatusPane.this.populateGUI();
        }

        public void siteLoggedOn(SiteEvent event) {
        }

        public void siteLoggedOff(SiteEvent event) {
        }
    }
}

