/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.SubmissionBiffPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SubmissionBiffFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 1330276750746647066L;
    private IInternalContest contest;
    private IInternalController controller;
    private SubmissionBiffPane submissionBiffPane = null;

    public SubmissionBiffFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(505, 159));
        this.setContentPane(this.getSubmissionBiffPane());
        this.setTitle("Unjudged Submissions");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.submissionBiffPane.setContestAndController(this.contest, this.controller);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SubmissionBiffFrame.this.setTitle("PC^2 Unjudged Submission Count Judge " + SubmissionBiffFrame.this.contest.getTitle());
            }
        });
    }

    public String getPluginTitle() {
        return "Submission Biff";
    }

    private SubmissionBiffPane getSubmissionBiffPane() {
        if (this.submissionBiffPane == null) {
            this.submissionBiffPane = new SubmissionBiffPane();
        }
        return this.submissionBiffPane;
    }

    public void setFontSize(int pointSize) {
        this.getSubmissionBiffPane().setFontSize(pointSize);
    }

    public void setShowNoRunsTitle(boolean showNoRunsTitle) {
        this.getSubmissionBiffPane().setShowNoRunsTitle(showNoRunsTitle);
    }
}

