/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.Executable;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import edu.csus.ecs.pc2.ui.judge.JudgeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelectJudgementPane
extends JPanePlugin {
    private static final long serialVersionUID = 4560827389735037513L;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private Run run = null;
    private RunFiles runFiles = null;
    private JPanel generalPane = null;
    private Log log = null;
    private JButton executeButton = null;
    private JButton viewSourceButton = null;
    private JButton extractButton = null;
    private Executable executable;
    private JComboBox judgementComboBox = null;
    private JLabel runInfoLabel = null;
    private JLabel judgementLabel = null;
    private JLabel statusLabel = null;
    private JLabel statusTitleLabel = null;
    private JLabel problemTitleLabel = null;
    private JLabel languageTitleLabel = null;
    private JLabel elapsedTitleLabel = null;
    private IFileViewer sourceViewer;
    private IFileViewer answerFileViewer;
    private IFileViewer dataFileViewer;
    private boolean populatingGUI = true;
    private JLabel problemNameLabel = null;
    private JLabel languageNameLabel = null;
    private JLabel elapsedTimeLabel = null;
    private JCheckBox notifyTeamCheckBox = null;
    private PermissionList permissionList = new PermissionList();
    private JLabel validatorRecommendsLabel = null;
    private JLabel validatorJudgementLabel = null;
    private JButton acceptValidatorJudgementButton = null;
    private JPanel eastPane = null;
    private JButton viewDataFileButton = null;
    private JButton viewAnswerFileButton = null;
    private JButton shellButton = null;
    private DisplayTeamName displayTeamName = null;
    private IFileViewer executableFileViewer;

    public SelectJudgementPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(720, 294));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getGeneralPane(), "Center");
        this.add((Component)this.getEastPane(), "East");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.displayTeamName = new DisplayTeamName();
        this.displayTeamName.setContestAndController(inContest, inController);
        this.initializePermissions();
    }

    public String getPluginTitle() {
        return "Edit Run Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(50);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getOkButton(), null);
            this.buttonPane.add((Component)this.getExecuteButton(), null);
            this.buttonPane.add((Component)this.getExtractButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private Run getRunFromFields() {
        return this.run;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setEnabled(false);
            this.okButton.setActionCommand("Ok");
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SelectJudgementPane.this.confirmInconsistentJudgements()) {
                        SelectJudgementPane.this.updateRun();
                    }
                }
            });
        }
        return this.okButton;
    }

    private void cancelRun() {
        this.enableUpdateButtons(false);
        this.closeViewerWindows();
        Run newRun = this.getRunFromFields();
        JudgeView.setAlreadyJudgingRun(false);
        if (this.runFiles != null) {
            this.getController().cancelRun(newRun);
        }
    }

    private boolean confirmInconsistentJudgements() {
        if (this.getAcceptValidatorJudgementButton().isVisible()) {
            String message;
            int result;
            Judgement autoJudgement;
            ElementId elementId = this.getValidatorResult(this.validatorJudgementLabel.getText());
            Judgement manualJudgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            if (!manualJudgement.equals(autoJudgement = this.getContest().getJudgement(elementId)) && (result = JOptionPane.showConfirmDialog(this, message = "You selected Update but the validator returned " + autoJudgement + ".  Did you intend to accept " + manualJudgement + "?")) != 0) {
                return false;
            }
        }
        return true;
    }

    private void closeViewerWindows() {
        this.closeViewer(this.dataFileViewer);
        this.closeViewer(this.answerFileViewer);
        this.closeViewer(this.sourceViewer);
        this.closeViewer(this.executableFileViewer);
    }

    private void closeViewer(IFileViewer fileViewer) {
        if (fileViewer != null) {
            fileViewer.dispose();
        }
    }

    protected void updateRun() {
        Run newRun = this.getRunFromFields();
        this.enableUpdateButtons(false);
        this.closeViewerWindows();
        JudgementRecord judgementRecord = null;
        RunResultFiles runResultFiles = null;
        if (this.judgementChanged()) {
            newRun.setStatus(Run.RunStates.JUDGED);
            boolean solved = this.getJudgementComboBox().getSelectedIndex() == 0;
            Judgement judgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            judgementRecord = new JudgementRecord(judgement.getElementId(), this.getContest().getClientId(), solved, false);
            judgementRecord.setSendToTeam(this.getNotifyTeamCheckBox().isSelected());
            ExecutionData executionData = null;
            if (this.executable != null) {
                executionData = this.executable.getExecutionData();
            }
            runResultFiles = new RunResultFiles(this.run, this.run.getProblemId(), judgementRecord, executionData);
        }
        JudgeView.setAlreadyJudgingRun(false);
        this.getController().submitRunJudgement(newRun, judgementRecord, runResultFiles);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    public void handleCancelButton() {
        if (this.runFiles == null) {
            JudgeView.setAlreadyJudgingRun(false);
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
            return;
        }
        if (this.getOkButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Run modified, save changes?", "Confirm Choice");
            if (result == 0 && this.confirmInconsistentJudgements()) {
                this.updateRun();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
            if (result == 1) {
                this.cancelRun();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
        } else {
            this.cancelRun();
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        }
    }

    public Run getRun() {
        return this.run;
    }

    public void setRun(final Run run) {
        ContestInformation contestInformation = this.getContest().getContestInformation();
        this.displayTeamName.setTeamDisplayMask(contestInformation.getTeamDisplayMode());
        this.run = run;
        this.showMessage("Waiting for run...");
        FrameUtilities.waitCursor(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectJudgementPane.this.populateGUI(run);
                SelectJudgementPane.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateGUI(Run theRun) {
        this.populatingGUI = true;
        this.showValidatorControls(false);
        if (theRun != null) {
            this.getOkButton().setVisible(true);
            String teamName = this.getTeamDisplayName(theRun.getSubmitter());
            this.runInfoLabel.setText("Run " + theRun.getNumber() + " (Site " + theRun.getSiteNumber() + ") from " + teamName);
            this.statusLabel.setText(this.run.getStatus().toString());
            this.elapsedTimeLabel.setText(new Long(this.run.getElapsedMins()).toString());
            this.problemNameLabel.setText(this.getContest().getProblem(this.run.getProblemId()).toString());
            this.languageNameLabel.setText(this.getContest().getLanguage(this.run.getLanguageId()).toString());
            boolean showFile = this.getProblemDataFiles() != null && this.getProblemDataFiles().getJudgesAnswerFile() != null;
            this.getViewAnswerFileButton().setVisible(showFile);
            showFile = this.getProblemDataFiles() != null && this.getProblemDataFiles().getJudgesDataFile() != null;
            this.getViewDataFileButton().setVisible(showFile);
            this.getViewSourceButton().setVisible(true);
        } else {
            this.getOkButton().setVisible(false);
            this.runInfoLabel.setText("Could not get run");
            this.statusLabel.setText("");
            this.elapsedTimeLabel.setText("");
            this.problemNameLabel.setText("");
            this.languageNameLabel.setText("");
            this.getViewAnswerFileButton().setVisible(false);
            this.getViewDataFileButton().setVisible(false);
            this.getViewSourceButton().setVisible(false);
        }
        this.populateComboBoxes();
        this.populatingGUI = false;
    }

    protected void regularCursor() {
        FrameUtilities.regularCursor(this);
    }

    private void populateComboBoxes() {
        int selectedIndex = -1;
        int index = 0;
        this.getJudgementComboBox().removeAllItems();
        if (this.run == null) {
            return;
        }
        selectedIndex = -1;
        index = 0;
        ElementId judgementId = null;
        if (this.run.isJudged()) {
            judgementId = this.run.getJudgementRecord().getJudgementId();
        }
        Judgement[] judgementArray = this.getContest().getJudgements();
        int n = judgementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement judgement = judgementArray[n2];
            this.getJudgementComboBox().addItem(judgement);
            if (judgement.getElementId().equals(judgementId)) {
                selectedIndex = index;
            }
            ++index;
            ++n2;
        }
        this.getJudgementComboBox().setSelectedIndex(selectedIndex);
    }

    public void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        this.getExecuteButton().setEnabled(this.runFiles != null);
        this.getViewSourceButton().setEnabled(this.runFiles != null);
        this.getJudgementComboBox().setEnabled(this.runFiles != null);
        this.getNotifyTeamCheckBox().setEnabled(this.runFiles != null);
        this.okButton.setEnabled(editedText);
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.run != null) {
            enableButton |= this.judgementChanged();
        }
        this.enableUpdateButtons(enableButton);
    }

    private boolean judgementChanged() {
        if (this.run.isJudged()) {
            Judgement judgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            if (judgement != null) {
                return !this.run.getJudgementRecord().getJudgementId().equals(judgement.getElementId());
            }
        } else if (this.getJudgementComboBox().getSelectedIndex() > -1) {
            return true;
        }
        return false;
    }

    private JPanel getGeneralPane() {
        if (this.generalPane == null) {
            this.validatorJudgementLabel = new JLabel();
            this.validatorJudgementLabel.setText("Validator Judgement");
            this.validatorJudgementLabel.setHorizontalAlignment(2);
            this.validatorJudgementLabel.setSize(new Dimension(346, 19));
            this.validatorJudgementLabel.setLocation(new Point(180, 171));
            this.validatorJudgementLabel.setForeground(Color.BLUE);
            this.validatorRecommendsLabel = new JLabel();
            this.validatorRecommendsLabel.setText("Validator Recommends");
            this.validatorRecommendsLabel.setHorizontalAlignment(4);
            this.validatorRecommendsLabel.setLocation(new Point(17, 171));
            this.validatorRecommendsLabel.setSize(new Dimension(150, 19));
            this.validatorRecommendsLabel.setForeground(Color.BLUE);
            this.elapsedTimeLabel = new JLabel();
            this.elapsedTimeLabel.setText("Elapsed");
            this.elapsedTimeLabel.setSize(new Dimension(254, 19));
            this.elapsedTimeLabel.setLocation(new Point(180, 60));
            this.elapsedTimeLabel.setHorizontalAlignment(2);
            this.languageNameLabel = new JLabel();
            this.languageNameLabel.setText("Language");
            this.languageNameLabel.setSize(new Dimension(254, 19));
            this.languageNameLabel.setLocation(new Point(180, 110));
            this.languageNameLabel.setHorizontalAlignment(2);
            this.problemNameLabel = new JLabel();
            this.problemNameLabel.setText("Problem");
            this.problemNameLabel.setSize(new Dimension(254, 19));
            this.problemNameLabel.setLocation(new Point(180, 85));
            this.problemNameLabel.setHorizontalAlignment(2);
            this.elapsedTitleLabel = new JLabel();
            this.elapsedTitleLabel.setText("Elapsed");
            this.elapsedTitleLabel.setLocation(new Point(17, 60));
            this.elapsedTitleLabel.setSize(new Dimension(150, 19));
            this.elapsedTitleLabel.setHorizontalAlignment(4);
            this.languageTitleLabel = new JLabel();
            this.languageTitleLabel.setText("Language");
            this.languageTitleLabel.setLocation(new Point(17, 110));
            this.languageTitleLabel.setSize(new Dimension(150, 19));
            this.languageTitleLabel.setHorizontalAlignment(4);
            this.problemTitleLabel = new JLabel();
            this.problemTitleLabel.setText("Problem");
            this.problemTitleLabel.setLocation(new Point(17, 85));
            this.problemTitleLabel.setSize(new Dimension(150, 19));
            this.problemTitleLabel.setHorizontalAlignment(4);
            this.statusTitleLabel = new JLabel();
            this.statusTitleLabel.setHorizontalAlignment(4);
            this.statusTitleLabel.setLocation(new Point(17, 32));
            this.statusTitleLabel.setSize(new Dimension(150, 19));
            this.statusTitleLabel.setText("Status");
            this.statusLabel = new JLabel();
            this.statusLabel.setHorizontalAlignment(2);
            this.statusLabel.setSize(new Dimension(254, 19));
            this.statusLabel.setLocation(new Point(180, 32));
            this.statusLabel.setText("JLabel");
            this.judgementLabel = new JLabel();
            this.judgementLabel.setHorizontalAlignment(4);
            this.judgementLabel.setLocation(new Point(17, 137));
            this.judgementLabel.setSize(new Dimension(150, 19));
            this.judgementLabel.setText("Judgement");
            this.runInfoLabel = new JLabel();
            this.runInfoLabel.setBounds(new Rectangle(5, -1, 424, 25));
            this.runInfoLabel.setHorizontalAlignment(0);
            this.runInfoLabel.setFont(new Font("Dialog", 1, 14));
            this.runInfoLabel.setText("Run Info");
            this.generalPane = new JPanel();
            this.generalPane.setLayout(null);
            this.generalPane.add((Component)this.getJudgementComboBox(), null);
            this.generalPane.add((Component)this.runInfoLabel, null);
            this.generalPane.add((Component)this.judgementLabel, null);
            this.generalPane.add((Component)this.statusLabel, null);
            this.generalPane.add((Component)this.statusTitleLabel, null);
            this.generalPane.add((Component)this.problemTitleLabel, null);
            this.generalPane.add((Component)this.languageTitleLabel, null);
            this.generalPane.add((Component)this.elapsedTitleLabel, null);
            this.generalPane.add((Component)this.problemNameLabel, null);
            this.generalPane.add((Component)this.languageNameLabel, null);
            this.generalPane.add((Component)this.elapsedTimeLabel, null);
            this.generalPane.add((Component)this.getNotifyTeamCheckBox(), null);
            this.generalPane.add((Component)this.validatorRecommendsLabel, null);
            this.generalPane.add((Component)this.validatorJudgementLabel, null);
            this.generalPane.add((Component)this.getAcceptValidatorJudgementButton(), null);
        }
        return this.generalPane;
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectJudgementPane.this.messageLabel.setText(message);
            }
        });
    }

    public JButton getExecuteButton() {
        if (this.executeButton == null) {
            this.executeButton = new JButton();
            this.executeButton.setText("Execute");
            this.executeButton.setMnemonic(88);
            this.executeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable(){

                        public void run() {
                            SelectJudgementPane.this.executeRun();
                        }
                    }).start();
                }
            });
        }
        return this.executeButton;
    }

    private JButton getViewSourceButton() {
        if (this.viewSourceButton == null) {
            this.viewSourceButton = new JButton();
            this.viewSourceButton.setText("View Source");
            this.viewSourceButton.setMnemonic(86);
            this.viewSourceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.viewSourceFile();
                }
            });
        }
        return this.viewSourceButton;
    }

    private JButton getExtractButton() {
        if (this.extractButton == null) {
            this.extractButton = new JButton();
            this.extractButton.setText("Extract");
            this.extractButton.setMnemonic(84);
            this.extractButton.setVisible(false);
            this.extractButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.extractRun();
                }
            });
        }
        return this.extractButton;
    }

    protected void extractRun() {
        this.showMessage("Would have extracted run");
    }

    protected void executeRun() {
        System.gc();
        this.executable = new Executable(this.getContest(), this.getController(), this.run, this.runFiles);
        if (this.executableFileViewer != null) {
            this.executableFileViewer.dispose();
        }
        this.executableFileViewer = this.executable.execute();
        this.showValidatorControls(false);
        if (this.executable.isValidationSuccess()) {
            String results = this.executable.getValidationResults();
            if (results != null && results.trim().length() > 1) {
                if (results.equalsIgnoreCase("accepted")) {
                    results = this.getContest().getJudgements()[0].getDisplayName();
                }
                this.validatorJudgementLabel.setText(results);
                this.showValidatorControls(true);
            } else {
                this.log.warning("execute indicated validator success but getValidationResults returns \"\" or null");
            }
        }
        if (!this.getContest().getProblem(this.run.getProblemId()).isHideOutputWindow()) {
            this.executableFileViewer.setVisible(true);
        }
    }

    public void setRunAndFiles(Run theRun, RunFiles runFiles2) {
        FrameUtilities.regularCursor(this);
        this.showMessage("");
        this.log.info("Fetched run " + theRun + " to edit");
        this.run = theRun;
        this.runFiles = runFiles2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectJudgementPane.this.populateGUI(SelectJudgementPane.this.run);
                SelectJudgementPane.this.enableUpdateButtons(false);
            }
        });
    }

    private JComboBox getJudgementComboBox() {
        if (this.judgementComboBox == null) {
            this.judgementComboBox = new JComboBox();
            this.judgementComboBox.setLocation(new Point(180, 135));
            this.judgementComboBox.setSize(new Dimension(263, 22));
            this.judgementComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.enableUpdateButton();
                }
            });
        }
        return this.judgementComboBox;
    }

    private String getExecuteDirectoryName() {
        Executable tempEexecutable = new Executable(this.getContest(), this.getController(), this.run, this.runFiles);
        return tempEexecutable.getExecuteDirectoryName();
    }

    private void createAndViewFile(IFileViewer fileViewer, SerializedFile file, String title, boolean visible) {
        String targetDirectory = this.getExecuteDirectoryName();
        Utilities.insureDir(targetDirectory);
        String targetFileName = String.valueOf(targetDirectory) + File.separator + file.getName();
        try {
            file.writeFile(targetFileName);
            if (new File(targetFileName).isFile()) {
                fileViewer.addFilePane(title, targetFileName);
            } else {
                fileViewer.addTextPane(title, "Could not create file at " + targetFileName);
            }
        }
        catch (IOException e) {
            fileViewer.addTextPane(title, "Could not create file at " + targetFileName + "Exception " + e.getMessage());
        }
        if (visible) {
            fileViewer.setVisible(true);
        }
    }

    private JCheckBox getNotifyTeamCheckBox() {
        if (this.notifyTeamCheckBox == null) {
            this.notifyTeamCheckBox = new JCheckBox();
            this.notifyTeamCheckBox.setBounds(new Rectangle(171, 199, 112, 21));
            this.notifyTeamCheckBox.setSelected(true);
            this.notifyTeamCheckBox.setText("Notify Team");
        }
        return this.notifyTeamCheckBox;
    }

    private String getTeamDisplayName(ClientId clientId) {
        if (this.isJudge() && this.isTeam(clientId)) {
            return this.displayTeamName.getDisplayName(clientId);
        }
        return clientId.getName();
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private boolean isTeam(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    private boolean isJudge(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean isJudge() {
        return this.isJudge(this.getContest().getClientId());
    }

    private void initializePermissions() {
        Account account = this.getContest().getAccount(this.getContest().getClientId());
        if (account != null) {
            this.permissionList.clearAndLoadPermissions(account.getPermissionList());
        }
    }

    private void updateGUIperPermissions() {
        this.extractButton.setVisible(this.isAllowed(Permission.Type.EXTRACT_RUNS));
    }

    private JButton getAcceptValidatorJudgementButton() {
        if (this.acceptValidatorJudgementButton == null) {
            this.acceptValidatorJudgementButton = new JButton();
            this.acceptValidatorJudgementButton.setBounds(new Rectangle(313, 199, 140, 23));
            this.acceptValidatorJudgementButton.setText("Accept Validator");
            this.acceptValidatorJudgementButton.setPreferredSize(new Dimension(150, 26));
            this.acceptValidatorJudgementButton.setForeground(Color.BLUE);
            this.acceptValidatorJudgementButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.acceptValidatorJudgement();
                }
            });
        }
        return this.acceptValidatorJudgementButton;
    }

    private void showValidatorControls(boolean showControls) {
        this.getAcceptValidatorJudgementButton().setVisible(showControls);
        this.validatorJudgementLabel.setVisible(showControls);
        this.validatorRecommendsLabel.setVisible(showControls);
    }

    private ElementId getValidatorResult(String results) {
        ElementId elementId = this.getContest().getJudgements()[1].getElementId();
        Judgement[] judgementArray = this.getContest().getJudgements();
        int n = judgementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement judgement = judgementArray[n2];
            if (judgement.getDisplayName().equals(results)) {
                elementId = judgement.getElementId();
            }
            ++n2;
        }
        Judgement yesJudgement = this.getContest().getJudgements()[0];
        if (yesJudgement.getDisplayName().equalsIgnoreCase(results)) {
            elementId = yesJudgement.getElementId();
        }
        return elementId;
    }

    protected void acceptValidatorJudgement() {
        String message;
        int result;
        Judgement autoJudgement;
        Judgement manualJudgement;
        Run newRun = this.getRunFromFields();
        this.enableUpdateButtons(false);
        this.closeViewerWindows();
        RunResultFiles runResultFiles = null;
        JudgementRecord judgementRecord = null;
        String results = this.validatorJudgementLabel.getText();
        boolean solved = false;
        ElementId elementId = this.getValidatorResult(results);
        Judgement yesJudgement = this.getContest().getJudgements()[0];
        if (yesJudgement.getElementId().equals(elementId)) {
            solved = true;
        }
        if (this.getJudgementComboBox().getSelectedIndex() > -1 && !(manualJudgement = (Judgement)this.getJudgementComboBox().getSelectedItem()).equals(autoJudgement = this.getContest().getJudgement(elementId)) && (result = JOptionPane.showConfirmDialog(this, message = "You selected Accept Validator but have manually selected " + manualJudgement + ".  Did you intend to accept " + autoJudgement + "?")) != 0) {
            this.enableUpdateButtons(true);
            return;
        }
        newRun.setStatus(Run.RunStates.JUDGED);
        judgementRecord = new JudgementRecord(elementId, this.getContest().getClientId(), solved, true);
        judgementRecord.setValidatorResultString(results);
        judgementRecord.setSendToTeam(this.getNotifyTeamCheckBox().isSelected());
        JudgeView.setAlreadyJudgingRun(false);
        runResultFiles = new RunResultFiles(newRun, newRun.getProblemId(), judgementRecord, this.executable.getExecutionData());
        this.getController().submitRunJudgement(newRun, judgementRecord, runResultFiles);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getEastPane() {
        if (this.eastPane == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setVgap(25);
            this.eastPane = new JPanel();
            this.eastPane.setLayout(flowLayout1);
            this.eastPane.setPreferredSize(new Dimension(150, 132));
            this.eastPane.add((Component)this.getViewSourceButton(), null);
            this.eastPane.add((Component)this.getViewDataFileButton(), null);
            this.eastPane.add((Component)this.getViewAnswerFileButton(), null);
            this.eastPane.add((Component)this.getShellButton(), null);
        }
        return this.eastPane;
    }

    private JButton getViewDataFileButton() {
        if (this.viewDataFileButton == null) {
            this.viewDataFileButton = new JButton();
            this.viewDataFileButton.setText("View Data File");
            this.viewDataFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.viewDataFile();
                }
            });
        }
        return this.viewDataFileButton;
    }

    private JButton getViewAnswerFileButton() {
        if (this.viewAnswerFileButton == null) {
            this.viewAnswerFileButton = new JButton();
            this.viewAnswerFileButton.setText("View Answer File");
            this.viewAnswerFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.viewAnswerFile();
                }
            });
        }
        return this.viewAnswerFileButton;
    }

    private ProblemDataFiles getProblemDataFiles() {
        Problem problem = this.getContest().getProblem(this.run.getProblemId());
        return this.getContest().getProblemDataFile(problem);
    }

    protected void viewSourceFile() {
        if (this.sourceViewer != null) {
            this.sourceViewer.dispose();
        }
        this.sourceViewer = new MultipleFileViewer(this.getController().getLog());
        this.createAndViewFiles(this.sourceViewer, this.runFiles.getMainFile(), "Main File (" + this.runFiles.getMainFile().getName() + ")", this.runFiles.getOtherFiles());
    }

    private void createAndViewFiles(IFileViewer fileViewer, SerializedFile file, String title, SerializedFile[] otherFiles) {
        if (otherFiles != null && otherFiles.length > 0) {
            int i = otherFiles.length;
            while (i > 0) {
                this.createAndViewFile(fileViewer, otherFiles[i - 1], otherFiles[i - 1].getName(), false);
                --i;
            }
        }
        this.createAndViewFile(fileViewer, file, title, false);
        fileViewer.setSelectedIndex(0);
        fileViewer.setVisible(true);
    }

    protected void viewDataFile() {
        if (this.getProblemDataFiles() != null) {
            if (this.getProblemDataFiles().getJudgesDataFile() != null) {
                if (this.dataFileViewer != null) {
                    this.dataFileViewer.dispose();
                }
                this.dataFileViewer = new MultipleFileViewer(this.getController().getLog());
                this.createAndViewFile(this.dataFileViewer, this.getProblemDataFiles().getJudgesDataFile(), "Judge's data file", true);
            } else {
                JOptionPane.showMessageDialog(this, "No data file defined");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No data file defined");
        }
    }

    protected void viewAnswerFile() {
        if (this.getProblemDataFiles() != null) {
            if (this.getProblemDataFiles().getJudgesAnswerFile() != null) {
                if (this.answerFileViewer != null) {
                    this.answerFileViewer.dispose();
                }
                this.answerFileViewer = new MultipleFileViewer(this.getController().getLog());
                this.createAndViewFile(this.answerFileViewer, this.getProblemDataFiles().getJudgesAnswerFile(), "Judge's answer file", true);
            } else {
                JOptionPane.showMessageDialog(this, "No Answer File defined");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No Answer File defined");
        }
    }

    private JButton getShellButton() {
        if (this.shellButton == null) {
            this.shellButton = new JButton();
            this.shellButton.setText("Shell ");
            this.shellButton.setVisible(false);
            this.shellButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPane.this.shellToExecuteDirectory();
                }
            });
        }
        return this.shellButton;
    }

    protected void shellToExecuteDirectory() {
        String executeDir = this.getExecuteDirectoryName();
        File runDir = new File(executeDir);
        Utilities.insureDir(executeDir);
        String fs = File.separator;
        String winShellCommand = String.valueOf(fs) + "windows" + fs + "system32" + fs + "cmd.exe";
        String unixShellCommand = String.valueOf(fs) + "bin" + fs + "sh";
        String[] env = null;
        if (new File(winShellCommand).exists()) {
            try {
                Runtime.getRuntime().exec("cmd.exe", env, runDir);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to run command " + winShellCommand + " " + e.getMessage());
                e.printStackTrace();
            }
        } else if (new File(unixShellCommand).exists()) {
            try {
                Runtime.getRuntime().exec(unixShellCommand, env, runDir);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to run command " + unixShellCommand + " " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected void setRunFiles(RunFiles inRunFiles) {
        this.runFiles = inRunFiles;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectJudgementPane.this.updateGUIperPermissions();
                }
            });
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectJudgementPane.this.updateGUIperPermissions();
                }
            });
        }
    }
}

