/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.imports.LoadAccounts;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ReviewAccountLoadFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -172535000039944166L;
    private JPanel buttonPane = null;
    private MCLB accountListBox = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private Log log;
    private IInternalController controller;
    private IInternalContest contest;
    private Account[] accounts;
    private static final String CHANGE_BEGIN = "";
    private static final String CHANGE_END = "*";
    private JButton acceptButton = null;
    private JPanel jPanel = null;
    private JButton cancelButton = null;
    private String loadedFileName;

    public ReviewAccountLoadFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(800, 1000));
        this.setPreferredSize(new Dimension(800, 1000));
        this.setTitle("Review Account Loading");
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getJPanel());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ReviewAccountLoadFrame.this.handleCancel();
            }
        });
        FrameUtilities.centerFrameTop(this);
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getAcceptButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private MCLB getAccountListBox() {
        if (this.accountListBox == null) {
            this.accountListBox = new MCLB();
            Object[] cols = new Object[]{"Site", "Type", "Account Id", "Display Name", "Password", "Permissions", "Group", "Alias"};
            this.accountListBox.addColumns(cols);
            this.accountListBox.autoSizeAllColumns();
        }
        return this.accountListBox;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText(CHANGE_BEGIN);
            this.messageLabel.setFont(new Font("Dialog", 1, 12));
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReviewAccountLoadFrame.this.messageLabel.setText(string);
                ReviewAccountLoadFrame.this.messageLabel.setToolTipText(string);
                ReviewAccountLoadFrame.this.messageLabel.setForeground(Color.BLACK);
            }
        });
    }

    private void showMessage(final String string, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReviewAccountLoadFrame.this.messageLabel.setText(string);
                ReviewAccountLoadFrame.this.messageLabel.setForeground(color);
            }
        });
    }

    public String getPluginTitle() {
        return "Review Account Load Frame";
    }

    private Account[] getAllAccounts() {
        ArrayList<Account> allAccounts = new ArrayList<Account>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            if (this.contest.getAccounts(ctype).size() > 0) {
                Vector<Account> accountsOfType = this.contest.getAccounts(ctype);
                allAccounts.addAll(accountsOfType);
            }
            ++n2;
        }
        Account[] accountList = allAccounts.toArray(new Account[allAccounts.size()]);
        return accountList;
    }

    public void setFile(String filename) {
        this.loadedFileName = filename;
        this.showMessage("Loaded " + filename);
        this.getAccountListBox().removeAllRows();
        this.log.info("Attempting to load accounts from file: " + filename);
        LoadAccounts loadAccounts = new LoadAccounts();
        this.getAcceptButton().setEnabled(false);
        try {
            this.accounts = loadAccounts.fromTSVFile(filename, this.getAllAccounts(), this.contest.getGroups());
            if (this.accounts != null) {
                Arrays.sort(this.accounts, new AccountComparator());
                Account[] accountArray = this.accounts;
                int n = this.accounts.length;
                int n2 = 0;
                while (n2 < n) {
                    Account account = accountArray[n2];
                    this.updateAccountRow(account);
                    ++n2;
                }
                this.log.info("found " + this.accounts.length + " account(s)");
                if (this.accounts.length > 0) {
                    this.getAcceptButton().setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
            this.showErrorMessage(e.getMessage());
        }
        FrameUtilities.centerFrameTop(this);
        this.setVisible(true);
    }

    private void showErrorMessage(String msg) {
        this.showMessage(msg, Color.RED);
    }

    public void updateAccountRow(final Account account) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = ReviewAccountLoadFrame.this.buildAccountRow(account);
                int rowNumber = ReviewAccountLoadFrame.this.accountListBox.getIndexByKey(account.getClientId());
                if (rowNumber == -1) {
                    ReviewAccountLoadFrame.this.accountListBox.addRow(objects, account.getClientId());
                } else {
                    ReviewAccountLoadFrame.this.accountListBox.replaceRow(objects, rowNumber);
                }
                ReviewAccountLoadFrame.this.accountListBox.autoSizeAllColumns();
            }
        });
    }

    protected Object[] buildAccountRow(Account account) {
        try {
            int cols = this.accountListBox.getColumnCount();
            Object[] s = new String[cols];
            ClientId clientId = account.getClientId();
            Account accountOrig = this.contest.getAccount(clientId);
            s[0] = this.getSiteTitle(CHANGE_BEGIN + account.getSiteNumber());
            s[1] = clientId.getClientType().toString().toLowerCase();
            s[2] = CHANGE_BEGIN + clientId.getClientNumber();
            s[3] = this.getTeamDisplayName(accountOrig).equalsIgnoreCase(this.getTeamDisplayName(account)) ? this.getTeamDisplayName(account) : this.getTeamDisplayName(account) + CHANGE_END;
            s[4] = accountOrig.getPassword().equalsIgnoreCase(account.getPassword()) ? account.getPassword() : account.getPassword() + CHANGE_END;
            String perms = CHANGE_BEGIN;
            if (account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                perms = String.valueOf(perms) + "DISPLAY_ON_SCOREBOARD ";
            }
            if (account.isAllowed(Permission.Type.LOGIN)) {
                perms = String.valueOf(perms) + "LOGIN ";
            }
            if (account.isAllowed(Permission.Type.CHANGE_PASSWORD)) {
                perms = String.valueOf(perms) + "CHANGE_PASSWORD ";
            }
            s[5] = perms.trim();
            s[6] = accountOrig.getGroupId() == null && account.getGroupId() == null ? CHANGE_BEGIN : (account.getGroupId() == null ? "<removed>*" : (accountOrig.getGroupId() == null ? this.contest.getGroup(account.getGroupId()).toString() + CHANGE_END : (account.getGroupId().equals(accountOrig.getGroupId()) ? this.contest.getGroup(account.getGroupId()).toString() : this.contest.getGroup(account.getGroupId()).toString() + CHANGE_END)));
            s[7] = accountOrig.getAliasName() == null && account.getAliasName() == null ? CHANGE_BEGIN : (account.getAliasName() == null ? "<removed>*" : (accountOrig.getAliasName() == null ? account.getAliasName() + CHANGE_END : (account.getAliasName().equals(accountOrig.getAliasName()) ? account.getAliasName() : account.getAliasName() + CHANGE_END)));
            return s;
        }
        catch (Exception exception) {
            StaticLog.getLog().log(Log.INFO, "Exception in buildAccountRow()", exception);
            return null;
        }
    }

    private String getSiteTitle(String string) {
        return "Site " + string;
    }

    private String getTeamDisplayName(Account account) {
        if (account != null) {
            return account.getDisplayName();
        }
        return "Unknown";
    }

    private JButton getAcceptButton() {
        if (this.acceptButton == null) {
            this.acceptButton = new JButton();
            this.acceptButton.setText("Accept");
            this.acceptButton.setMnemonic(65);
            this.acceptButton.setEnabled(false);
            this.acceptButton.setPreferredSize(new Dimension(100, 26));
            this.acceptButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReviewAccountLoadFrame.this.handleAccept();
                }
            });
        }
        return this.acceptButton;
    }

    protected void handleAccept() {
        this.controller.updateAccounts(this.accounts);
        this.log.info("Loaded " + this.accounts.length + " from file " + this.loadedFileName);
        this.dispose();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)((Object)this.getAccountListBox()), "Center");
            this.jPanel.add((Component)this.getMessagePane(), "North");
            this.jPanel.add((Component)this.getButtonPane(), "South");
        }
        return this.jPanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.setPreferredSize(new Dimension(100, 26));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReviewAccountLoadFrame.this.handleCancel();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancel() {
        this.dispose();
    }
}

