/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.AccountPermissionReport;
import edu.csus.ecs.pc2.core.report.AccountsReport;
import edu.csus.ecs.pc2.core.report.AllReports;
import edu.csus.ecs.pc2.core.report.BalloonDeliveryReport;
import edu.csus.ecs.pc2.core.report.BalloonSettingsReport;
import edu.csus.ecs.pc2.core.report.BalloonSummaryReport;
import edu.csus.ecs.pc2.core.report.ClarificationsReport;
import edu.csus.ecs.pc2.core.report.ClientSettingsReport;
import edu.csus.ecs.pc2.core.report.ContestAnalysisReport;
import edu.csus.ecs.pc2.core.report.ContestReport;
import edu.csus.ecs.pc2.core.report.EvaluationReport;
import edu.csus.ecs.pc2.core.report.ExtractPlaybackLoadFilesReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedReport;
import edu.csus.ecs.pc2.core.report.GroupsReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.InternalDumpReport;
import edu.csus.ecs.pc2.core.report.JudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.JudgementReport;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.report.ListRunLanguages;
import edu.csus.ecs.pc2.core.report.LoginReport;
import edu.csus.ecs.pc2.core.report.OldRunsReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.RunJudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.RunsByTeamReport;
import edu.csus.ecs.pc2.core.report.RunsReport;
import edu.csus.ecs.pc2.core.report.RunsReport5;
import edu.csus.ecs.pc2.core.report.SolutionsByProblemReport;
import edu.csus.ecs.pc2.core.report.StandingsReport;
import edu.csus.ecs.pc2.ui.EditFilterFrame;
import edu.csus.ecs.pc2.ui.EditFilterPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ReportPane
extends JPanePlugin {
    private static final long serialVersionUID = -5165297328068331675L;
    private JPanel jPanel = null;
    private JPanel buttonPane = null;
    private JPanel mainPane = null;
    private JButton viewReportButton = null;
    private JCheckBox breakdownBySiteCheckbox = null;
    private JPanel reportChoicePane = null;
    private JComboBox reportsComboBox = null;
    private JLabel messageLabel = null;
    private IReport[] listOfReports;
    private Log log;
    private String reportDirectory = "reports";
    private JCheckBox thisClientFilterButton = null;
    private JPanel filterPane = null;
    private JPanel filterButtonPane = null;
    private JButton editReportFilter = null;
    private JLabel filterLabel = null;
    private Filter filter = new Filter();
    private EditFilterFrame editFilterFrame = null;

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public ReportPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(505, 291));
        this.add((Component)this.getJPanel(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainPane(), "Center");
        Vector<IReport> reports = new Vector<IReport>();
        reports.add(new AccountsReport());
        reports.add(new BalloonSummaryReport());
        reports.add(new AllReports());
        reports.add(new ContestReport());
        reports.add(new ContestAnalysisReport());
        reports.add(new SolutionsByProblemReport());
        reports.add(new ListRunLanguages());
        reports.add(new FastestSolvedReport());
        reports.add(new StandingsReport());
        reports.add(new LoginReport());
        reports.add(new RunsReport());
        reports.add(new ClarificationsReport());
        reports.add(new ProblemsReport());
        reports.add(new LanguagesReport());
        reports.add(new JudgementReport());
        reports.add(new RunsByTeamReport());
        reports.add(new BalloonSettingsReport());
        reports.add(new ClientSettingsReport());
        reports.add(new GroupsReport());
        reports.add(new EvaluationReport());
        reports.add(new OldRunsReport());
        reports.add(new RunsReport5());
        reports.add(new AccountPermissionReport());
        reports.add(new BalloonDeliveryReport());
        reports.add(new ExtractPlaybackLoadFilesReport());
        reports.add(new RunJudgementNotificationsReport());
        reports.add(new JudgementNotificationsReport());
        reports.add(new InternalDumpReport());
        this.listOfReports = reports.toArray(new IReport[reports.size()]);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getEditFilterFrame().setContestAndController(inContest, inController);
        this.refreshGUI();
    }

    protected void refreshGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReportPane.this.refreshReportComboBox();
            }
        });
    }

    private void refreshReportComboBox() {
        this.getReportsComboBox().removeAllItems();
        IReport[] iReportArray = this.listOfReports;
        int n = this.listOfReports.length;
        int n2 = 0;
        while (n2 < n) {
            IReport report = iReportArray[n2];
            this.getReportsComboBox().addItem(report.getReportTitle());
            ++n2;
        }
        this.getReportsComboBox().setSelectedIndex(0);
    }

    public String getPluginTitle() {
        return "Reports Pane";
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setPreferredSize(new Dimension(30, 30));
            this.jPanel.add((Component)this.messageLabel, "Center");
        }
        return this.jPanel;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setPreferredSize(new Dimension(45, 45));
            this.buttonPane.add((Component)this.getViewReportButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(null);
            this.mainPane.add((Component)this.getBreakdownBySiteCheckbox(), null);
            this.mainPane.add((Component)this.getReportChoicePane(), null);
            this.mainPane.add((Component)this.getThisClientFilterButton(), null);
            this.mainPane.add((Component)this.getFilterPane(), null);
        }
        return this.mainPane;
    }

    private JButton getViewReportButton() {
        if (this.viewReportButton == null) {
            this.viewReportButton = new JButton();
            this.viewReportButton.setText("View Report");
            this.viewReportButton.setToolTipText("View the selected Report");
            this.viewReportButton.setMnemonic(86);
            this.viewReportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ReportPane.this.getBreakdownBySiteCheckbox().isSelected()) {
                        ReportPane.this.generateSelectedReportBySite();
                    } else {
                        ReportPane.this.generateSelectedReport();
                    }
                }
            });
        }
        return this.viewReportButton;
    }

    private String getFileName(IReport selectedReport) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return "report." + reportName + "." + simpleDateFormat.format(new Date()) + ".txt";
    }

    private void viewFile(String filename, String title) {
        MultipleFileViewer multipleFileViewer = new MultipleFileViewer(this.log);
        multipleFileViewer.addFilePane(title, filename);
        multipleFileViewer.setTitle("PC^2 Report (Build " + new VersionInfo().getBuildNumber() + ")");
        FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
        multipleFileViewer.setVisible(true);
    }

    protected void generateSelectedReport() {
        try {
            IReport selectedReport = null;
            String selectedReportTitle = (String)this.getReportsComboBox().getSelectedItem();
            IReport[] iReportArray = this.listOfReports;
            int n = this.listOfReports.length;
            int n2 = 0;
            while (n2 < n) {
                IReport report = iReportArray[n2];
                if (selectedReportTitle.equals(report.getReportTitle())) {
                    selectedReport = report;
                }
                ++n2;
            }
            String filename = this.getFileName(selectedReport);
            File reportDirectoryFile = new File(this.getReportDirectory());
            if (reportDirectoryFile.exists()) {
                if (reportDirectoryFile.isDirectory()) {
                    filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
                }
            } else if (reportDirectoryFile.mkdirs()) {
                filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
            }
            selectedReport.setContestAndController(this.getContest(), this.getController());
            selectedReport.setFilter(this.filter);
            selectedReport.createReportFile(filename, this.filter);
            this.viewFile(filename, selectedReport.getReportTitle());
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to output report, check logs");
        }
    }

    protected void generateSelectedReportBySite() {
        try {
            IReport selectedReport = null;
            String selectedReportTitle = (String)this.getReportsComboBox().getSelectedItem();
            IReport[] iReportArray = this.listOfReports;
            int n = this.listOfReports.length;
            int n2 = 0;
            while (n2 < n) {
                IReport report = iReportArray[n2];
                if (selectedReportTitle.equals(report.getReportTitle())) {
                    selectedReport = report;
                }
                ++n2;
            }
            String filename = this.getFileName(selectedReport);
            File reportDirectoryFile = new File(this.getReportDirectory());
            if (reportDirectoryFile.exists()) {
                if (reportDirectoryFile.isDirectory()) {
                    filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
                }
            } else if (reportDirectoryFile.mkdirs()) {
                filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
            printWriter.println();
            printWriter.println(new VersionInfo().getSystemName());
            printWriter.println("Date: " + Utilities.getL10nDateTime());
            printWriter.println(new VersionInfo().getSystemVersionInfo());
            printWriter.println();
            printWriter.println("Report " + selectedReport.getReportTitle() + " Report ");
            printWriter.println();
            selectedReport.setContestAndController(this.getContest(), this.getController());
            Site[] sites = this.getContest().getSites();
            Arrays.sort(sites, new SiteComparatorBySiteNumber());
            Site[] siteArray = sites;
            int n3 = sites.length;
            int n4 = 0;
            while (n4 < n3) {
                Site site = siteArray[n4];
                Filter reportFitler = new Filter();
                try {
                    reportFitler.addSite(site);
                    selectedReport.setFilter(reportFitler);
                    printWriter.println();
                    printWriter.println("Report   " + selectedReport.getReportTitle() + " Report ");
                    printWriter.println("For site " + site.getSiteNumber() + " " + site.getDisplayName());
                    selectedReport.writeReport(printWriter);
                }
                catch (Exception e) {
                    printWriter.println("Exception in report: " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
                ++n4;
            }
            printWriter.println();
            printWriter.println("end report");
            this.viewFile(filename, selectedReport.getReportTitle());
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to output report, check logs");
        }
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ReportPane.this.messageLabel.setText(string);
            }
        });
    }

    private JCheckBox getBreakdownBySiteCheckbox() {
        if (this.breakdownBySiteCheckbox == null) {
            this.breakdownBySiteCheckbox = new JCheckBox();
            this.breakdownBySiteCheckbox.setBounds(new Rectangle(21, 80, 187, 21));
            this.breakdownBySiteCheckbox.setMnemonic(70);
            this.breakdownBySiteCheckbox.setToolTipText("Break down by site");
            this.breakdownBySiteCheckbox.setText("Breakdown by site");
            this.breakdownBySiteCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReportPane.this.changeSiteFiltering();
                }
            });
        }
        return this.breakdownBySiteCheckbox;
    }

    protected void changeSiteFiltering() {
    }

    private JPanel getReportChoicePane() {
        if (this.reportChoicePane == null) {
            this.reportChoicePane = new JPanel();
            this.reportChoicePane.setLayout(new BorderLayout());
            this.reportChoicePane.setBounds(new Rectangle(22, 9, 445, 53));
            this.reportChoicePane.setBorder(BorderFactory.createTitledBorder(null, "Reports", 0, 0, null, null));
            this.reportChoicePane.add((Component)this.getReportsComboBox(), "Center");
        }
        return this.reportChoicePane;
    }

    private JComboBox getReportsComboBox() {
        if (this.reportsComboBox == null) {
            this.reportsComboBox = new JComboBox();
        }
        return this.reportsComboBox;
    }

    private JCheckBox getThisClientFilterButton() {
        if (this.thisClientFilterButton == null) {
            this.thisClientFilterButton = new JCheckBox();
            this.thisClientFilterButton.setBounds(new Rectangle(21, 114, 192, 21));
            this.thisClientFilterButton.setMnemonic(67);
            this.thisClientFilterButton.setText("Filter for this client only");
            this.thisClientFilterButton.setVisible(false);
            this.thisClientFilterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReportPane.this.changeThisClientFiltering();
                }
            });
        }
        return this.thisClientFilterButton;
    }

    protected void changeThisClientFiltering() {
        if (this.thisClientFilterButton.isSelected()) {
            this.filter.clearAccountList();
        } else {
            this.filter.setFilterOn();
            this.filter.clearAccountList();
            this.filter.addAccount(this.getContest().getClientId());
        }
        this.refreshFilterLabel();
    }

    private JPanel getFilterPane() {
        if (this.filterPane == null) {
            this.filterLabel = new JLabel();
            this.filterLabel.setText("");
            this.filterLabel.setHorizontalAlignment(0);
            this.filterPane = new JPanel();
            this.filterPane.setLayout(new BorderLayout());
            this.filterPane.setBounds(new Rectangle(233, 76, 231, 93));
            this.filterPane.setBorder(BorderFactory.createTitledBorder(null, "Filter", 0, 0, null, null));
            this.filterPane.add((Component)this.getFilterButtonPane(), "South");
            this.filterPane.add((Component)this.filterLabel, "Center");
        }
        return this.filterPane;
    }

    private JPanel getFilterButtonPane() {
        if (this.filterButtonPane == null) {
            this.filterButtonPane = new JPanel();
            this.filterButtonPane.add((Component)this.getEditReportFilter(), null);
        }
        return this.filterButtonPane;
    }

    private JButton getEditReportFilter() {
        if (this.editReportFilter == null) {
            this.editReportFilter = new JButton();
            this.editReportFilter.setText("Edit Filter");
            this.editReportFilter.setToolTipText("Edit Filter");
            this.editReportFilter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ReportPane.this.showReportFilter();
                }
            });
        }
        return this.editReportFilter;
    }

    protected void showReportFilter() {
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.LANGUAGES);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.PROBLEMS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.ACCOUNTS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.RUN_STATES);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.JUDGEMENTS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.SITES);
        this.getEditFilterFrame().setFilter(this.filter);
        this.getEditFilterFrame().validate();
        this.getEditFilterFrame().setVisible(true);
    }

    public EditFilterFrame getEditFilterFrame() {
        if (this.editFilterFrame == null) {
            Runnable callback = new Runnable(){

                public void run() {
                    ReportPane.this.refreshFilterLabel();
                }
            };
            this.editFilterFrame = new EditFilterFrame(this.filter, "Report Filter", callback);
        }
        return this.editFilterFrame;
    }

    private void refreshFilterLabel() {
        this.filterLabel.setText(this.filter.toString());
    }
}

