/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.ProfileSaveFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProfilesPane
extends JPanePlugin {
    private static final long serialVersionUID = 9075523788534575300L;
    private ProfileSaveFrame profileSaveFrame = null;
    private JLabel profileNameLabel = null;
    private JLabel profileLabel = null;
    private JComboBox profileComboBox = null;
    private JButton switchButton = null;
    private JButton setButton = null;
    private JTextField profileTextField = null;
    private JPanel centerPane = null;
    private JPanel buttonPane = null;
    private JButton newButton = null;
    private JButton exportButton = null;
    private JLabel notificationOfNonImplementationLabel = null;
    private JButton cloneButton = null;

    public ProfilesPane() {
        this.initialize();
    }

    private void initialize() {
        this.profileLabel = new JLabel();
        this.profileLabel.setBounds(new Rectangle(26, 88, 94, 23));
        this.profileLabel.setHorizontalAlignment(4);
        this.profileLabel.setText("Profiles");
        this.profileNameLabel = new JLabel();
        this.profileNameLabel.setBounds(new Rectangle(14, 40, 106, 22));
        this.profileNameLabel.setHorizontalAlignment(4);
        this.profileNameLabel.setText("Profile Name");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(729, 319));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
    }

    public String getPluginTitle() {
        return "Profiles Pane";
    }

    private JComboBox getProfileComboBox() {
        if (this.profileComboBox == null) {
            this.profileComboBox = new JComboBox();
            this.profileComboBox.setBounds(new Rectangle(134, 85, 339, 28));
        }
        return this.profileComboBox;
    }

    private JButton getSwitchButton() {
        if (this.switchButton == null) {
            this.switchButton = new JButton();
            this.switchButton.setEnabled(true);
            this.switchButton.setMnemonic(87);
            this.switchButton.setPreferredSize(new Dimension(100, 26));
            this.switchButton.setLocation(new Point(497, 85));
            this.switchButton.setSize(new Dimension(100, 28));
            this.switchButton.setText("Switch");
            this.switchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.switchSelectedProfile();
                }
            });
        }
        return this.switchButton;
    }

    private JButton getSetButton() {
        if (this.setButton == null) {
            this.setButton = new JButton();
            this.setButton.setEnabled(true);
            this.setButton.setMnemonic(83);
            this.setButton.setLocation(new Point(497, 38));
            this.setButton.setSize(new Dimension(100, 26));
            this.setButton.setText("Set");
            this.setButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.renameProfile();
                }
            });
        }
        return this.setButton;
    }

    private JTextField getProfileTextField() {
        if (this.profileTextField == null) {
            this.profileTextField = new JTextField();
            this.profileTextField.setBounds(new Rectangle(134, 36, 339, 30));
        }
        return this.profileTextField;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.notificationOfNonImplementationLabel = new JLabel();
            this.notificationOfNonImplementationLabel.setBounds(new Rectangle(0, 132, 733, 113));
            this.notificationOfNonImplementationLabel.setHorizontalAlignment(0);
            this.notificationOfNonImplementationLabel.setHorizontalTextPosition(10);
            this.notificationOfNonImplementationLabel.setFont(new Font("Dialog", 1, 14));
            this.notificationOfNonImplementationLabel.setText("<html><center>This pane will allow switching automatically between<br>Practice and Real contest configurations (work-in-progress)</html>");
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.add((Component)this.profileNameLabel, null);
            this.centerPane.add((Component)this.profileLabel, null);
            this.centerPane.add((Component)this.getProfileComboBox(), null);
            this.centerPane.add((Component)this.getSwitchButton(), null);
            this.centerPane.add((Component)this.getSetButton(), null);
            this.centerPane.add((Component)this.getProfileTextField(), null);
            this.centerPane.add((Component)this.notificationOfNonImplementationLabel, null);
        }
        return this.centerPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getNewButton(), null);
            this.buttonPane.add((Component)this.getCloneButton(), null);
            this.buttonPane.add((Component)this.getExportButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setText("New");
            this.newButton.setMnemonic(78);
            this.newButton.setEnabled(true);
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.newProfile();
                }
            });
        }
        return this.newButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton();
            this.exportButton.setText("Export");
            this.exportButton.setMnemonic(88);
            this.exportButton.setEnabled(true);
            this.exportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.exportProfile();
                }
            });
        }
        return this.exportButton;
    }

    private JButton getCloneButton() {
        if (this.cloneButton == null) {
            this.cloneButton = new JButton();
            this.cloneButton.setText("Clone");
            this.cloneButton.setMnemonic(67);
            this.cloneButton.setEnabled(true);
            this.cloneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.cloneProfile();
                }
            });
        }
        return this.cloneButton;
    }

    protected void cloneProfile() {
        this.getProfileSaveFrame().setTitle("Clone settings for " + this.getProfileName());
        this.getProfileSaveFrame().setSaveButtonName("Clone");
        this.getProfileSaveFrame().setVisible(true);
    }

    private String getProfileName() {
        Profile profile = new Profile("Default");
        return profile.getName();
    }

    protected void newProfile() {
        this.showMessage("New Profile, almost coded");
    }

    protected void exportProfile() {
        this.getProfileSaveFrame().setTitle("Export settings " + this.getProfileName());
        this.getProfileSaveFrame().setSaveButtonName("Export");
        this.getProfileSaveFrame().setVisible(true);
    }

    protected void switchSelectedProfile() {
        if (this.getProfileComboBox().getSelectedIndex() < 0) {
            this.showMessage("No profile selected");
            return;
        }
        this.showMessage("Switch Profile, almost coded");
    }

    protected void renameProfile() {
        if (this.getProfileTextField() == null || this.getProfileTextField().getText().trim().length() < 1) {
            this.showMessage("No profile name specified");
            return;
        }
        String newProfileName = this.getProfileTextField().getText().trim();
        this.showMessage("Set/Rename Profile, almost coded: " + newProfileName);
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public ProfileSaveFrame getProfileSaveFrame() {
        if (this.profileSaveFrame == null) {
            this.profileSaveFrame = new ProfileSaveFrame();
        }
        return this.profileSaveFrame;
    }
}

