/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ProfileSavePane
extends JPanePlugin {
    private static final long serialVersionUID = -6767667140640583963L;
    public static final String CLONE_BUTTON_NAME = "Clone";
    public static final String EXPORT_BUTTON_NAME = "Export";
    private JPanel buttonPanel = null;
    private JButton saveButton = null;
    private JButton cancelButton = null;

    public ProfileSavePane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(488, 391));
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            flowLayout.setVgap(5);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getSaveButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText(CLONE_BUTTON_NAME);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfileSavePane.this.takeProfileAction(ProfileSavePane.this.saveButton.getText());
                }
            });
        }
        return this.saveButton;
    }

    public void setSaveButtonName(String name) {
        this.getSaveButton().setText(name);
    }

    protected void takeProfileAction(String actionText) {
        if (actionText.equalsIgnoreCase(CLONE_BUTTON_NAME)) {
            this.cloneProfile();
            this.showMessage("Would have " + actionText);
        } else if (actionText.equalsIgnoreCase(EXPORT_BUTTON_NAME)) {
            this.exportProfile();
        } else {
            this.showMessage("Unable to take action: " + actionText);
        }
    }

    private void exportProfile() {
        this.showMessage("Would have exported profile");
    }

    private void cloneProfile() {
        this.showMessage("Would have cloned profile");
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfileSavePane.this.closeWindow();
                }
            });
        }
        return this.cancelButton;
    }

    protected void closeWindow() {
        this.getParentFrame().setVisible(false);
    }

    public String getPluginTitle() {
        return "ProfileSavePane";
    }
}

