/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IChangePasswordListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.PasswordChangeEvent;
import edu.csus.ecs.pc2.core.security.ISecurityMessageListener;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.core.security.SecurityMessageEvent;
import edu.csus.ecs.pc2.ui.ChangePasswordFrame;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.ReportFrame;
import edu.csus.ecs.pc2.ui.SubmissionBiffFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OptionsPanel
extends JPanePlugin {
    private static final long serialVersionUID = -7331492559860531233L;
    private LogWindow logWindow;
    private LogWindow securityLogWindow = null;
    private ReportFrame reportFrame;
    private JPanel contentPane = null;
    private JButton showLogButton = null;
    private JButton showBiffWindow = null;
    private SubmissionBiffFrame submissionBiffFrame = new SubmissionBiffFrame();
    private PermissionList permissionList = new PermissionList();
    private JButton showSecurityAlertWindowButton = null;
    private JButton changePasswordButton = null;
    private ChangePasswordFrame changePasswordFrame = null;

    public OptionsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(453, 259));
        this.add((Component)this.getContentPane(), "Center");
    }

    protected void showReportFrame() {
        if (this.reportFrame == null) {
            this.reportFrame = new ReportFrame();
            this.reportFrame.setContestAndController(this.getContest(), this.getController());
        }
        FrameUtilities.setFramePosition(this.reportFrame, FrameUtilities.HorizontalPosition.RIGHT, FrameUtilities.VerticalPosition.CENTER);
        this.reportFrame.setVisible(true);
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        Account account = this.getContest().getAccount(this.getContest().getClientId());
        if (account != null) {
            this.permissionList.clearAndLoadPermissions(account.getPermissionList());
        }
    }

    private void updateGUIperPermissions() {
        this.getShowBiffWindow().setVisible(this.isAllowed(Permission.Type.JUDGE_RUN));
        this.getShowSecurityAlertWindowButton().setVisible(this.isAllowedToViewSecurityWindow());
        this.getChangePasswordButton().setVisible(this.isAllowed(Permission.Type.CHANGE_PASSWORD));
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addChangePasswordListener(new ChangePasswordListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OptionsPanel.this.submissionBiffFrame.setShowNoRunsTitle(true);
                OptionsPanel.this.submissionBiffFrame.setFontSize(56);
                OptionsPanel.this.submissionBiffFrame.setContestAndController(OptionsPanel.this.getContest(), OptionsPanel.this.getController());
                FrameUtilities.setFramePosition(OptionsPanel.this.submissionBiffFrame, FrameUtilities.HorizontalPosition.RIGHT, FrameUtilities.VerticalPosition.TOP);
                OptionsPanel.this.getContest().addSecurityMessageListener(new SecurityMessageListenerImplementation());
                OptionsPanel.this.updateGUIperPermissions();
            }
        });
    }

    public String getPluginTitle() {
        return "Options Pane";
    }

    public LogWindow getLogWindow() {
        return this.logWindow;
    }

    public void setLogWindow(LogWindow logWindow) {
        this.logWindow = logWindow;
    }

    protected void showLog(boolean showLogWindow) {
        try {
            this.logWindow.setVisible(showLogWindow);
        }
        catch (Exception e) {
            this.getLog().log(Log.WARNING, "Exception showing log window", e);
        }
    }

    private Logger getLog() {
        return this.getController().getLog();
    }

    public void setSecurityLogWindow(LogWindow securityLogWindow) {
        this.securityLogWindow = securityLogWindow;
    }

    protected void showSecurityLog(boolean showLogWindow) {
        try {
            this.securityLogWindow.setVisible(showLogWindow);
        }
        catch (Exception e) {
            this.getLog().log(Log.WARNING, "Exception showing security log window", e);
        }
    }

    private JPanel getContentPane() {
        if (this.contentPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(20);
            this.contentPane = new JPanel();
            this.contentPane.setLayout(flowLayout);
            this.contentPane.add((Component)this.getShowLogButton(), null);
            this.contentPane.add((Component)this.getShowSecurityAlertWindowButton(), null);
            this.contentPane.add((Component)this.getShowBiffWindow(), null);
            this.contentPane.add((Component)this.getChangePasswordButton(), null);
            this.contentPane.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 && e.isControlDown() && e.isShiftDown()) {
                        OptionsPanel.this.showReportFrame();
                    }
                }
            });
        }
        return this.contentPane;
    }

    private JButton getShowLogButton() {
        if (this.showLogButton == null) {
            this.showLogButton = new JButton();
            this.showLogButton.setText("Show Log");
            this.showLogButton.setText("Show PC^2 Log");
            this.showLogButton.setMnemonic(76);
            this.showLogButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.showLog(true);
                }
            });
        }
        return this.showLogButton;
    }

    private JButton getShowBiffWindow() {
        if (this.showBiffWindow == null) {
            this.showBiffWindow = new JButton();
            this.showBiffWindow.setText("Show Unjudged Submissions Count");
            this.showBiffWindow.setToolTipText("Show Unjudged Submissions Count");
            this.showBiffWindow.setMnemonic(85);
            this.showBiffWindow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.showBiffWindow();
                }
            });
        }
        return this.showBiffWindow;
    }

    protected void showBiffWindow() {
        this.submissionBiffFrame.setVisible(true);
    }

    private JButton getShowSecurityAlertWindowButton() {
        if (this.showSecurityAlertWindowButton == null) {
            this.showSecurityAlertWindowButton = new JButton();
            this.showSecurityAlertWindowButton.setText("Show Security Alert Log");
            this.showSecurityAlertWindowButton.setToolTipText("Show Security Alert Log");
            this.showSecurityAlertWindowButton.setMnemonic(83);
            this.showSecurityAlertWindowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.showSecurityLog(true);
                }
            });
        }
        return this.showSecurityAlertWindowButton;
    }

    protected boolean isAllowedToViewSecurityWindow() {
        return this.isAllowed(Permission.Type.VIEW_SECURITY_ALERTS) || this.isServer();
    }

    private boolean isServer() {
        return this.getContest().getClientId().getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private JButton getChangePasswordButton() {
        if (this.changePasswordButton == null) {
            this.changePasswordButton = new JButton();
            this.changePasswordButton.setText("Change Password");
            this.changePasswordButton.setToolTipText("Click here to change your password");
            this.changePasswordButton.setMnemonic(80);
            this.changePasswordButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsPanel.this.showChangePassword();
                }
            });
        }
        return this.changePasswordButton;
    }

    protected void showChangePassword() {
        if (this.isAllowed(Permission.Type.CHANGE_PASSWORD)) {
            if (this.changePasswordFrame == null) {
                this.changePasswordFrame = new ChangePasswordFrame();
                this.changePasswordFrame.setContestAndController(this.getContest(), this.getController());
            }
            this.changePasswordFrame.setVisible(true);
        }
    }

    protected void showPasswordMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, message);
            }
        });
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (OptionsPanel.this.getContest().getClientId().equals(account.getClientId())) {
                this.updateThisClient();
            }
        }

        private void updateThisClient() {
            OptionsPanel.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OptionsPanel.this.updateGUIperPermissions();
                }
            });
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accountArray = accountEvent.getAccounts();
            int n = accountArray.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (OptionsPanel.this.getContest().getClientId().equals(account.getClientId())) {
                    this.updateThisClient();
                }
                ++n2;
            }
        }
    }

    public class ChangePasswordListenerImplementation
    implements IChangePasswordListener {
        public void passwordChanged(PasswordChangeEvent event) {
            OptionsPanel.this.showPasswordMessage(event.getMessage());
        }

        public void passwordNotChanged(PasswordChangeEvent event) {
            OptionsPanel.this.showPasswordMessage(event.getMessage());
        }
    }

    protected class SecurityMessageListenerImplementation
    implements ISecurityMessageListener {
        protected SecurityMessageListenerImplementation() {
        }

        public void newMessage(SecurityMessageEvent event) {
            if (OptionsPanel.this.isAllowedToViewSecurityWindow()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        OptionsPanel.this.showSecurityLog(true);
                    }
                });
            }
        }
    }
}

