/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.FileDiffPanel;
import edu.csus.ecs.pc2.ui.IDiffPanel;
import edu.csus.ecs.pc2.ui.IFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class MultipleFileViewer
extends JFrame
implements IFileViewer {
    private static final long serialVersionUID = -3837495960973474113L;
    public static final String SVN_ID = "$Id: MultipleFileViewer.java 1694 2008-12-01 05:43:58Z boudreat $";
    private JPanel ivjButtonFrame = null;
    private JPanel ivjCenterFrame = null;
    private JButton ivjCloseButton = null;
    private JTabbedPane ivjFileTabbedPane = null;
    private JPanel ivjJFrameContentPane = null;
    private String judgeOutputFileName = null;
    private String teamOutputFileName = null;
    private JButton ivjCompareButton = null;
    private Log log = null;
    private IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private static final String NL = System.getProperty("line.separator");
    private IDiffPanel fileDiffPanel;
    private JPanel soutPane = null;
    private JLabel informationLabel = null;
    private IInternalController controller;
    private IInternalContest contest;

    public MultipleFileViewer(Log log) {
        this.log = log;
        this.initialize();
    }

    public MultipleFileViewer(Log log, String title) {
        super(title);
        this.log = log;
        this.initialize();
        this.setTitle(title);
        this.getCompareButton().setVisible(false);
    }

    public void closeButtonActionEvents() {
        if (this.fileDiffPanel != null) {
            this.fileDiffPanel.dispose();
            this.fileDiffPanel = null;
        }
        this.dispose();
    }

    private void connEtoC1() {
        try {
            this.closeButtonActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getButtonFrame() {
        if (this.ivjButtonFrame == null) {
            try {
                this.ivjButtonFrame = new JPanel();
                this.ivjButtonFrame.setName("ButtonFrame");
                this.ivjButtonFrame.setPreferredSize(new Dimension(35, 35));
                this.ivjButtonFrame.setLayout(new FlowLayout());
                this.getButtonFrame().add((Component)this.getCompareButton(), this.getCompareButton().getName());
                this.getButtonFrame().add((Component)this.getCloseButton(), this.getCloseButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonFrame;
    }

    private JPanel getCenterFrame() {
        if (this.ivjCenterFrame == null) {
            try {
                this.ivjCenterFrame = new JPanel();
                this.ivjCenterFrame.setName("CenterFrame");
                this.ivjCenterFrame.setLayout(new BorderLayout());
                this.getCenterFrame().add((Component)this.getFileTabbedPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCenterFrame;
    }

    private JButton getCloseButton() {
        if (this.ivjCloseButton == null) {
            try {
                this.ivjCloseButton = new JButton();
                this.ivjCloseButton.setName("CloseButton");
                this.ivjCloseButton.setMnemonic('c');
                this.ivjCloseButton.setText("Close");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseButton;
    }

    private JTabbedPane getFileTabbedPane() {
        if (this.ivjFileTabbedPane == null) {
            try {
                this.ivjFileTabbedPane = new JTabbedPane();
                this.ivjFileTabbedPane.setName("FileTabbedPane");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileTabbedPane;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.getJFrameContentPane().add((Component)this.getCenterFrame(), "Center");
                this.ivjJFrameContentPane.add((Component)this.getSoutPane(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
    }

    private void initConnections() throws Exception {
        this.getCloseButton().addActionListener(this.ivjEventHandler);
        this.getCompareButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("MultipleFileViewer");
            this.setDefaultCloseOperation(2);
            this.setState(0);
            this.setSize(594, 546);
            this.setTitle("Information");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.centerFrame();
        this.getCompareButton().setVisible(false);
    }

    public boolean loadFile(JTextArea jPane, String filename) {
        File viewFile;
        String oldTitle;
        FileReader fileReader;
        block4: {
            fileReader = null;
            jPane.setFont(new Font("Courier", 0, 12));
            oldTitle = this.getTitle();
            this.setTitle("Loading " + filename + " ... ");
            viewFile = new File(filename);
            if (viewFile.exists()) break block4;
            return false;
        }
        try {
            fileReader = new FileReader(viewFile);
            BufferedReader in = new BufferedReader(fileReader);
            String line = in.readLine();
            while (line != null) {
                jPane.append(line);
                jPane.append("\n");
                line = in.readLine();
            }
            in.close();
            jPane.setCaretPosition(0);
            this.setTitle(oldTitle);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer class: exception " + e);
            return false;
        }
    }

    public MultipleFileViewer(Log log, String windowTitle, String paneTitle, String messageData, boolean isFile) {
        super(windowTitle);
        this.log = log;
        this.initialize();
        this.setTitle(windowTitle);
        if (isFile) {
            this.addFilePane(paneTitle, messageData);
        } else {
            this.addTextPane(paneTitle, messageData);
        }
        this.getCompareButton().setVisible(false);
    }

    public boolean addFilePane(String title, String filename) {
        if (title == null) {
            title = filename;
        }
        if (title.length() < 1) {
            title = filename;
        }
        int numtabs = this.getFileTabbedPane().getTabCount() + 1;
        JTextArea jp = new JTextArea();
        jp.setName("JTextPane" + numtabs);
        jp.setBounds(0, 0, 11, 6);
        JScrollPane jsp = new JScrollPane();
        jsp.setName("JScrollPane" + numtabs);
        jsp.setViewportView(jp);
        JPanel jPanel = new JPanel();
        jPanel.setName("JPanel" + numtabs);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jsp, "Center");
        this.ivjFileTabbedPane.insertTab(title, null, jPanel, null, 0);
        return this.loadFile(jp, filename);
    }

    public boolean addFilePane(String title, SerializedFile inFile) {
        if (inFile == null) {
            return false;
        }
        if (inFile.getBuffer().length < 1) {
            return false;
        }
        String filename = inFile.getName();
        if (title == null) {
            title = filename;
        }
        if (title.length() < 1) {
            title = filename;
        }
        int numtabs = this.getFileTabbedPane().getTabCount() + 1;
        JTextArea jp = new JTextArea();
        jp.setName("JTextPane" + numtabs);
        jp.setBounds(0, 0, 11, 6);
        JScrollPane jsp = new JScrollPane();
        jsp.setName("JScrollPane" + numtabs);
        jsp.setViewportView(jp);
        JPanel jPanel = new JPanel();
        jPanel.setName("JPanel" + numtabs);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jsp, "Center");
        this.ivjFileTabbedPane.insertTab(title, null, jPanel, null, 0);
        return this.loadFile(jp, inFile);
    }

    public boolean addTextPane(String title, String inMessage) {
        if (inMessage.length() < 1) {
            return false;
        }
        if (title == null) {
            title = "Message";
        }
        if (title.length() < 1) {
            title = "Message";
        }
        int numtabs = this.getFileTabbedPane().getTabCount() + 1;
        JTextArea jp = new JTextArea();
        jp.setName("JTextPane" + numtabs);
        jp.setBounds(0, 0, 11, 6);
        JScrollPane jsp = new JScrollPane();
        jsp.setName("JScrollPane" + numtabs);
        jsp.setViewportView(jp);
        JPanel jPanel = new JPanel();
        jPanel.setName("JPanel" + numtabs);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jsp, "Center");
        this.ivjFileTabbedPane.insertTab(title, null, jPanel, null, 0);
        return this.loadText(jp, inMessage);
    }

    public void enableCompareButton(boolean value) {
        this.getCompareButton().setVisible(value);
    }

    private JButton getCompareButton() {
        if (this.ivjCompareButton == null) {
            try {
                this.ivjCompareButton = new JButton();
                this.ivjCompareButton.setName("CompareButton");
                this.ivjCompareButton.setMnemonic('p');
                this.ivjCompareButton.setText("Compare");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCompareButton;
    }

    public boolean loadFile(JTextArea jPane, SerializedFile inFile) {
        try {
            String filename = inFile.getName();
            jPane.setFont(new Font("Courier", 0, 12));
            String s = new String(inFile.getBuffer());
            String oldTitle = this.getTitle();
            this.setTitle("Loading " + filename + " ... ");
            jPane.append(this.checkNPCharacters(s));
            jPane.setCaretPosition(0);
            this.setTitle(oldTitle);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer class: exception " + e);
            return false;
        }
    }

    public boolean loadText(JTextArea jPane, String inMessage) {
        try {
            jPane.setFont(new Font("Courier", 0, 12));
            jPane.append(inMessage);
            jPane.setCaretPosition(0);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer class: exception " + e);
            return false;
        }
    }

    public void showMessage(String inMessage) {
        this.setTitle("Message");
        this.addTextPane("Message", inMessage);
        this.setVisible(true);
    }

    private void centerFrame() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenDim.width / 2 - this.getSize().width / 2, screenDim.height / 2 - this.getSize().height / 2);
    }

    public String checkNPCharacters(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int x = new Character(c).hashCode();
            if (!(Character.isWhitespace(c) || x >= 32 && x <= 126)) {
                return "***** NOTE: This output contains non-printable characters *****" + NL + s;
            }
            ++i;
        }
        return s;
    }

    public void compareButtonActionPerformed(ActionEvent actionEvent) {
        if (this.judgeOutputFileName == null && this.teamOutputFileName == null) {
            this.log.config("compareButtonActionPerformed:  judge and team files are null");
            return;
        }
        if (this.judgeOutputFileName == null) {
            this.log.config("compareButtonActionPerformed:  judge file is null");
        }
        if (this.teamOutputFileName == null) {
            this.log.config("compareButtonActionPerformed:  team file is null");
        }
        try {
            if (this.fileDiffPanel == null) {
                this.fileDiffPanel = new FileDiffPanel(this.log);
                this.fileDiffPanel.showFiles(this.teamOutputFileName, "Team's Output", this.judgeOutputFileName, "Judge's Answer");
            } else {
                this.fileDiffPanel.show();
            }
        }
        catch (Throwable exception) {
            this.log.log(Log.CONFIG, "compareButton_ActionEvents:  Error in creating fileDiffViewer", exception);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.compareButtonActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void resizeToParentFrame(JFrame frame) {
        this.setSize(frame.getSize());
        this.setLocation(frame.getLocation());
    }

    public void resizeToThirdScreen() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameDim = this.getSize();
        int thirdHeight = screenDim.height / 2;
        int thirdWidth = screenDim.width / 2;
        frameDim.height = Math.max(frameDim.height, thirdHeight);
        frameDim.width = Math.max(frameDim.height, thirdWidth);
        this.setSize(frameDim);
        this.centerFrame();
    }

    public void setCompareFileNames(String incomingJudgeOutputFileName, String incomingTeamOutputFileName) {
        this.judgeOutputFileName = incomingJudgeOutputFileName;
        this.teamOutputFileName = incomingTeamOutputFileName;
    }

    private JPanel getSoutPane() {
        if (this.soutPane == null) {
            this.informationLabel = new JLabel();
            this.informationLabel.setText("");
            this.informationLabel.setHorizontalAlignment(0);
            this.informationLabel.setPreferredSize(new Dimension(10, 30));
            this.soutPane = new JPanel();
            this.soutPane.setLayout(new BorderLayout());
            this.soutPane.add((Component)this.getButtonFrame(), "South");
            this.soutPane.add((Component)this.informationLabel, "Center");
        }
        return this.soutPane;
    }

    public void setInformationLabelText(String text) {
        if (text.equals("")) {
            this.informationLabel.setPreferredSize(new Dimension(0, 0));
        } else {
            this.informationLabel.setPreferredSize(new Dimension(10, 30));
        }
        this.informationLabel.setText(text);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
    }

    public void setSelectedIndex(int index) {
        this.ivjFileTabbedPane.setSelectedIndex(index);
    }

    public String getPluginTitle() {
        return "Multi File Viewer";
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MultipleFileViewer.this.getCloseButton()) {
                MultipleFileViewer.this.connEtoC1();
            }
            if (e.getSource() == MultipleFileViewer.this.getCompareButton()) {
                MultipleFileViewer.this.connEtoC2(e);
            }
        }
    }
}

