/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.TableModel;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.IStreamListener;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class LogWindow
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -3451023761556886609L;
    private int maxLines = 4000;
    private MCLB logMessageListbox = null;
    private IInternalController controller;
    private IInternalContest contest;
    private Log log = null;
    private StreamListener streamListener = null;

    public LogWindow(Log log) {
        this();
        this.log = log;
    }

    public LogWindow() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(700, 300));
        this.setTitle("Log Viewer");
        this.setDefaultCloseOperation(1);
        this.add((Component)((Object)this.getLogMessageListbox()));
        this.centerFrameTopFullWidth(this);
    }

    private void centerFrameTopFullWidth(JFrame aFrame) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int newFrameWidth = screenDim.width - 40;
        aFrame.setSize(newFrameWidth, aFrame.getHeight());
        aFrame.setLocation(screenDim.width / 2 - aFrame.getSize().width / 2, 40);
    }

    private MCLB getLogMessageListbox() {
        if (this.logMessageListbox == null) {
            this.logMessageListbox = new MCLB();
            Object[] cols = new Object[]{"Date/Time", "Level", "Thread", "Method", "Message"};
            this.logMessageListbox.addColumns(cols);
            this.logMessageListbox.autoSizeAllColumns();
        }
        return this.logMessageListbox;
    }

    private void truncateTo(int numLines) {
        TableModel tableModel = this.getLogMessageListbox().getModel();
        if (tableModel.getRowCount() > numLines) {
            int lastRow;
            int i = lastRow = tableModel.getRowCount();
            while (i >= numLines) {
                tableModel.removeRow(i);
                --i;
            }
        }
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        if (this.controller == null) {
            System.err.println("controller is null");
        }
        if (this.controller.getLog() == null) {
            System.err.println("controller.getLog() is null");
        }
        if (this.log == null) {
            this.log = this.controller.getLog();
        }
        this.streamListener = new StreamListener();
        this.log.getStreamHandler().addStreamListener(this.streamListener);
    }

    public String getPluginTitle() {
        return this.getTitle();
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void dispose() {
        if (this.streamListener != null) {
            this.log.getStreamHandler().removeStreamListener(this.streamListener);
            this.streamListener = null;
        }
    }

    class StreamListener
    implements IStreamListener {
        StreamListener() {
        }

        public void messageAdded(String inString) {
            final String[] logMessageFields = inString.split("[|]");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogWindow.this.getLogMessageListbox().setUpdate(false);
                    if (logMessageFields.length > 5) {
                        int i = logMessageFields.length - 1;
                        while (i > 4) {
                            Object[] newRow = new Object[]{"", "", "", "", logMessageFields[i]};
                            LogWindow.this.getLogMessageListbox().insertRow(newRow, 0);
                            --i;
                        }
                        Object[] row = new Object[]{logMessageFields[0], logMessageFields[1], logMessageFields[2], logMessageFields[3], logMessageFields[4]};
                        LogWindow.this.getLogMessageListbox().insertRow(row, 0);
                    } else {
                        LogWindow.this.getLogMessageListbox().insertRow(logMessageFields, 0);
                    }
                    LogWindow.this.truncateTo(LogWindow.this.maxLines);
                    LogWindow.this.getLogMessageListbox().autoSizeAllColumns();
                    LogWindow.this.getLogMessageListbox().setUpdate(true);
                }
            });
        }
    }
}

