/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class LoadUIClass {
    private static final String PROJECT_PACKAGE_PATH = "edu.csus.ecs.pc2";
    public static final String UI_PROPERTIES_FILENAME = "uiname.properties";
    public static final String UI_PROPERTY_NAME = "uiname";

    private LoadUIClass() {
    }

    public static UIPlugin loadUIClass(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> newClass = Class.forName(className);
        Object object = newClass.newInstance();
        if (object instanceof UIPlugin) {
            return (UIPlugin)object;
        }
        object = null;
        throw new SecurityException(String.valueOf(className) + " loaded, but not an instanceof UIPlugin");
    }

    public static Properties getDefaultUIProperties() {
        Properties properties = new Properties();
        properties.put(ClientType.Type.ADMINISTRATOR.toString().toLowerCase(), "edu.csus.ecs.pc2.ui.admin.AdministratorView");
        properties.put(ClientType.Type.SCOREBOARD.toString().toLowerCase(), "edu.csus.ecs.pc2.ui.board.ScoreboardView");
        properties.put(ClientType.Type.JUDGE.toString().toLowerCase(), "edu.csus.ecs.pc2.ui.judge.JudgeView");
        properties.put(ClientType.Type.SPECTATOR.toString().toLowerCase(), "edu.csus.ecs.pc2.ui.judge.JudgeView");
        properties.put(ClientType.Type.EXECUTOR.toString().toLowerCase(), "edu.csus.ecs.pc2.ui.judge.JudgeView");
        properties.put(ClientType.Type.SERVER.toString().toLowerCase(), "edu.csus.ecs.pc2.ui.server.ServerView");
        properties.put(ClientType.Type.TEAM.toString().toLowerCase(), "edu.csus.ecs.pc2.ui.team.TeamView");
        return properties;
    }

    private static String defaultUIClassName(ClientId clientId) {
        String clientName = clientId.getClientType().toString().toLowerCase();
        return LoadUIClass.getDefaultUIProperties().getProperty(clientName);
    }

    protected static String getUiFileName() {
        String pathName = System.getProperty(UI_PROPERTY_NAME);
        if (pathName != null) {
            File file = new File(pathName);
            if (file.isDirectory()) {
                return String.valueOf(pathName) + File.separator + UI_PROPERTIES_FILENAME;
            }
            if (file.isFile()) {
                return pathName;
            }
        }
        return UI_PROPERTIES_FILENAME;
    }

    public static String getUIClassName(ClientId clientId) throws IOException {
        String className = null;
        Properties properties = new Properties();
        String uiPropertiesFilename = LoadUIClass.getUiFileName();
        if (new File(uiPropertiesFilename).exists()) {
            FileInputStream fileInputStream = new FileInputStream(uiPropertiesFilename);
            properties.load(fileInputStream);
            fileInputStream.close();
            fileInputStream = null;
        }
        if ((className = properties.getProperty(clientId.getName())) == null) {
            return LoadUIClass.defaultUIClassName(clientId);
        }
        return className;
    }

    public static void writeSample(String filename) {
        try {
            Properties properties = LoadUIClass.getDefaultUIProperties();
            FileOutputStream fileOutputStream = new FileOutputStream(filename, false);
            properties.store(fileOutputStream, "PC^2 GUI Plugins ");
            fileOutputStream.close();
            Object var2_3 = null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

