/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageAutoFill;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class LanguagePane
extends JPanePlugin {
    private static final long serialVersionUID = 6229906311932197623L;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JTextField displayNameTextField = null;
    private JTextField compileCommandLineTextField = null;
    private JTextField executableFilenameTextField = null;
    private JLabel jLabel3 = null;
    private JTextField jTextField3 = null;
    private JLabel jLabel4 = null;
    private JTextField programExecutionCommandLineTextField = null;
    private JLabel jLabel5 = null;
    private JComboBox autoPopulateLanguageComboBox = null;
    private static final String NO_CHANGE_TITLE = "No Change";
    private Language language = null;
    private boolean populatingGUI = true;

    public LanguagePane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(517, 239));
        this.add((Component)this.getJPanel(), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.loadComboBox();
    }

    private void loadComboBox() {
        this.getAutoPopulateLanguageComboBox().addItem(NO_CHANGE_TITLE);
        String[] stringArray = LanguageAutoFill.getLanguageList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String languageName = stringArray[n2];
            this.getAutoPopulateLanguageComboBox().addItem(languageName);
            ++n2;
        }
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (LanguagePane.this.getParentFrame() != null) {
                    LanguagePane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            LanguagePane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    public String getPluginTitle() {
        return "Edit Language Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LanguagePane.this.addLanguage();
                }
            });
        }
        return this.addButton;
    }

    protected void addLanguage() {
        Language newLanguage = this.getLanguageFromFields();
        this.getController().addNewLanguage(newLanguage);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private Language getLanguageFromFields() {
        if (this.language == null) {
            this.language = new Language(this.displayNameTextField.getText());
        } else {
            this.language.setDisplayName(this.displayNameTextField.getText());
        }
        this.language.setCompileCommandLine(this.compileCommandLineTextField.getText());
        this.language.setExecutableIdentifierMask(this.getExecutableFilenameTextField().getText());
        this.language.setProgramExecuteCommandLine(this.programExecutionCommandLineTextField.getText());
        return this.language;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LanguagePane.this.updateLanguage();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateLanguage() {
        Language newLanguage = this.getLanguageFromFields();
        this.getController().updateLanguage(newLanguage);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LanguagePane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Language modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addLanguage();
                } else {
                    this.updateLanguage();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setBounds(new Rectangle(67, 13, 129, 20));
            this.jLabel5.setHorizontalAlignment(4);
            this.jLabel5.setText("Auto Populate with");
            this.jLabel5.setName("AutoPopulateLabel");
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(new Rectangle(13, 145, 244, 20));
            this.jLabel4.setName("ProgramExLabel");
            this.jLabel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel4.setHorizontalAlignment(4);
            this.jLabel4.setText("Program Execution Command Line");
            this.jLabel4.setForeground(new Color(0, 0, 0));
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(new Rectangle(14, 112, 182, 20));
            this.jLabel3.setName("ExeFilenameLabel");
            this.jLabel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel3.setHorizontalAlignment(4);
            this.jLabel3.setText("Executable Filename");
            this.jLabel3.setForeground(Color.black);
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(0, 0, 0, 0));
            this.jLabel2.setName("SourceExtLabel");
            this.jLabel2.setForeground(Color.black);
            this.jLabel2.setHorizontalAlignment(4);
            this.jLabel2.setText("Source Extensions");
            this.jLabel2.setVisible(false);
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(14, 46, 182, 20));
            this.jLabel1.setName("DisplayNameLabel");
            this.jLabel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel1.setText("Display Name");
            this.jLabel1.setForeground(Color.black);
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(14, 79, 182, 20));
            this.jLabel.setName("CompileCmdLineLabel");
            this.jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel.setHorizontalAlignment(4);
            this.jLabel.setText("Compile Cmd Line");
            this.jLabel.setForeground(Color.black);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setName("advancedEdit");
            this.jPanel.add((Component)this.jLabel, this.jLabel.getName());
            this.jPanel.add((Component)this.jLabel1, this.jLabel1.getName());
            this.jPanel.add((Component)this.jLabel2, this.jLabel2.getName());
            this.jPanel.add((Component)this.getDisplayNameTextField(), this.getDisplayNameTextField().getName());
            this.jPanel.add((Component)this.getCompileCommandLineTextField(), this.getCompileCommandLineTextField().getName());
            this.jPanel.add((Component)this.getExecutableFilenameTextField(), this.getExecutableFilenameTextField().getName());
            this.jPanel.add((Component)this.jLabel3, this.jLabel3.getName());
            this.jPanel.add((Component)this.getJTextField3(), this.getJTextField3().getName());
            this.jPanel.add((Component)this.jLabel4, this.jLabel4.getName());
            this.jPanel.add((Component)this.getProgramExecutionCommandLineTextField(), this.getProgramExecutionCommandLineTextField().getName());
            this.jPanel.add((Component)this.jLabel5, this.jLabel5.getName());
            this.jPanel.add((Component)this.getAutoPopulateLanguageComboBox(), this.getAutoPopulateLanguageComboBox().getName());
        }
        return this.jPanel;
    }

    private JTextField getDisplayNameTextField() {
        if (this.displayNameTextField == null) {
            this.displayNameTextField = new JTextField();
            this.displayNameTextField.setBounds(new Rectangle(209, 46, 263, 20));
            this.displayNameTextField.setToolTipText("Name to display to users");
            this.displayNameTextField.setName("displayNameTextField");
            this.displayNameTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    LanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNameTextField;
    }

    private JTextField getCompileCommandLineTextField() {
        if (this.compileCommandLineTextField == null) {
            this.compileCommandLineTextField = new JTextField();
            this.compileCommandLineTextField.setBounds(new Rectangle(208, 79, 264, 20));
            this.compileCommandLineTextField.setToolTipText("Command Line for compiler");
            this.compileCommandLineTextField.setName("commandLineTextField");
            this.compileCommandLineTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    LanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.compileCommandLineTextField;
    }

    private JTextField getExecutableFilenameTextField() {
        if (this.executableFilenameTextField == null) {
            this.executableFilenameTextField = new JTextField();
            this.executableFilenameTextField.setBounds(new Rectangle(208, 112, 264, 20));
            this.executableFilenameTextField.setToolTipText("Form: exe");
            this.executableFilenameTextField.setName("programExeTextField");
            this.executableFilenameTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    LanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.executableFilenameTextField;
    }

    private JTextField getJTextField3() {
        if (this.jTextField3 == null) {
            this.jTextField3 = new JTextField();
            this.jTextField3.setBounds(new Rectangle(0, 0, 0, 0));
            this.jTextField3.setName("sourceExtTextField");
            this.jTextField3.setToolTipText("Form: *.cpp;*.c");
            this.jTextField3.setVisible(false);
        }
        return this.jTextField3;
    }

    private JTextField getProgramExecutionCommandLineTextField() {
        if (this.programExecutionCommandLineTextField == null) {
            this.programExecutionCommandLineTextField = new JTextField();
            this.programExecutionCommandLineTextField.setBounds(new Rectangle(274, 145, 198, 20));
            this.programExecutionCommandLineTextField.setToolTipText("Form: exe");
            this.programExecutionCommandLineTextField.setName("programCommandLine");
            this.programExecutionCommandLineTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    LanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.programExecutionCommandLineTextField;
    }

    private JComboBox getAutoPopulateLanguageComboBox() {
        if (this.autoPopulateLanguageComboBox == null) {
            this.autoPopulateLanguageComboBox = new JComboBox();
            this.autoPopulateLanguageComboBox.setBounds(new Rectangle(209, 12, 259, 23));
            this.autoPopulateLanguageComboBox.setName("LangPopulateComboBox");
            this.autoPopulateLanguageComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LanguagePane.this.autoFillFields();
                }
            });
        }
        return this.autoPopulateLanguageComboBox;
    }

    protected void autoFillFields() {
        String languageToFill = (String)this.getAutoPopulateLanguageComboBox().getSelectedItem();
        if (NO_CHANGE_TITLE.equals(languageToFill)) {
            return;
        }
        String[] values = LanguageAutoFill.getAutoFillValues(languageToFill);
        this.displayNameTextField.setText(values[0]);
        this.compileCommandLineTextField.setText(values[1]);
        this.executableFilenameTextField.setText(values[2]);
        this.programExecutionCommandLineTextField.setText(values[3]);
        this.enableUpdateButtons(true);
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.language != null) {
            enableButton |= !this.displayNameTextField.getText().equals(this.language.getDisplayName());
            enableButton |= !this.compileCommandLineTextField.getText().equals(this.language.getCompileCommandLine());
            enableButton |= !this.executableFilenameTextField.getText().equals(this.language.getExecutableIdentifierMask());
            enableButton |= !this.programExecutionCommandLineTextField.getText().equals(this.language.getProgramExecuteCommandLine());
        } else if (this.getAddButton().isVisible()) {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(final Language language) {
        this.language = language;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LanguagePane.this.populateGUI(language);
                LanguagePane.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateGUI(Language language2) {
        this.populatingGUI = true;
        if (language2 != null) {
            this.displayNameTextField.setText(language2.getDisplayName());
            this.compileCommandLineTextField.setText(language2.getCompileCommandLine());
            this.executableFilenameTextField.setText(language2.getExecutableIdentifierMask());
            this.programExecutionCommandLineTextField.setText(language2.getProgramExecuteCommandLine());
            this.getAutoPopulateLanguageComboBox().setSelectedIndex(0);
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
        } else {
            this.displayNameTextField.setText("");
            this.compileCommandLineTextField.setText("");
            this.executableFilenameTextField.setText("");
            this.programExecutionCommandLineTextField.setText("");
            this.getAutoPopulateLanguageComboBox().setSelectedIndex(0);
            this.getAddButton().setVisible(true);
            this.getUpdateButton().setVisible(false);
        }
        this.populatingGUI = false;
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(editedText);
        } else {
            this.getAddButton().setEnabled(editedText);
        }
    }
}

