/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JudgementsPanel
extends JPanePlugin {
    private static final long serialVersionUID = 36368747620026978L;
    private MCLB judgementListBox = null;
    private JPanel buttonsPane = null;
    private JButton addButton = null;
    private JPanel statusPanel = null;
    private JLabel messageLabel = null;

    public JudgementsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(584, 211));
        this.add((Component)this.getButtonsPane(), "South");
        this.add((Component)((Object)this.getJudgementListBox()), "Center");
    }

    public String getPluginTitle() {
        return "Judgements Panel";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JudgementsPanel.this.updateGUIperPermissions();
                JudgementsPanel.this.reloadJudgementList();
            }
        });
        this.showMessage("");
    }

    protected void updateGUIperPermissions() {
    }

    protected void reloadJudgementList() {
        this.getJudgementListBox().removeAllRows();
        Judgement[] judgementArray = this.getContest().getJudgements();
        int n = judgementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement judgement = judgementArray[n2];
            this.updateJudgementRow(judgement);
            ++n2;
        }
    }

    private MCLB getJudgementListBox() {
        if (this.judgementListBox == null) {
            this.judgementListBox = new MCLB();
            this.judgementListBox.add(this.getStatusPanel(), "North");
            Object[] cols = new Object[]{"Judgement"};
            this.judgementListBox.addColumns(cols);
        }
        return this.judgementListBox;
    }

    private JPanel getButtonsPane() {
        if (this.buttonsPane == null) {
            this.buttonsPane = new JPanel();
            this.buttonsPane.add((Component)this.getAddButton(), null);
        }
        return this.buttonsPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
        }
        return this.addButton;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.setPreferredSize(new Dimension(20, 20));
            this.statusPanel.add((Component)this.messageLabel, "Center");
        }
        return this.statusPanel;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JudgementsPanel.this.messageLabel.setText(string);
                JudgementsPanel.this.messageLabel.setToolTipText(string);
            }
        });
    }

    private void updateJudgementRow(final Judgement judgement) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = JudgementsPanel.this.buildJudgementRow(judgement);
                int rowNumber = JudgementsPanel.this.judgementListBox.getIndexByKey(judgement.getElementId());
                if (rowNumber == -1) {
                    JudgementsPanel.this.judgementListBox.addRow(objects, judgement.getElementId());
                } else {
                    JudgementsPanel.this.judgementListBox.replaceRow(objects, rowNumber);
                }
                JudgementsPanel.this.judgementListBox.autoSizeAllColumns();
            }
        });
    }

    private Object[] buildJudgementRow(Judgement judgement) {
        try {
            int cols = this.judgementListBox.getColumnCount();
            Object[] s = new String[cols];
            s[0] = judgement.toString();
            return s;
        }
        catch (Exception exception) {
            StaticLog.getLog().log(Log.INFO, "Exception in buildRunRow()", exception);
            return null;
        }
    }
}

