/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.imports.ICPCImportData;
import edu.csus.ecs.pc2.core.imports.LoadICPCData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.ICPCAccountFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.TabFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ICPCPane
extends JPanePlugin {
    private static final long serialVersionUID = 5514087353704960972L;
    private JButton changeDisplayFormatButton = null;
    private JButton importButton = null;
    private ICPCAccountFrame icpcAccountFrame = null;
    private ICPCImportData importData;
    private String lastDir;
    private Log log;

    public ICPCPane() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(50);
        this.setLayout(flowLayout);
        this.setSize(new Dimension(448, 207));
        this.add((Component)this.getImportButton(), null);
        this.add((Component)this.getChangeDisplayFormatButton(), null);
    }

    public String getPluginTitle() {
        return "ICPC Data Pane";
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton();
            this.importButton.setText("Import");
            this.importButton.setPreferredSize(new Dimension(150, 26));
            this.importButton.setToolTipText("Import PC^2 ICPC contest initialization data");
            this.importButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCPane.this.loadICPCFiles();
                }
            });
        }
        return this.importButton;
    }

    private ICPCAccountFrame getICPCAccountFrame() {
        if (this.icpcAccountFrame == null) {
            this.icpcAccountFrame = new ICPCAccountFrame();
        }
        return this.icpcAccountFrame;
    }

    protected void loadICPCFiles() {
        block15: {
            try {
                JFileChooser chooser = new JFileChooser(this.lastDir);
                chooser.setDialogTitle("Select PC2_Team.tab");
                chooser.setFileFilter(new TabFileFilter());
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal != 0) break block15;
                File newFile = chooser.getSelectedFile().getCanonicalFile();
                boolean newFileProblem = true;
                if (newFile.exists() && newFile.isFile() && newFile.canRead()) {
                    this.lastDir = chooser.getCurrentDirectory().toString();
                    this.importData = LoadICPCData.loadSites(this.lastDir, this.getContest().getSites());
                    newFileProblem = false;
                    Group[] importedGroups = this.importData.getGroups();
                    Group[] modelGroups = this.getContest().getGroups();
                    String contestTitle = this.importData.getContestTitle();
                    if (contestTitle != null && contestTitle.trim().length() > 0) {
                        ContestInformation ci = this.getContest().getContestInformation();
                        ci.setContestTitle(contestTitle);
                        this.getController().updateContestInformation(ci);
                    }
                    if (importedGroups != null && importedGroups.length > 0) {
                        if (modelGroups == null || modelGroups.length == 0) {
                            Group[] groupArray = importedGroups;
                            int n = importedGroups.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Group group = groupArray[n2];
                                this.getController().addNewGroup(group);
                                ++n2;
                            }
                        } else {
                            Group group;
                            HashMap<String, Group> groupMap = new HashMap<String, Group>();
                            Group[] groupArray = modelGroups;
                            int n = modelGroups.length;
                            int n3 = 0;
                            while (n3 < n) {
                                group = groupArray[n3];
                                groupMap.put(group.getDisplayName(), group);
                                groupMap.put(Integer.toString(group.getGroupId()), group);
                                ++n3;
                            }
                            groupArray = importedGroups;
                            n = importedGroups.length;
                            n3 = 0;
                            while (n3 < n) {
                                group = groupArray[n3];
                                if (groupMap.containsKey(Integer.toString(group.getGroupId()))) {
                                    this.mergeGroups((Group)groupMap.get(Integer.toString(group.getGroupId())), group);
                                } else if (groupMap.containsKey(group.getDisplayName())) {
                                    this.mergeGroups((Group)groupMap.get(group.getDisplayName()), group);
                                } else {
                                    this.getController().addNewGroup(group);
                                }
                                ++n3;
                            }
                        }
                    }
                    Vector<Account> accountVector = this.getContest().getAccounts(ClientType.Type.TEAM);
                    Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
                    this.importData = LoadICPCData.loadAccounts(this.lastDir, this.getContest().getGroups(), accounts);
                    this.changeDisplayFormat();
                }
                if (newFileProblem) {
                    this.log.warning("Problem reading PC2_Contest.tab " + newFile.getCanonicalPath());
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Could not open file " + newFile, "Warning", 2);
                }
            }
            catch (Exception e) {
                this.log.log(Log.WARNING, "Exception ", e);
            }
        }
    }

    private JButton getChangeDisplayFormatButton() {
        if (this.changeDisplayFormatButton == null) {
            this.changeDisplayFormatButton = new JButton();
            this.changeDisplayFormatButton.setText("Change Display Format");
            this.changeDisplayFormatButton.setToolTipText("Change Name Display Choice");
            this.changeDisplayFormatButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCPane.this.changeDisplayFormat();
                }
            });
        }
        return this.changeDisplayFormatButton;
    }

    protected void changeDisplayFormat() {
        if (this.importData == null) {
            JOptionPane.showMessageDialog(this, "Please 'Import' icpc data first.", "Error", 0);
            return;
        }
        if (this.importData.getAccounts() != null) {
            this.getICPCAccountFrame().setICPCAccounts(this.importData.getAccounts());
            this.getICPCAccountFrame().setContestAndController(this.getContest(), this.getController());
            this.getICPCAccountFrame().setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "No accounts loaded.", "Warning", 2);
        }
    }

    private void mergeGroups(Group dstGroup, Group srcGroup) {
        if (dstGroup.isSameAs(srcGroup)) {
            return;
        }
        dstGroup.setDisplayName(srcGroup.getDisplayName());
        dstGroup.setGroupId(srcGroup.getGroupId());
        if (srcGroup.getSite() != null) {
            dstGroup.setSite(srcGroup.getSite());
        }
        this.getController().updateGroup(dstGroup);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }
}

