/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public final class FrameUtilities {
    private static final long serialVersionUID = -1342163314986200464L;

    private FrameUtilities() {
    }

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
    }

    public static void setJavaLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
    }

    public static void centerFrame(Component component) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        component.setLocation(screenDim.width / 2 - component.getSize().width / 2, screenDim.height / 2 - component.getSize().height / 2);
    }

    public static void centerFrameTop(Component component) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        component.setLocation(screenDim.width / 2 - component.getSize().width / 2, 20);
    }

    public static void centerFrameOver(Component parentFrame, Component component) {
        if (parentFrame == null) {
            FrameUtilities.centerFrame(component);
        } else {
            Rectangle parentRect = parentFrame.getBounds();
            Rectangle myRect = component.getBounds();
            int x = myRect.width > parentRect.width ? parentRect.x : (parentRect.width - myRect.width) / 2 + parentRect.x;
            int y = myRect.height > parentRect.height ? parentRect.y : (parentRect.height - myRect.height) / 2 + parentRect.y;
            component.setBounds(x, y, myRect.width, myRect.height);
        }
    }

    public static void setFrameWindowWidth(Component component) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize(new Dimension(screenDim.width, component.getHeight()));
    }

    public static void waitCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void regularCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void windowToRight(Component sourceComponent, Component otherComponent) {
        int rightX = sourceComponent.getX() + sourceComponent.getWidth();
        otherComponent.setLocation(rightX, otherComponent.getY());
    }

    public static int yesNoCancelDialog(Component parentFrame, String message, String title) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        Object[] options = new Object[]{"Yes", "No", "Cancel"};
        int result = JOptionPane.showOptionDialog(parentFrame, message, title, -1, 3, null, options, options[2]);
        return result;
    }

    public static void centerFrameFullScreenHeight(Component component) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension currDim = component.getSize();
        int newHeight = screenDim.height - 120;
        component.setSize(currDim.getSize().width, newHeight);
        component.setLocation(screenDim.width / 2 - component.getSize().width / 2, screenDim.height / 2 - component.getSize().height / 2);
    }

    public static void setFramePosition(Component component, HorizontalPosition horizontalPosition, VerticalPosition verticalPosition) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = component.getX();
        int newY = component.getY();
        if (verticalPosition == VerticalPosition.TOP) {
            newY = 20;
        } else if (verticalPosition == VerticalPosition.BOTTOM) {
            newY = screenDim.height - component.getSize().height - 20;
        } else if (verticalPosition == VerticalPosition.CENTER) {
            newY = screenDim.height / 2 - component.getSize().height / 2;
        }
        if (horizontalPosition == HorizontalPosition.LEFT) {
            newX = 20;
        } else if (horizontalPosition == HorizontalPosition.RIGHT) {
            newX = screenDim.width - component.getSize().width - 20;
        } else if (horizontalPosition == HorizontalPosition.CENTER) {
            newX = screenDim.width / 2 - component.getSize().width / 2;
        }
        component.setLocation(newX, newY);
    }

    public static void showMessage(JFrame parentFrame, String strTitle, String displayString) {
        final JDialog dialog = new JDialog(parentFrame, strTitle, true);
        final JOptionPane optionPane = new JOptionPane(displayString, 1);
        dialog.setDefaultCloseOperation(0);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setContentPane(optionPane);
        dialog.pack();
        FrameUtilities.centerFrameOver(parentFrame, dialog);
        dialog.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalPosition {
        LEFT,
        RIGHT,
        CENTER,
        NO_CHANGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalPosition {
        TOP,
        CENTER,
        BOTTOM,
        NO_CHANGE;

    }
}

