/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.GroupPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditGroupFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -6248957592340866836L;
    private IInternalContest contest;
    private IInternalController controller;
    private GroupPane groupPane = null;

    public EditGroupFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(549, 278));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getGroupPane());
        this.setTitle("New Group");
        FrameUtilities.centerFrame(this);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getGroupPane().setContestAndController(this.contest, this.controller);
        this.getGroupPane().setParentFrame(this);
    }

    public void setGroup(Group group) {
        if (group == null) {
            this.setTitle("Add New Group");
        } else {
            this.setTitle("Edit Group " + group.getDisplayName());
        }
        this.getGroupPane().setGroup(group);
    }

    public String getPluginTitle() {
        return "Edit Group Frame";
    }

    private GroupPane getGroupPane() {
        if (this.groupPane == null) {
            this.groupPane = new GroupPane();
        }
        return this.groupPane;
    }
}

