/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FilterFormatter;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JCheckBoxJList;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class EditFilterPane
extends JPanePlugin {
    private static final long serialVersionUID = 1866852944568248601L;
    private JCheckBox filterOnCheckBox = null;
    private JPanel problemsPane = null;
    private JPanel bottomPanel = null;
    private JPanel languagesPane = null;
    private JPanel teamsPane = null;
    private JPanel judgementsPane = null;
    private JPanel listsPanel = null;
    private JPanel mainPane = null;
    private JScrollPane judgementsScroll = null;
    private JScrollPane teamsScroll = null;
    private JScrollPane problemsScroll = null;
    private JScrollPane languagesScroll = null;
    private JCheckBoxJList judgementListBox = null;
    private DefaultListModel judgementListModel = new DefaultListModel();
    private JCheckBoxJList teamListBox = null;
    private DefaultListModel teamListModel = new DefaultListModel();
    private JCheckBoxJList problemsListBox = null;
    private DefaultListModel problemListModel = new DefaultListModel();
    private JCheckBoxJList languagesListBox = null;
    private DefaultListModel languageListModel = new DefaultListModel();
    private Filter filter = new Filter();
    private JScrollPane jScrollPane = null;
    private JPanel runStatesPane = null;
    private JCheckBoxJList runStatesListBox = null;
    private DefaultListModel runStatesListModel = new DefaultListModel();
    private DefaultListModel clarificationStatesListModel = new DefaultListModel();
    private DefaultListModel sitesListModel = new DefaultListModel();
    private JPanel timeRangePane = null;
    private JLabel fromTimeLabel = null;
    private JTextField fromTimeTextField = null;
    private JLabel toTimeLabel = null;
    private JTextField toTimeTextField = null;
    private DisplayTeamName displayTeamName = null;
    private boolean isJudgeModule = false;
    private boolean filteringClarifications = false;
    private JPanel clarificationStatesPane = null;
    private JScrollPane clarificationStateScrollPane = null;
    private JList clarificationStatesListBox = null;
    private JPanel sitesPane = null;
    private JScrollPane sitesScroll = null;
    private JCheckBoxJList siteListBox = null;

    public EditFilterPane() {
        this.initialize();
    }

    public EditFilterPane(Filter filter) {
        this.initialize();
        this.filter = filter;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(493, 337));
        this.add((Component)this.getMainPane(), "Center");
    }

    public String getPluginTitle() {
        return "Edit Filter";
    }

    private JCheckBox getFilterOnCheckBox() {
        if (this.filterOnCheckBox == null) {
            this.filterOnCheckBox = new JCheckBox();
            this.filterOnCheckBox.setText("Filter On");
            this.filterOnCheckBox.setMnemonic(70);
        }
        return this.filterOnCheckBox;
    }

    private JPanel getProblemsPane() {
        if (this.problemsPane == null) {
            this.problemsPane = new JPanel();
            this.problemsPane.setLayout(new BorderLayout());
            this.problemsPane.setBorder(BorderFactory.createTitledBorder(null, "Problems", 0, 0, null, null));
            this.problemsPane.setName("problemFrame");
            this.problemsPane.add((Component)this.getProblemsScroll(), "Center");
        }
        return this.problemsPane;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.bottomPanel.add((Component)this.getFilterOnCheckBox(), null);
        }
        return this.bottomPanel;
    }

    private JPanel getLanguagesPane() {
        if (this.languagesPane == null) {
            this.languagesPane = new JPanel();
            this.languagesPane.setLayout(new BorderLayout());
            this.languagesPane.setBorder(BorderFactory.createTitledBorder(null, "Languages", 0, 0, null, null));
            this.languagesPane.setName("languagePane");
            this.languagesPane.add((Component)this.getLanguagesScroll(), "Center");
        }
        return this.languagesPane;
    }

    private JPanel getTeamsPane() {
        if (this.teamsPane == null) {
            this.teamsPane = new JPanel();
            this.teamsPane.setLayout(new BorderLayout());
            this.teamsPane.setBorder(BorderFactory.createTitledBorder(null, "Teams", 0, 0, null, null));
            this.teamsPane.setName("teamFrame");
            this.teamsPane.add((Component)this.getTeamsScroll(), "Center");
        }
        return this.teamsPane;
    }

    private JPanel getJudgementsPane() {
        if (this.judgementsPane == null) {
            this.judgementsPane = new JPanel();
            this.judgementsPane.setLayout(new BorderLayout());
            this.judgementsPane.setBorder(BorderFactory.createTitledBorder(null, "Judgements", 0, 0, null, null));
            this.judgementsPane.setName("judgementFrame");
            this.judgementsPane.add((Component)this.getJudgementsScroll(), "Center");
        }
        return this.judgementsPane;
    }

    private JPanel getListsPanel() {
        if (this.listsPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.listsPanel = new JPanel();
            this.listsPanel.setLayout(gridLayout);
            this.listsPanel.add((Component)this.getTimeRangePane(), null);
        }
        return this.listsPanel;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getBottomPanel(), "South");
            this.mainPane.add((Component)this.getListsPanel(), "Center");
        }
        return this.mainPane;
    }

    private JScrollPane getJudgementsScroll() {
        if (this.judgementsScroll == null) {
            this.judgementsScroll = new JScrollPane();
            this.judgementsScroll.setViewportView(this.getJudgementListBox());
        }
        return this.judgementsScroll;
    }

    private JScrollPane getTeamsScroll() {
        if (this.teamsScroll == null) {
            this.teamsScroll = new JScrollPane();
            this.teamsScroll.setViewportView(this.getTeamListBox());
        }
        return this.teamsScroll;
    }

    private JScrollPane getProblemsScroll() {
        if (this.problemsScroll == null) {
            this.problemsScroll = new JScrollPane();
            this.problemsScroll.setViewportView(this.getProblemsListBox());
        }
        return this.problemsScroll;
    }

    private JScrollPane getLanguagesScroll() {
        if (this.languagesScroll == null) {
            this.languagesScroll = new JScrollPane();
            this.languagesScroll.setViewportView(this.getLanguagesListBox());
        }
        return this.languagesScroll;
    }

    private JCheckBoxJList getJudgementListBox() {
        if (this.judgementListBox == null) {
            this.judgementListBox = new JCheckBoxJList((ListModel)this.judgementListModel);
        }
        return this.judgementListBox;
    }

    private JCheckBoxJList getTeamListBox() {
        if (this.teamListBox == null) {
            this.teamListBox = new JCheckBoxJList((ListModel)this.teamListModel);
        }
        return this.teamListBox;
    }

    private JCheckBoxJList getProblemsListBox() {
        if (this.problemsListBox == null) {
            this.problemsListBox = new JCheckBoxJList((ListModel)this.problemListModel);
        }
        return this.problemsListBox;
    }

    private JCheckBoxJList getLanguagesListBox() {
        if (this.languagesListBox == null) {
            this.languagesListBox = new JCheckBoxJList((ListModel)this.languageListModel);
        }
        return this.languagesListBox;
    }

    public void populateFields() {
        Clarification.ClarificationStates[] clarificationStates;
        Run.RunStates[] runStates;
        WrapperJCheckBox wrapperJCheckBox;
        WrapperJCheckBox wrapperJCheckBox2;
        Problem problem;
        this.getFilterOnCheckBox().setSelected(this.filter.isFilterOn());
        this.problemListModel.removeAllElements();
        if (this.isFilteringClarifications()) {
            problem = this.getContest().getGeneralProblem();
            WrapperJCheckBox wrapperJCheckBox3 = new WrapperJCheckBox(problem);
            if (this.filter.isFilteringProblems()) {
                wrapperJCheckBox3.setSelected(this.filter.matchesProblem(problem));
            }
            this.problemListModel.addElement(wrapperJCheckBox3);
        }
        IElementObject[] iElementObjectArray = this.getContest().getProblems();
        int n = iElementObjectArray.length;
        int wrapperJCheckBox3 = 0;
        while (wrapperJCheckBox3 < n) {
            problem = iElementObjectArray[wrapperJCheckBox3];
            wrapperJCheckBox2 = new WrapperJCheckBox(problem);
            if (this.filter.isFilteringProblems()) {
                wrapperJCheckBox2.setSelected(this.filter.matchesProblem(problem));
            }
            this.problemListModel.addElement(wrapperJCheckBox2);
            ++wrapperJCheckBox3;
        }
        this.languageListModel.removeAllElements();
        iElementObjectArray = this.getContest().getLanguages();
        n = iElementObjectArray.length;
        wrapperJCheckBox3 = 0;
        while (wrapperJCheckBox3 < n) {
            IElementObject language = iElementObjectArray[wrapperJCheckBox3];
            wrapperJCheckBox2 = new WrapperJCheckBox(language);
            if (this.filter.isFilteringLanguages()) {
                wrapperJCheckBox2.setSelected(this.filter.matchesLanguage((Language)language));
            }
            this.languageListModel.addElement(wrapperJCheckBox2);
            ++wrapperJCheckBox3;
        }
        this.sitesListModel.removeAllElements();
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        IElementObject[] iElementObjectArray2 = sites;
        int n2 = sites.length;
        n = 0;
        while (n < n2) {
            Site site = iElementObjectArray2[n];
            wrapperJCheckBox = new WrapperJCheckBox(site, String.valueOf(site.getSiteNumber()) + " " + site.getDisplayName());
            if (this.filter.isFilteringSites()) {
                wrapperJCheckBox.setSelected(this.filter.matchesSite(site));
            }
            this.sitesListModel.addElement(wrapperJCheckBox);
            ++n;
        }
        this.judgementListModel.removeAllElements();
        iElementObjectArray2 = this.getContest().getJudgements();
        n2 = iElementObjectArray2.length;
        n = 0;
        while (n < n2) {
            IElementObject judgement = iElementObjectArray2[n];
            wrapperJCheckBox = new WrapperJCheckBox(judgement);
            if (this.filter.isFilteringJudgements()) {
                wrapperJCheckBox.setSelected(this.filter.matchesJudgement((Judgement)judgement));
            }
            this.judgementListModel.addElement(wrapperJCheckBox);
            ++n;
        }
        this.loadTeamNames(this.filter);
        this.runStatesListModel.removeAllElements();
        Run.RunStates[] runStatesArray = runStates = Run.RunStates.values();
        int n3 = runStates.length;
        n2 = 0;
        while (n2 < n3) {
            Run.RunStates runState = runStatesArray[n2];
            WrapperJCheckBox wrapperJCheckBox4 = new WrapperJCheckBox((Object)runState);
            if (this.filter.isFilteringRunStates()) {
                wrapperJCheckBox4.setSelected(this.filter.matchesRunState(runState));
            }
            this.runStatesListModel.addElement(wrapperJCheckBox4);
            ++n2;
        }
        this.clarificationStatesListModel.removeAllElements();
        Clarification.ClarificationStates[] clarificationStatesArray = clarificationStates = Clarification.ClarificationStates.values();
        int n4 = clarificationStates.length;
        n3 = 0;
        while (n3 < n4) {
            Clarification.ClarificationStates clarificationState = clarificationStatesArray[n3];
            WrapperJCheckBox wrapperJCheckBox5 = new WrapperJCheckBox((Object)clarificationState);
            if (this.filter.isFilteringClarificationStates()) {
                wrapperJCheckBox5.setSelected(this.filter.matchesClarificationState(clarificationState));
            }
            this.clarificationStatesListModel.addElement(wrapperJCheckBox5);
            ++n3;
        }
        this.getFromTimeTextField().setText("");
        this.getToTimeTextField().setText("");
        if (this.filter.isFilteringElapsedTime()) {
            if (this.filter.getStartElapsedTime() >= 0L) {
                this.getFromTimeTextField().setText("" + this.filter.getStartElapsedTime());
            }
            if (this.filter.getEndElapsedTime() >= 0L) {
                this.getToTimeTextField().setText("" + this.filter.getEndElapsedTime());
            }
        }
    }

    protected void populateTeamNamesWithDisplayMask() {
        if (this.isJudgeModule) {
            ContestInformation contestInformation = this.getContest().getContestInformation();
            if (this.displayTeamName == null) {
                this.displayTeamName = new DisplayTeamName();
            }
            this.displayTeamName.setTeamDisplayMask(contestInformation.getTeamDisplayMode());
            Filter teamsFilter = new Filter();
            teamsFilter.clearAccountList();
            Enumeration enumeration = this.teamListModel.elements();
            while (enumeration.hasMoreElements()) {
                WrapperJCheckBox element = (WrapperJCheckBox)enumeration.nextElement();
                if (!element.isSelected()) continue;
                Object object = element.getContents();
                teamsFilter.addAccount((ClientId)object);
            }
            this.loadTeamNames(teamsFilter);
        }
    }

    private void loadTeamNames(Filter inFilter) {
        Vector<Account> vector = this.getContest().getAccounts(ClientType.Type.TEAM);
        Account[] accounts = vector.toArray(new Account[vector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        this.teamListModel.removeAllElements();
        WrapperJCheckBox wrapperJCheckBox = null;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            wrapperJCheckBox = this.displayTeamName != null ? new WrapperJCheckBox(account.getClientId(), this.displayTeamName) : new WrapperJCheckBox(account.getClientId());
            if (inFilter.isFilteringAccounts()) {
                wrapperJCheckBox.setSelected(inFilter.matchesAccount(account));
            }
            this.teamListModel.addElement(wrapperJCheckBox);
            ++n2;
        }
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.isJudgeModule = this.getContest().getClientId().getClientType().equals((Object)ClientType.Type.JUDGE);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditFilterPane.this.populateFields();
            }
        });
    }

    public Filter getFilter() {
        Object object;
        WrapperJCheckBox element;
        this.filter.setFilter(this.getFilterOnCheckBox().isSelected());
        this.filter.clearProblemList();
        Enumeration enumeration = this.problemListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = (WrapperJCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addProblem((Problem)object);
        }
        this.filter.clearLanguageList();
        enumeration = this.languageListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = (WrapperJCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addLanguage((Language)object);
        }
        this.filter.clearAccountList();
        enumeration = this.teamListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = (WrapperJCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addAccount((ClientId)object);
        }
        this.filter.clearRunStatesList();
        enumeration = this.runStatesListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = (WrapperJCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addRunState((Run.RunStates)((Object)object));
        }
        this.filter.clearClarificationStateList();
        enumeration = this.clarificationStatesListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = (WrapperJCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addClarificationState((Clarification.ClarificationStates)((Object)object));
        }
        this.filter.clearJudgementList();
        enumeration = this.judgementListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = (WrapperJCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addJudgement((Judgement)object);
        }
        this.filter.clearSiteList();
        enumeration = this.sitesListModel.elements();
        while (enumeration.hasMoreElements()) {
            element = (WrapperJCheckBox)enumeration.nextElement();
            if (!element.isSelected()) continue;
            object = element.getContents();
            this.filter.addSite((Site)object);
        }
        this.filter.clearElapsedTime();
        if (this.getFromTimeTextField().getText().length() > 0) {
            this.filter.setStartElapsedTime(Long.parseLong(this.getFromTimeTextField().getText()));
        }
        if (this.getToTimeTextField().getText().length() > 0) {
            this.filter.setEndElapsedTime(Long.parseLong(this.getToTimeTextField().getText()));
        }
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditFilterPane.this.populateFields();
            }
        });
    }

    protected void printAllSpecifiers(String prefix, IInternalContest contest, Filter inFilter) {
        Object[] names = new String[]{"%T", "%J", "%L", "%#T", "%#J", "%#L", "%#P", "%P", "%n", "%t", "%C", "%s", "%e"};
        Arrays.sort(names);
        FilterFormatter filterFormatter = new FilterFormatter();
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            System.out.println(String.valueOf(prefix) + " " + (String)string + " '" + filterFormatter.format((String)string, contest, inFilter) + "'");
            ++n2;
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getRunStatesListBox());
        }
        return this.jScrollPane;
    }

    private JPanel getRunStatesPane() {
        if (this.runStatesPane == null) {
            this.runStatesPane = new JPanel();
            this.runStatesPane.setLayout(new BorderLayout());
            this.runStatesPane.setBorder(BorderFactory.createTitledBorder(null, "Run States", 0, 0, null, null));
            this.runStatesPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.runStatesPane;
    }

    private JCheckBoxJList getRunStatesListBox() {
        if (this.runStatesListBox == null) {
            this.runStatesListBox = new JCheckBoxJList((ListModel)this.runStatesListModel);
        }
        return this.runStatesListBox;
    }

    public void addList(ListNames listName) {
        switch (listName) {
            case ACCOUNTS: {
                this.listsPanel.add((Component)this.getTeamsPane(), 0);
                break;
            }
            case LANGUAGES: {
                this.listsPanel.add((Component)this.getLanguagesPane(), 0);
                break;
            }
            case PROBLEMS: {
                this.listsPanel.add((Component)this.getProblemsPane(), 0);
                break;
            }
            case JUDGEMENTS: {
                this.listsPanel.add((Component)this.getJudgementsPane(), 0);
                break;
            }
            case RUN_STATES: {
                this.listsPanel.add((Component)this.getRunStatesPane(), 0);
                break;
            }
            case CLARIFICATION_STATES: {
                this.listsPanel.add((Component)this.getClarificationStatesPane(), 0);
                break;
            }
            case TIME_RANGE: {
                this.listsPanel.add((Component)this.getClarificationStatesPane(), 0);
                break;
            }
            case SITES: {
                this.listsPanel.add((Component)this.getSitesPane(), 0);
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid listNames: " + (Object)((Object)listName));
            }
        }
    }

    private JPanel getTimeRangePane() {
        if (this.timeRangePane == null) {
            this.toTimeLabel = new JLabel();
            this.toTimeLabel.setText("To");
            this.fromTimeLabel = new JLabel();
            this.fromTimeLabel.setText("From");
            this.timeRangePane = new JPanel();
            this.timeRangePane.setBorder(BorderFactory.createTitledBorder(null, "Time Range", 0, 0, null, null));
            this.timeRangePane.add((Component)this.fromTimeLabel, null);
            this.timeRangePane.add((Component)this.getFromTimeTextField(), null);
            this.timeRangePane.add((Component)this.toTimeLabel, null);
            this.timeRangePane.add((Component)this.getToTimeTextField(), null);
        }
        return this.timeRangePane;
    }

    private JTextField getFromTimeTextField() {
        if (this.fromTimeTextField == null) {
            this.fromTimeTextField = new JTextField();
            this.fromTimeTextField.setDocument(new IntegerDocument());
            this.fromTimeTextField.setPreferredSize(new Dimension(60, 20));
        }
        return this.fromTimeTextField;
    }

    private JTextField getToTimeTextField() {
        if (this.toTimeTextField == null) {
            this.toTimeTextField = new JTextField();
            this.toTimeTextField.setDocument(new IntegerDocument());
            this.toTimeTextField.setPreferredSize(new Dimension(60, 20));
        }
        return this.toTimeTextField;
    }

    public DisplayTeamName getDisplayTeamName() {
        return this.displayTeamName;
    }

    public void setDisplayTeamName(DisplayTeamName displayTeamName) {
        this.displayTeamName = displayTeamName;
    }

    private JPanel getClarificationStatesPane() {
        if (this.clarificationStatesPane == null) {
            this.clarificationStatesPane = new JPanel();
            this.clarificationStatesPane.setLayout(new BorderLayout());
            this.clarificationStatesPane.setBorder(BorderFactory.createTitledBorder(null, "Clar States", 0, 0, null, null));
            this.clarificationStatesPane.setVisible(true);
            this.clarificationStatesPane.add((Component)this.getClarificationStateScrollPane(), "Center");
        }
        return this.clarificationStatesPane;
    }

    private JScrollPane getClarificationStateScrollPane() {
        if (this.clarificationStateScrollPane == null) {
            this.clarificationStateScrollPane = new JScrollPane();
            this.clarificationStateScrollPane.setViewportView(this.getClarificationStatesListBox());
        }
        return this.clarificationStateScrollPane;
    }

    private JList getClarificationStatesListBox() {
        if (this.clarificationStatesListBox == null) {
            this.clarificationStatesListBox = new JCheckBoxJList((ListModel)this.clarificationStatesListModel);
        }
        return this.clarificationStatesListBox;
    }

    public boolean isFilteringClarifications() {
        return this.filteringClarifications;
    }

    public void setFilteringClarifications(boolean filteringClarifications) {
        this.filteringClarifications = filteringClarifications;
    }

    private JPanel getSitesPane() {
        if (this.sitesPane == null) {
            this.sitesPane = new JPanel();
            this.sitesPane.setLayout(new BorderLayout());
            this.sitesPane.setName("sitesPane");
            this.sitesPane.setBorder(BorderFactory.createTitledBorder(null, "Sites", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.sitesPane.setSize(new Dimension(251, 151));
            this.sitesPane.add((Component)this.getSitesScroll(), "Center");
        }
        return this.sitesPane;
    }

    private JScrollPane getSitesScroll() {
        if (this.sitesScroll == null) {
            this.sitesScroll = new JScrollPane();
            this.sitesScroll.setViewportView(this.getSiteListBox());
        }
        return this.sitesScroll;
    }

    private JCheckBoxJList getSiteListBox() {
        if (this.siteListBox == null) {
            this.siteListBox = new JCheckBoxJList((ListModel)this.sitesListModel);
        }
        return this.siteListBox;
    }

    public class ContestInformationListenerImplementation
    implements IContestInformationListener {
        public void contestInformationAdded(ContestInformationEvent event) {
            EditFilterPane.this.populateTeamNamesWithDisplayMask();
        }

        public void contestInformationChanged(ContestInformationEvent event) {
            EditFilterPane.this.populateTeamNamesWithDisplayMask();
        }

        public void contestInformationRemoved(ContestInformationEvent event) {
            EditFilterPane.this.populateTeamNamesWithDisplayMask();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListNames {
        LANGUAGES,
        PROBLEMS,
        JUDGEMENTS,
        RUN_STATES,
        CLARIFICATION_STATES,
        ACCOUNTS,
        TIME_RANGE,
        SITES;

    }

    protected class WrapperJCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = 991427730095971274L;
        private Object contents;

        public WrapperJCheckBox(Object object) {
            this(object, object.toString());
        }

        public WrapperJCheckBox(Object object, String text) {
            this.contents = object;
            this.setText(text);
        }

        public WrapperJCheckBox(ClientId clientId, DisplayTeamName displayTeamName) {
            this.contents = clientId;
            this.setText(displayTeamName.getDisplayName(clientId));
        }

        public Object getContents() {
            return this.contents;
        }
    }
}

