/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.AccountPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditAccountFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -2154916224530006165L;
    private IInternalContest contest;
    private IInternalController controller;
    private AccountPane accountPane = null;

    public EditAccountFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(550, 450));
        this.setPreferredSize(new Dimension(399, 320));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getAccountPane());
        this.setTitle("New Account");
        FrameUtilities.centerFrame(this);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getAccountPane().setContestAndController(this.contest, this.controller);
        this.getAccountPane().setParentFrame(this);
    }

    public void setAccount(Account account) {
        if (account == null) {
            this.setTitle("Add New Account");
        } else {
            this.setTitle("Edit Account " + account.getClientId().getName() + " (Site " + account.getSiteNumber() + ")");
        }
        this.getAccountPane().setAccount(account);
    }

    public String getPluginTitle() {
        return "Edit Account Frame";
    }

    private AccountPane getAccountPane() {
        if (this.accountPane == null) {
            this.accountPane = new AccountPane();
        }
        return this.accountPane;
    }
}

