/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DisplayNameFormatterPane
extends JPanePlugin {
    private static final long serialVersionUID = 3268060113515844016L;
    public static final String CHANGE_PROPERTY = "displayChoice";
    private DisplayNameChoice savedChoice = DisplayNameChoice.TEAMANDSHORTSCHOOLNAME;
    private JPanel buttonPanel = null;
    private JButton applyButton = null;
    private JButton cancelButton = null;
    private JPanel choicesPanel = null;
    private JRadioButton teamAndSchoolNameButton = null;
    private JRadioButton schoolNameButton = null;
    private JRadioButton shortSchoolNameButton = null;
    private JRadioButton teamNameButton = null;
    private ButtonGroup displayNameButtonGroup = null;

    public DisplayNameFormatterPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(578, 251));
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)this.getChoicesPanel(), "Center");
        this.enableUpdateButton();
    }

    public String getPluginTitle() {
        return "Display Name Formatter Pane";
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.setPreferredSize(new Dimension(10, 35));
            this.buttonPanel.add((Component)this.getApplyButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton();
            this.applyButton.setText("Apply");
            this.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DisplayNameChoice newChoice = DisplayNameFormatterPane.this.getCurrentSelection();
                    if (newChoice != null && !DisplayNameFormatterPane.this.savedChoice.equals((Object)newChoice)) {
                        DisplayNameFormatterPane.this.firePropertyChange(DisplayNameFormatterPane.CHANGE_PROPERTY, DisplayNameFormatterPane.this.savedChoice.toString(), newChoice.toString());
                        DisplayNameFormatterPane.this.savedChoice = newChoice;
                    }
                    DisplayNameFormatterPane.this.enableUpdateButton();
                }
            });
        }
        return this.applyButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    switch (DisplayNameFormatterPane.this.savedChoice) {
                        case TEAMANDSHORTSCHOOLNAME: {
                            DisplayNameFormatterPane.this.getDisplayNameButtonGroup().setSelected(DisplayNameFormatterPane.this.getTeamAndSchoolNameButton().getModel(), true);
                            break;
                        }
                        case SCHOOLNAME: {
                            DisplayNameFormatterPane.this.getDisplayNameButtonGroup().setSelected(DisplayNameFormatterPane.this.getSchoolNameButton().getModel(), true);
                            break;
                        }
                        case SHORTSCHOOLNAME: {
                            DisplayNameFormatterPane.this.getDisplayNameButtonGroup().setSelected(DisplayNameFormatterPane.this.getShortSchoolNameButton().getModel(), true);
                            break;
                        }
                        case TEAMNAME: {
                            DisplayNameFormatterPane.this.getDisplayNameButtonGroup().setSelected(DisplayNameFormatterPane.this.getTeamNameButton().getModel(), true);
                            break;
                        }
                    }
                    DisplayNameFormatterPane.this.enableUpdateButton();
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getChoicesPanel() {
        if (this.choicesPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(4);
            gridLayout.setColumns(1);
            this.choicesPanel = new JPanel();
            this.choicesPanel.setLayout(gridLayout);
            this.choicesPanel.setBorder(BorderFactory.createTitledBorder(null, "Display Name Choices", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.choicesPanel.add((Component)this.getTeamAndSchoolNameButton(), null);
            this.choicesPanel.add((Component)this.getSchoolNameButton(), null);
            this.choicesPanel.add((Component)this.getTeamAndSchoolNameButton(), null);
            this.choicesPanel.add((Component)this.getShortSchoolNameButton(), null);
            this.choicesPanel.add((Component)this.getTeamNameButton(), null);
            this.getDisplayNameButtonGroup().setSelected(this.getTeamAndSchoolNameButton().getModel(), true);
        }
        return this.choicesPanel;
    }

    private JRadioButton getTeamAndSchoolNameButton() {
        if (this.teamAndSchoolNameButton == null) {
            this.teamAndSchoolNameButton = new JRadioButton();
            this.teamAndSchoolNameButton.setText("Team and Short School Name ex: Hornet 1 (Sacramento State)");
            this.teamAndSchoolNameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DisplayNameFormatterPane.this.enableUpdateButton();
                }
            });
        }
        return this.teamAndSchoolNameButton;
    }

    private JRadioButton getSchoolNameButton() {
        if (this.schoolNameButton == null) {
            this.schoolNameButton = new JRadioButton();
            this.schoolNameButton.setText("School Name ex:  California State University, Sacramento");
            this.schoolNameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DisplayNameFormatterPane.this.enableUpdateButton();
                }
            });
        }
        return this.schoolNameButton;
    }

    protected void enableUpdateButton() {
        DisplayNameChoice newChoice = this.getCurrentSelection();
        if (newChoice.equals((Object)this.savedChoice)) {
            this.setEnableButtons(false);
        } else {
            this.setEnableButtons(true);
        }
    }

    void setEnableButtons(boolean isEnabled) {
        this.getApplyButton().setEnabled(isEnabled);
        this.getCancelButton().setEnabled(isEnabled);
    }

    private JRadioButton getShortSchoolNameButton() {
        if (this.shortSchoolNameButton == null) {
            this.shortSchoolNameButton = new JRadioButton();
            this.shortSchoolNameButton.setText("Short School Name ex: Sacramento State");
            this.shortSchoolNameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DisplayNameFormatterPane.this.enableUpdateButton();
                }
            });
        }
        return this.shortSchoolNameButton;
    }

    private JRadioButton getTeamNameButton() {
        if (this.teamNameButton == null) {
            this.teamNameButton = new JRadioButton();
            this.teamNameButton.setText("Team Name ex: Hornet 1");
            this.teamNameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DisplayNameFormatterPane.this.enableUpdateButton();
                }
            });
        }
        return this.teamNameButton;
    }

    private ButtonGroup getDisplayNameButtonGroup() {
        if (this.displayNameButtonGroup == null) {
            this.displayNameButtonGroup = new ButtonGroup();
            this.displayNameButtonGroup.add(this.getSchoolNameButton());
            this.displayNameButtonGroup.add(this.getTeamAndSchoolNameButton());
            this.displayNameButtonGroup.add(this.getShortSchoolNameButton());
            this.displayNameButtonGroup.add(this.getTeamNameButton());
        }
        return this.displayNameButtonGroup;
    }

    public DisplayNameChoice getCurrentSelection() {
        DisplayNameChoice newChoice = null;
        if (this.getTeamAndSchoolNameButton().isSelected()) {
            newChoice = DisplayNameChoice.TEAMANDSHORTSCHOOLNAME;
        }
        if (this.getSchoolNameButton().isSelected()) {
            newChoice = DisplayNameChoice.SCHOOLNAME;
        }
        if (this.getShortSchoolNameButton().isSelected()) {
            newChoice = DisplayNameChoice.SHORTSCHOOLNAME;
        }
        if (this.getTeamNameButton().isSelected()) {
            newChoice = DisplayNameChoice.TEAMNAME;
        }
        return newChoice;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayNameChoice {
        TEAMANDSHORTSCHOOLNAME,
        SCHOOLNAME,
        SHORTSCHOOLNAME,
        TEAMNAME;

    }
}

