/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.RomanNumeral;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CountDownMessage
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1066929023214360936L;
    public static final String SVN_ID = "$Id: CountDownMessage.java 94 2007-04-01 03:35:27Z laned $";
    private JPanel contentsPanel = null;
    private JPanel southPane = null;
    private JPanel centerPane = null;
    private JButton closeButton = null;
    private JLabel countdownTimerLabel = null;
    private boolean exitOnClose = false;
    private String prefixToTime = "";
    private int inputRemainingSeconds = 10;
    private Timer timer = new Timer(500, this);
    private long endMilliSeconds;

    public CountDownMessage() {
        this.initialize();
        this.startCountdown();
    }

    public CountDownMessage(String prefixToTime, int secondsBeforeExit) {
        this.initialize();
        this.setRemainingSeconds(secondsBeforeExit);
        String remainSring = String.valueOf(prefixToTime) + new RomanNumeral(secondsBeforeExit).toString() + " seconds";
        this.countdownTimerLabel.setText(remainSring);
        this.setEnabled(true);
        this.setPrefixToTime(prefixToTime);
        this.startCountdown();
    }

    private void startCountdown() {
        this.endMilliSeconds = new Date().getTime() + (long)(this.inputRemainingSeconds * 1000);
        this.timer.start();
    }

    private void initialize() {
        this.setSize(new Dimension(503, 135));
        this.setContentPane(this.getContentsPanel());
        this.setTitle("Countdown Message");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CountDownMessage.this.actionOnClose();
            }
        });
        this.centerFrameTop();
    }

    private JPanel getContentsPanel() {
        if (this.contentsPanel == null) {
            this.contentsPanel = new JPanel();
            this.contentsPanel.setLayout(new BorderLayout());
            this.contentsPanel.add((Component)this.getSouthPane(), "South");
            this.contentsPanel.add((Component)this.getCenterPane(), "Center");
        }
        return this.contentsPanel;
    }

    private JPanel getSouthPane() {
        if (this.southPane == null) {
            this.southPane = new JPanel();
            this.southPane.add((Component)this.getCloseButton(), null);
        }
        return this.southPane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.countdownTimerLabel = new JLabel();
            this.countdownTimerLabel.setText("");
            this.countdownTimerLabel.setFont(new Font("Dialog", 0, 18));
            this.countdownTimerLabel.setHorizontalAlignment(0);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)this.countdownTimerLabel, "Center");
        }
        return this.centerPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic(67);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CountDownMessage.this.actionOnClose();
                }
            });
        }
        return this.closeButton;
    }

    public void actionOnClose() {
        if (this.exitOnClose) {
            System.exit(4);
        } else {
            this.timer.stop();
            this.dispose();
        }
    }

    protected void centerFrame() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenDim.width / 2 - this.getSize().width / 2, screenDim.height / 2 - this.getSize().height / 2);
    }

    protected void centerFrameTop() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenDim.width / 2 - this.getSize().width / 2, 20);
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public int getRemainingSeconds() {
        return this.inputRemainingSeconds;
    }

    public void setRemainingSeconds(int remainingSeconds) {
        this.inputRemainingSeconds = remainingSeconds;
    }

    public void actionPerformed(ActionEvent arg0) {
        long remainingSeconds = (this.endMilliSeconds - new Date().getTime()) / 1000L;
        String remainSring = new String();
        remainSring = remainingSeconds >= 1L ? String.valueOf(this.prefixToTime) + new RomanNumeral(remainingSeconds).toString() + " seconds" : String.valueOf(this.prefixToTime) + "0 seconds";
        this.countdownTimerLabel.setText(remainSring);
        if (remainingSeconds < 1L) {
            this.actionOnClose();
        }
    }

    public String getPrefixToTime() {
        return this.prefixToTime;
    }

    public void setPrefixToTime(String prefixToTime) {
        if (prefixToTime != null) {
            this.prefixToTime = prefixToTime;
        }
    }
}

