/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountNameComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.EditContestTimeFrame;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ContestTimesPane
extends JPanePlugin {
    private static final long serialVersionUID = -8946167067842024295L;
    private EditContestTimeFrame editContestTimeFrame = new EditContestTimeFrame();
    private JPanel contestTimeButtonPane = null;
    private MCLB contestTimeListBox = null;
    private JButton refreshButton = null;
    private JButton startClockButton = null;
    private JButton stopClockButton = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private PermissionList permissionList = new PermissionList();
    private JButton startAllButton = null;
    private JButton stopAllButton = null;
    private JButton editButton = null;
    private SimpleDateFormat formatter = new SimpleDateFormat(" HH:mm:ss MM-dd");
    private Logger log;

    public ContestTimesPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)((Object)this.getContestTimeListBox()), "Center");
        this.add((Component)this.getContestTimeButtonPane(), "South");
        this.add((Component)this.getMessagePane(), "North");
    }

    public String getPluginTitle() {
        return "Contest Times";
    }

    private JPanel getContestTimeButtonPane() {
        if (this.contestTimeButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.contestTimeButtonPane = new JPanel();
            this.contestTimeButtonPane.setLayout(flowLayout);
            this.contestTimeButtonPane.setPreferredSize(new Dimension(35, 35));
            this.contestTimeButtonPane.add((Component)this.getStartClockButton(), null);
            this.contestTimeButtonPane.add((Component)this.getRefreshButton(), null);
            this.contestTimeButtonPane.add((Component)this.getEditButton(), null);
            this.contestTimeButtonPane.add((Component)this.getStopClockButton(), null);
            this.contestTimeButtonPane.add((Component)this.getStartAllButton(), null);
            this.contestTimeButtonPane.add((Component)this.getStopAllButton(), null);
        }
        return this.contestTimeButtonPane;
    }

    private MCLB getContestTimeListBox() {
        if (this.contestTimeListBox == null) {
            this.contestTimeListBox = new MCLB();
            this.contestTimeListBox.setMultipleSelections(true);
            Object[] cols = new Object[]{"Site", "State", "Remaining", "Elapsed", "Length", "Logged In", "Since"};
            this.contestTimeListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter accountNameSorter = new HeapSorter();
            accountNameSorter.setComparator((Comparator)new AccountNameComparatorMCLB());
            this.contestTimeListBox.setColumnSorter(0, accountNameSorter, 1);
            this.contestTimeListBox.setColumnSorter(1, sorter, 2);
            this.contestTimeListBox.autoSizeAllColumns();
        }
        return this.contestTimeListBox;
    }

    public void updateContestTimeRow(final ContestTime contestTime) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = ContestTimesPane.this.buildContestTimeRow(contestTime);
                int rowNumber = ContestTimesPane.this.contestTimeListBox.getIndexByKey(contestTime.getElementId());
                if (rowNumber == -1) {
                    ContestTimesPane.this.contestTimeListBox.addRow(objects, contestTime.getElementId());
                } else {
                    ContestTimesPane.this.contestTimeListBox.replaceRow(objects, rowNumber);
                }
                ContestTimesPane.this.contestTimeListBox.autoSizeAllColumns();
                ContestTimesPane.this.contestTimeListBox.sort();
            }
        });
    }

    protected String[] buildContestTimeRow(ContestTime contestTime) {
        int numberColumns = this.contestTimeListBox.getColumnCount();
        String[] c = new String[numberColumns];
        c[0] = "Site " + contestTime.getSiteNumber();
        c[1] = "NO CONTACT";
        if (contestTime != null) {
            c[1] = contestTime.isContestRunning() ? "STARTED" : "STOPPED";
            c[2] = contestTime.getRemainingTimeStr();
            c[3] = contestTime.getElapsedTimeStr();
            c[4] = contestTime.getContestLengthStr();
            c[5] = "No";
            if (this.isThisSite(contestTime.getSiteNumber())) {
                c[5] = "N/A";
            }
            c[6] = "";
            try {
                ClientId serverId = new ClientId(contestTime.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.getContest().isLocalLoggedIn(serverId)) {
                    c[5] = "YES";
                    c[6] = this.formatter.format(this.getContest().getLocalLoggedInDate(serverId));
                } else if (!this.isServer(this.getContest().getClientId()) && this.getContest().isRemoteLoggedIn(serverId)) {
                    c[5] = "YES";
                    c[6] = "";
                }
            }
            catch (Exception e) {
                c[5] = "??";
                this.log.log(Log.WARNING, "Exception updating Contest Time for site " + contestTime.getSiteNumber(), e);
            }
        }
        return c;
    }

    private boolean isThisSite(int siteNumber) {
        return this.getContest().getSiteNumber() == siteNumber;
    }

    private void reloadListBox() {
        ContestTime[] contestTimes;
        this.contestTimeListBox.removeAllRows();
        ContestTime[] contestTimeArray = contestTimes = this.getContest().getContestTimes();
        int n = contestTimes.length;
        int n2 = 0;
        while (n2 < n) {
            ContestTime contestTime = contestTimeArray[n2];
            this.addContestTimeRow(contestTime);
            ++n2;
        }
    }

    private void addContestTimeRow(ContestTime contestTime) {
        this.updateContestTimeRow(contestTime);
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        Account account = this.getContest().getAccount(this.getContest().getClientId());
        if (account != null) {
            this.permissionList.clearAndLoadPermissions(account.getPermissionList());
        }
    }

    private void updateGUIperPermissions() {
        this.getStartClockButton().setVisible(this.isAllowed(Permission.Type.START_CONTEST_CLOCK));
        this.getStopClockButton().setVisible(this.isAllowed(Permission.Type.STOP_CONTEST_CLOCK));
        this.getStartAllButton().setVisible(this.isAllowed(Permission.Type.START_CONTEST_CLOCK));
        this.getStopAllButton().setVisible(this.isAllowed(Permission.Type.STOP_CONTEST_CLOCK));
        this.getEditButton().setVisible(this.isAllowed(Permission.Type.EDIT_CONTEST_CLOCK));
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.initializePermissions();
        this.getContest().addContestTimeListener(new ContestTimeListenerImplementation());
        this.getContest().addSiteListener(new SiteListenerImplementation());
        this.getContest().addLoginListener(new LoginListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.editContestTimeFrame.setContestAndController(inContest, inController);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ContestTimesPane.this.reloadListBox();
                ContestTimesPane.this.updateGUIperPermissions();
            }
        });
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setText("Refresh");
            this.refreshButton.setToolTipText("Refresh All Clocks");
            this.refreshButton.setToolTipText("Refresh Clocks on All sites");
            this.refreshButton.setMnemonic(82);
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimesPane.this.reloadListBox();
                }
            });
        }
        return this.refreshButton;
    }

    protected boolean isServer(ClientId clientId) {
        return clientId != null && clientId.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private JButton getStartClockButton() {
        if (this.startClockButton == null) {
            this.startClockButton = new JButton();
            this.startClockButton.setText("Start");
            this.startClockButton.setToolTipText("Start the contest clock on the selected site");
            this.startClockButton.setMnemonic(83);
            this.startClockButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimesPane.this.startClockTimes();
                }
            });
        }
        return this.startClockButton;
    }

    protected void startClockTimes() {
        int[] selectedSites = this.contestTimeListBox.getSelectedIndexes();
        if (selectedSites.length == 0) {
            this.showMessage("Please select site");
            return;
        }
        int i = 0;
        while (i < selectedSites.length) {
            ElementId contestTimeElementId = (ElementId)this.contestTimeListBox.getKeys()[selectedSites[i]];
            ContestTime contestTime = this.getContest().getContestTime(contestTimeElementId);
            if (contestTime != null) {
                this.showMessage("START site " + contestTime.getSiteNumber());
                this.getController().startContest(contestTime.getSiteNumber());
            }
            ++i;
        }
    }

    private JButton getStopClockButton() {
        if (this.stopClockButton == null) {
            this.stopClockButton = new JButton();
            this.stopClockButton.setText("Stop");
            this.stopClockButton.setToolTipText("Stop the contest clock on the selected site");
            this.stopClockButton.setMnemonic(84);
            this.stopClockButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimesPane.this.stopClockTimes();
                }
            });
        }
        return this.stopClockButton;
    }

    protected void stopClockTimes() {
        int[] selectedSites = this.contestTimeListBox.getSelectedIndexes();
        if (selectedSites.length == 0) {
            this.showMessage("Please select site");
            return;
        }
        int i = 0;
        while (i < selectedSites.length) {
            ElementId contestTimeElementId = (ElementId)this.contestTimeListBox.getKeys()[selectedSites[i]];
            ContestTime contestTime = this.getContest().getContestTime(contestTimeElementId);
            if (contestTime != null) {
                this.showMessage("STOP site " + contestTime.getSiteNumber());
                this.getController().stopContest(contestTime.getSiteNumber());
            }
            ++i;
        }
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setFont(new Font("Dialog", 1, 14));
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(30, 30));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ContestTimesPane.this.messageLabel != null) {
                    JOptionPane.showMessageDialog(ContestTimesPane.this.getParentFrame(), string, "Warning", 2);
                }
            }
        });
    }

    private JButton getStartAllButton() {
        if (this.startAllButton == null) {
            this.startAllButton = new JButton();
            this.startAllButton.setText("Start ALL");
            this.startAllButton.setToolTipText("Start All sites' clocks");
            this.startAllButton.setMnemonic(65);
            this.startAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimesPane.this.startAllClocks();
                }
            });
        }
        return this.startAllButton;
    }

    protected void startAllClocks() {
        this.showMessage("START ALL sites");
        this.getController().startAllContestTimes();
    }

    private JButton getStopAllButton() {
        if (this.stopAllButton == null) {
            this.stopAllButton = new JButton();
            this.stopAllButton.setText("Stop ALL");
            this.stopAllButton.setToolTipText("Stop all sites' clocks");
            this.stopAllButton.setMnemonic(80);
            this.stopAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimesPane.this.stopAllContestTimes();
                }
            });
        }
        return this.stopAllButton;
    }

    protected void stopAllContestTimes() {
        int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Are you sure you want to stop all contest clocks?", "Confirm stop all clocks");
        if (result == 0) {
            this.showMessage("STOP ALL sites");
            this.getController().stopAllContestTimes();
        }
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setToolTipText("Edit the contest time on the selected site");
            this.editButton.setMnemonic(69);
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimesPane.this.editSelectedContestTime();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedContestTime() {
        int[] selectedSites = this.contestTimeListBox.getSelectedIndexes();
        if (selectedSites.length == 0) {
            this.showMessage("Please select site");
            return;
        }
        ElementId contestTimeElementId = (ElementId)this.contestTimeListBox.getKeys()[selectedSites[0]];
        ContestTime contestTime = this.getContest().getContestTime(contestTimeElementId);
        this.editContestTimeFrame.setContestTime(contestTime);
        this.editContestTimeFrame.setVisible(true);
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (ContestTimesPane.this.getContest().getClientId().equals(account.getClientId())) {
                ContestTimesPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ContestTimesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            boolean theyModifiedUs = false;
            Account[] accountArray = accountEvent.getAccounts();
            int n = accountArray.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (ContestTimesPane.this.getContest().getClientId().equals(account.getClientId())) {
                    theyModifiedUs = true;
                    ContestTimesPane.this.initializePermissions();
                }
                ++n2;
            }
            if (theyModifiedUs) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ContestTimesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }
    }

    protected class AccountNameComparatorMCLB
    implements Comparator {
        private static final long serialVersionUID = 6940019340965217198L;
        private AccountNameComparator accountNameComparator = new AccountNameComparator();

        protected AccountNameComparatorMCLB() {
        }

        public int compare(Object arg0, Object arg1) {
            return this.accountNameComparator.compare((String)arg0, (String)arg1);
        }
    }

    public class ContestTimeListenerImplementation
    implements IContestTimeListener {
        public void contestTimeAdded(ContestTimeEvent event) {
            ContestTimesPane.this.updateContestTimeRow(event.getContestTime());
        }

        public void contestTimeRemoved(ContestTimeEvent event) {
        }

        public void contestTimeChanged(ContestTimeEvent event) {
            ContestTimesPane.this.updateContestTimeRow(event.getContestTime());
        }

        public void contestStarted(ContestTimeEvent event) {
            ContestTimesPane.this.updateContestTimeRow(event.getContestTime());
        }

        public void contestStopped(ContestTimeEvent event) {
            ContestTimesPane.this.updateContestTimeRow(event.getContestTime());
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
            if (ContestTimesPane.this.isServer(event.getClientId())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ContestTimesPane.this.reloadListBox();
                    }
                });
            }
        }

        public void loginRemoved(LoginEvent event) {
            if (ContestTimesPane.this.isServer(event.getClientId())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ContestTimesPane.this.reloadListBox();
                    }
                });
            }
        }

        public void loginDenied(LoginEvent event) {
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        protected void updateSiteInfo(int siteNumber) {
            ContestTime contestTime = ContestTimesPane.this.getContest().getContestTime(siteNumber);
            if (contestTime != null) {
                ContestTimesPane.this.updateContestTimeRow(contestTime);
            }
        }

        public void siteAdded(SiteEvent event) {
            int siteNumber = event.getSite().getSiteNumber();
            this.updateSiteInfo(siteNumber);
        }

        public void siteRemoved(SiteEvent event) {
        }

        public void siteChanged(SiteEvent event) {
            int siteNumber = event.getSite().getSiteNumber();
            this.updateSiteInfo(siteNumber);
        }

        public void siteLoggedOn(SiteEvent event) {
            int siteNumber = event.getSite().getSiteNumber();
            this.updateSiteInfo(siteNumber);
        }

        public void siteLoggedOff(SiteEvent event) {
            int siteNumber = event.getSite().getSiteNumber();
            this.updateSiteInfo(siteNumber);
        }
    }
}

