/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ContestInformationPane
extends JPanePlugin {
    private static final long serialVersionUID = -8408469113380938482L;
    private JPanel buttonPanel = null;
    private JPanel centerPane = null;
    private JButton updateButton = null;
    private JLabel contestTitleLabel = null;
    private JTextField contestTitleTextField = null;
    private JPanel teamDisplaySettingPane = null;
    private JRadioButton displayNoneRadioButton = null;
    private JRadioButton displayNumbersOnlyRadioButton = null;
    private JRadioButton displayNameAndNumberRadioButton = null;
    private JRadioButton displayAliasNameRadioButton = null;
    private JRadioButton displayNamesOnlyRadioButton = null;
    private ButtonGroup displayNameButtonGroup = null;
    private JButton cancelButton = null;
    private JTextField judgesDefaultAnswerTextField = null;
    private JLabel judgesDefaultAnswerLabel = null;
    private JCheckBox jCheckBoxShowPreliminaryOnBoard = null;
    private JCheckBox jCheckBoxShowPreliminaryOnNotifications = null;
    private JCheckBox additionalRunStatusCheckBox = null;
    private ContestInformation savedContestInformation = null;

    public ContestInformationPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(533, 347));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getUpdateButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.contestTitleLabel = new JLabel();
            this.contestTitleLabel.setBounds(new Rectangle(55, 21, 134, 27));
            this.contestTitleLabel.setHorizontalAlignment(4);
            this.contestTitleLabel.setText("Contest Title");
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.add((Component)this.contestTitleLabel, null);
            this.centerPane.add((Component)this.getContestTitleTextField(), null);
            this.centerPane.add((Component)this.getTeamDisplaySettingPane(), null);
            this.centerPane.add((Component)this.getJudgesDefaultAnswerLabel(), null);
            this.centerPane.add((Component)this.getJudgesDefaultAnswerTextField(), null);
            this.centerPane.add((Component)this.getJCheckBoxShowPreliminaryOnBoard(), null);
            this.centerPane.add((Component)this.getJCheckBoxShowPreliminaryOnNotifications(), null);
            this.centerPane.add((Component)this.getAdditionalRunStatusCheckBox(), null);
        }
        return this.centerPane;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setToolTipText("Save settings");
            this.updateButton.setPreferredSize(new Dimension(100, 26));
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.updateContestInformation();
                }
            });
        }
        return this.updateButton;
    }

    private JTextField getContestTitleTextField() {
        if (this.contestTitleTextField == null) {
            this.contestTitleTextField = new JTextField();
            this.contestTitleTextField.setBounds(new Rectangle(204, 21, 287, 27));
            this.contestTitleTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.contestTitleTextField;
    }

    public String getPluginTitle() {
        return "Contest Information Pane";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.savedContestInformation = this.getContest().getContestInformation();
        this.populateGUI();
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
    }

    protected ContestInformation getFromFields() {
        ContestInformation contestInformation = new ContestInformation();
        ContestInformation currentContestInformation = this.getContest().getContestInformation();
        if (currentContestInformation.getContestURL() != null) {
            contestInformation.setContestURL(new String(currentContestInformation.getContestURL()));
        }
        contestInformation.setContestTitle(this.getContestTitleTextField().getText());
        if (this.getDisplayNoneRadioButton().isSelected()) {
            contestInformation.setTeamDisplayMode(ContestInformation.TeamDisplayMask.NONE);
        } else if (this.getDisplayNameAndNumberRadioButton().isSelected()) {
            contestInformation.setTeamDisplayMode(ContestInformation.TeamDisplayMask.NUMBERS_AND_NAME);
        } else if (this.getDisplayNumbersOnlyRadioButton().isSelected()) {
            contestInformation.setTeamDisplayMode(ContestInformation.TeamDisplayMask.LOGIN_NAME_ONLY);
        } else if (this.getDisplayNamesOnlyRadioButton().isSelected()) {
            contestInformation.setTeamDisplayMode(ContestInformation.TeamDisplayMask.DISPLAY_NAME_ONLY);
        } else if (this.getDisplayAliasNameRadioButton().isSelected()) {
            contestInformation.setTeamDisplayMode(ContestInformation.TeamDisplayMask.ALIAS);
        } else {
            contestInformation.setTeamDisplayMode(ContestInformation.TeamDisplayMask.LOGIN_NAME_ONLY);
        }
        contestInformation.setJudgesDefaultAnswer(this.getJudgesDefaultAnswerTextField().getText());
        contestInformation.setPreliminaryJudgementsTriggerNotifications(this.getJCheckBoxShowPreliminaryOnNotifications().isSelected());
        contestInformation.setPreliminaryJudgementsUsedByBoard(this.getJCheckBoxShowPreliminaryOnBoard().isSelected());
        contestInformation.setSendAdditionalRunStatusInformation(this.getAdditionalRunStatusCheckBox().isSelected());
        if (this.savedContestInformation != null) {
            contestInformation.setJudgementNotificationsList(this.savedContestInformation.getJudgementNotificationsList());
        }
        return contestInformation;
    }

    protected void enableUpdateButton() {
        ContestInformation newChoice = this.getFromFields();
        if (this.getContest().getContestInformation().isSameAs(newChoice)) {
            this.setEnableButtons(false);
        } else {
            this.setEnableButtons(true);
        }
    }

    void setEnableButtons(boolean isEnabled) {
        this.getUpdateButton().setEnabled(isEnabled);
        this.getCancelButton().setEnabled(isEnabled);
    }

    private void populateGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ContestInformation contestInformation = ContestInformationPane.this.getContest().getContestInformation();
                ContestInformationPane.this.getContestTitleTextField().setText(contestInformation.getContestTitle());
                ContestInformationPane.this.selectDisplayRadioButton();
                ContestInformationPane.this.getJudgesDefaultAnswerTextField().setText(contestInformation.getJudgesDefaultAnswer());
                ContestInformationPane.this.getJCheckBoxShowPreliminaryOnBoard().setSelected(contestInformation.isPreliminaryJudgementsUsedByBoard());
                ContestInformationPane.this.getJCheckBoxShowPreliminaryOnNotifications().setSelected(contestInformation.isPreliminaryJudgementsTriggerNotifications());
                ContestInformationPane.this.getAdditionalRunStatusCheckBox().setSelected(contestInformation.isSendAdditionalRunStatusInformation());
                ContestInformationPane.this.setEnableButtons(false);
            }
        });
    }

    private void updateContestInformation() {
        ContestInformation contestInformation = this.getFromFields();
        this.getController().updateContestInformation(contestInformation);
    }

    private JPanel getTeamDisplaySettingPane() {
        if (this.teamDisplaySettingPane == null) {
            this.teamDisplaySettingPane = new JPanel();
            this.teamDisplaySettingPane.setLayout(new FlowLayout());
            this.teamDisplaySettingPane.setBounds(new Rectangle(111, 59, 381, 101));
            this.teamDisplaySettingPane.setBorder(BorderFactory.createTitledBorder(null, "Team Information Displayed to Judges", 0, 0, null, null));
            this.teamDisplaySettingPane.add((Component)this.getDisplayNoneRadioButton(), null);
            this.teamDisplaySettingPane.add((Component)this.getDisplayNumbersOnlyRadioButton(), null);
            this.teamDisplaySettingPane.add((Component)this.getDisplayNamesOnlyRadioButton(), null);
            this.teamDisplaySettingPane.add((Component)this.getDisplayNameAndNumberRadioButton(), null);
            this.teamDisplaySettingPane.add((Component)this.getDisplayAliasNameRadioButton(), null);
        }
        return this.teamDisplaySettingPane;
    }

    private void selectDisplayRadioButton() {
        ContestInformation contestInformation = this.getContest().getContestInformation();
        if (contestInformation == null || contestInformation.getTeamDisplayMode() == null) {
            this.getDisplayNameButtonGroup().setSelected(this.getDisplayNamesOnlyRadioButton().getModel(), true);
        } else {
            switch (contestInformation.getTeamDisplayMode()) {
                case DISPLAY_NAME_ONLY: {
                    this.getDisplayNameButtonGroup().setSelected(this.getDisplayNamesOnlyRadioButton().getModel(), true);
                    break;
                }
                case LOGIN_NAME_ONLY: {
                    this.getDisplayNameButtonGroup().setSelected(this.getDisplayNumbersOnlyRadioButton().getModel(), true);
                    break;
                }
                case NUMBERS_AND_NAME: {
                    this.getDisplayNameButtonGroup().setSelected(this.getDisplayNameAndNumberRadioButton().getModel(), true);
                    break;
                }
                case ALIAS: {
                    this.getDisplayNameButtonGroup().setSelected(this.getDisplayAliasNameRadioButton().getModel(), true);
                    break;
                }
                case NONE: {
                    this.getDisplayNameButtonGroup().setSelected(this.getDisplayNoneRadioButton().getModel(), true);
                    break;
                }
            }
        }
    }

    private JRadioButton getDisplayNoneRadioButton() {
        if (this.displayNoneRadioButton == null) {
            this.displayNoneRadioButton = new JRadioButton();
            this.displayNoneRadioButton.setText("None");
            this.displayNoneRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNoneRadioButton;
    }

    private JRadioButton getDisplayNumbersOnlyRadioButton() {
        if (this.displayNumbersOnlyRadioButton == null) {
            this.displayNumbersOnlyRadioButton = new JRadioButton();
            this.displayNumbersOnlyRadioButton.setText("Show Numbers Only");
            this.displayNumbersOnlyRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNumbersOnlyRadioButton;
    }

    private JRadioButton getDisplayNameAndNumberRadioButton() {
        if (this.displayNameAndNumberRadioButton == null) {
            this.displayNameAndNumberRadioButton = new JRadioButton();
            this.displayNameAndNumberRadioButton.setText("Show Number and Name");
            this.displayNameAndNumberRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNameAndNumberRadioButton;
    }

    private JRadioButton getDisplayAliasNameRadioButton() {
        if (this.displayAliasNameRadioButton == null) {
            this.displayAliasNameRadioButton = new JRadioButton();
            this.displayAliasNameRadioButton.setText("Show Alias");
            this.displayAliasNameRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayAliasNameRadioButton;
    }

    private JRadioButton getDisplayNamesOnlyRadioButton() {
        if (this.displayNamesOnlyRadioButton == null) {
            this.displayNamesOnlyRadioButton = new JRadioButton();
            this.displayNamesOnlyRadioButton.setText("Show Names only");
            this.displayNamesOnlyRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNamesOnlyRadioButton;
    }

    private ButtonGroup getDisplayNameButtonGroup() {
        if (this.displayNameButtonGroup == null) {
            this.displayNameButtonGroup = new ButtonGroup();
            this.displayNameButtonGroup.add(this.getDisplayNoneRadioButton());
            this.displayNameButtonGroup.add(this.getDisplayNamesOnlyRadioButton());
            this.displayNameButtonGroup.add(this.getDisplayNameAndNumberRadioButton());
            this.displayNameButtonGroup.add(this.getDisplayNumbersOnlyRadioButton());
            this.displayNameButtonGroup.add(this.getDisplayAliasNameRadioButton());
        }
        return this.displayNameButtonGroup;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setToolTipText("Discard changes");
            this.cancelButton.setPreferredSize(new Dimension(100, 26));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.populateGUI();
                }
            });
        }
        return this.cancelButton;
    }

    private JTextField getJudgesDefaultAnswerTextField() {
        if (this.judgesDefaultAnswerTextField == null) {
            this.judgesDefaultAnswerTextField = new JTextField();
            this.judgesDefaultAnswerTextField.setText("");
            this.judgesDefaultAnswerTextField.setSize(new Dimension(280, 27));
            this.judgesDefaultAnswerTextField.setLocation(new Point(209, 169));
            this.judgesDefaultAnswerTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.judgesDefaultAnswerTextField;
    }

    private JLabel getJudgesDefaultAnswerLabel() {
        if (this.judgesDefaultAnswerLabel == null) {
            this.judgesDefaultAnswerLabel = new JLabel();
            this.judgesDefaultAnswerLabel.setText("Judges' Default Answer");
            this.judgesDefaultAnswerLabel.setHorizontalTextPosition(11);
            this.judgesDefaultAnswerLabel.setLocation(new Point(25, 165));
            this.judgesDefaultAnswerLabel.setSize(new Dimension(175, 27));
            this.judgesDefaultAnswerLabel.setHorizontalAlignment(4);
        }
        return this.judgesDefaultAnswerLabel;
    }

    private JCheckBox getJCheckBoxShowPreliminaryOnBoard() {
        if (this.jCheckBoxShowPreliminaryOnBoard == null) {
            this.jCheckBoxShowPreliminaryOnBoard = new JCheckBox();
            this.jCheckBoxShowPreliminaryOnBoard.setBounds(new Rectangle(60, 208, 427, 21));
            this.jCheckBoxShowPreliminaryOnBoard.setHorizontalAlignment(2);
            this.jCheckBoxShowPreliminaryOnBoard.setMnemonic(0);
            this.jCheckBoxShowPreliminaryOnBoard.setText("Include Preliminary Judgements in Scoring Algorithm");
            this.jCheckBoxShowPreliminaryOnBoard.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.jCheckBoxShowPreliminaryOnBoard;
    }

    private JCheckBox getJCheckBoxShowPreliminaryOnNotifications() {
        if (this.jCheckBoxShowPreliminaryOnNotifications == null) {
            this.jCheckBoxShowPreliminaryOnNotifications = new JCheckBox();
            this.jCheckBoxShowPreliminaryOnNotifications.setBounds(new Rectangle(60, 238, 427, 21));
            this.jCheckBoxShowPreliminaryOnNotifications.setHorizontalAlignment(2);
            this.jCheckBoxShowPreliminaryOnNotifications.setMnemonic(0);
            this.jCheckBoxShowPreliminaryOnNotifications.setText("Send Balloon Notifications for Preliminary Judgements");
            this.jCheckBoxShowPreliminaryOnNotifications.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.jCheckBoxShowPreliminaryOnNotifications;
    }

    private JCheckBox getAdditionalRunStatusCheckBox() {
        if (this.additionalRunStatusCheckBox == null) {
            this.additionalRunStatusCheckBox = new JCheckBox();
            this.additionalRunStatusCheckBox.setHorizontalAlignment(2);
            this.additionalRunStatusCheckBox.setSize(new Dimension(427, 21));
            this.additionalRunStatusCheckBox.setLocation(new Point(60, 268));
            this.additionalRunStatusCheckBox.setText("Send Additional Run Status Information");
            this.additionalRunStatusCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestInformationPane.this.enableUpdateButton();
                }
            });
        }
        return this.additionalRunStatusCheckBox;
    }

    public ContestInformation getContestInformation() {
        return this.savedContestInformation;
    }

    public void setContestInformation(ContestInformation contestInformation) {
        this.savedContestInformation = contestInformation;
    }

    class ContestInformationListenerImplementation
    implements IContestInformationListener {
        ContestInformationListenerImplementation() {
        }

        public void contestInformationAdded(ContestInformationEvent event) {
            ContestInformationPane.this.populateGUI();
            ContestInformationPane.this.savedContestInformation = event.getContestInformation();
        }

        public void contestInformationChanged(ContestInformationEvent event) {
            ContestInformationPane.this.populateGUI();
            ContestInformationPane.this.savedContestInformation = event.getContestInformation();
        }

        public void contestInformationRemoved(ContestInformationEvent event) {
        }
    }
}

