/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.RunComparatorByTeam;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Balloon;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.BalloonHandler;
import edu.csus.ecs.pc2.core.util.BalloonWriter;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BalloonPane
extends JPanePlugin {
    private static final long serialVersionUID = 3041019296688422631L;
    private static final int EMAIL_COLUMN = 2;
    private static final int FILE_PRINT_COLUMN = 1;
    private BalloonHandler balloonHandler = new BalloonHandler();
    private Log log;
    private BalloonWriter balloonWriter;
    private JLabel messageLabel;
    private JPanel messagePane;
    private JPanel buttonPane;
    private JButton testButton = null;
    private MCLB testMCLB = null;
    private JCheckBox testEmailAllCheckBox = null;
    private JCheckBox testPrintAllCheckBox = null;
    private boolean oldEmailAll;
    private boolean oldPrintAll;

    public BalloonPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(539, 511));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)((Object)this.getTestMCLB()), "Center");
    }

    private void addTestRow(int siteID) {
        try {
            JCheckBox emailCheckBox = new JCheckBox("email");
            JCheckBox printCheckBox = new JCheckBox("print");
            emailCheckBox.setBackground(this.getTestMCLB().getBackground());
            printCheckBox.setBackground(this.getTestMCLB().getBackground());
            Object[] row = new Object[this.getTestMCLB().getColumnCount()];
            if (siteID == 0) {
                row[0] = "";
                this.getTestEmailAllCheckBox().setBackground(this.getTestMCLB().getBackground());
                this.getTestPrintAllCheckBox().setBackground(this.getTestMCLB().getBackground());
                row[1] = this.getTestPrintAllCheckBox();
                row[2] = this.getTestEmailAllCheckBox();
            } else {
                if (this.getContest().getSite(siteID) == null) {
                    this.log.info("addTestRow called for Invalid site (" + siteID + ")");
                    return;
                }
                BalloonSettings settings = this.getContest().getBalloonSettings(siteID);
                if (settings == null) {
                    this.log.fine("addTestRow no balloonSettings for site " + siteID);
                    return;
                }
                if (settings.isMatchesBalloonClient(this.getContest().getClientId())) {
                    row[0] = this.getContest().getSite(siteID).getDisplayName();
                    if (settings.isEmailBalloons() && settings.getEmailContact().trim().length() > 0) {
                        emailCheckBox.setText(settings.getEmailContact());
                        emailCheckBox.setSelected(this.getTestEmailAllCheckBox().isSelected());
                        emailCheckBox.setPreferredSize(new Dimension(300, 0));
                    } else {
                        emailCheckBox.setText("N/A");
                        emailCheckBox.setEnabled(false);
                    }
                    if (settings.isPrintBalloons() && settings.getPrintDevice().trim().length() > 0) {
                        printCheckBox.setText(settings.getPrintDevice());
                        printCheckBox.setSelected(this.getTestPrintAllCheckBox().isSelected());
                        printCheckBox.setPreferredSize(new Dimension(200, 0));
                    } else {
                        printCheckBox.setText("N/A");
                        printCheckBox.setEnabled(false);
                    }
                    row[1] = printCheckBox;
                    row[2] = emailCheckBox;
                } else {
                    this.log.fine("addTestRow not the balloon client for site " + siteID);
                    return;
                }
            }
            this.getTestMCLB().addRow(row);
        }
        catch (Exception e) {
            this.log.info("Problem adding test balloon row for site " + siteID);
            this.log.throwing(this.getClass().getName(), "addTestRow(" + siteID + ")", e);
        }
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getTestButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    public String getPluginTitle() {
        return "Balloon Handler";
    }

    private JButton getTestButton() {
        if (this.testButton == null) {
            this.testButton = new JButton();
            this.testButton.setText("Test");
            this.testButton.setToolTipText("Run the selected tests");
            this.testButton.setPreferredSize(new Dimension(150, 26));
            this.testButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonPane.this.runSelectedTests();
                }
            });
        }
        return this.testButton;
    }

    protected void runSelectedTests() {
        try {
            int siteTested = 0;
            int i = 1;
            while (i < this.getTestMCLB().getRowCount()) {
                Object[] row = this.getTestMCLB().getRow(i);
                int site = i;
                boolean testEmail = ((JCheckBox)row[2]).isSelected();
                boolean testPrint = ((JCheckBox)row[1]).isSelected();
                if (testEmail || testPrint) {
                    BalloonSettings settings = (BalloonSettings)this.getContest().getBalloonSettings(site).clone();
                    settings.setEmailBalloons(testEmail);
                    settings.setPrintBalloons(testPrint);
                    Balloon balloon = new Balloon(settings, null, "Test", null, "all problems", "test", null);
                    balloon.setProblems(this.getContest().getProblems());
                    final Balloon testBalloon = balloon;
                    Thread testASite = new Thread(){

                        public void run() {
                            BalloonPane.this.balloonWriter.sendBalloon(testBalloon);
                        }
                    };
                    testASite.start();
                    ++siteTested;
                }
                ++i;
            }
            if (siteTested == 0) {
                this.messageLabel.setText("No tests selected.");
            } else {
                this.messageLabel.setText("Last test sent at " + new Date());
            }
        }
        catch (Exception e) {
            this.log.info("Problem testing sites");
            this.log.throwing(this.getClass().getName(), "runSelectedTests", e);
        }
    }

    private JCheckBox getTestEmailAllCheckBox() {
        if (this.testEmailAllCheckBox == null) {
            this.testEmailAllCheckBox = new JCheckBox();
            this.testEmailAllCheckBox.setText("Select All");
            this.testEmailAllCheckBox.setSize(new Dimension(300, 15));
            this.testEmailAllCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    boolean changed = false;
                    if (BalloonPane.this.getTestEmailAllCheckBox().isSelected() && !BalloonPane.this.oldEmailAll) {
                        changed = true;
                        BalloonPane.this.oldEmailAll = true;
                    } else if (!BalloonPane.this.getTestEmailAllCheckBox().isSelected() && BalloonPane.this.oldEmailAll) {
                        changed = true;
                        BalloonPane.this.oldEmailAll = false;
                    }
                    if (changed) {
                        int i = 1;
                        while (i < BalloonPane.this.getTestMCLB().getRowCount()) {
                            JCheckBox box;
                            Object[] o = BalloonPane.this.getTestMCLB().getRow(i);
                            if (o != null && o[2] instanceof JCheckBox && !(box = (JCheckBox)o[2]).getText().equalsIgnoreCase("N/A")) {
                                box.setSelected(BalloonPane.this.getTestEmailAllCheckBox().isSelected());
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        return this.testEmailAllCheckBox;
    }

    private JCheckBox getTestPrintAllCheckBox() {
        if (this.testPrintAllCheckBox == null) {
            this.testPrintAllCheckBox = new JCheckBox();
            this.testPrintAllCheckBox.setText("Select All");
            this.testPrintAllCheckBox.setSize(new Dimension(300, 15));
            this.testPrintAllCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    boolean changed = false;
                    if (BalloonPane.this.getTestPrintAllCheckBox().isSelected() && !BalloonPane.this.oldPrintAll) {
                        changed = true;
                        BalloonPane.this.oldPrintAll = true;
                    } else if (!BalloonPane.this.getTestPrintAllCheckBox().isSelected() && BalloonPane.this.oldPrintAll) {
                        changed = true;
                        BalloonPane.this.oldPrintAll = false;
                    }
                    if (changed) {
                        int i = 1;
                        while (i < BalloonPane.this.getTestMCLB().getRowCount()) {
                            JCheckBox box;
                            Object[] o = BalloonPane.this.getTestMCLB().getRow(i);
                            if (o != null && o[1] instanceof JCheckBox && !(box = (JCheckBox)o[1]).getText().equalsIgnoreCase("N/A")) {
                                box.setSelected(BalloonPane.this.getTestPrintAllCheckBox().isSelected());
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        return this.testPrintAllCheckBox;
    }

    private MCLB getTestMCLB() {
        if (this.testMCLB == null) {
            this.testMCLB = new MCLB();
            Object[] cols = new Object[]{"Site", "", ""};
            cols[2] = "Test Email";
            cols[1] = "Test Print";
            this.testMCLB.addColumns(cols);
        }
        return this.testMCLB;
    }

    void loadBalloonSettings() {
        this.balloonHandler.reloadBalloonSettings();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BalloonPane.this.reloadListBox();
            }
        });
    }

    void reloadListBox() {
        this.getTestMCLB().removeAllRows();
        this.addTestRow(0);
        Site[] siteArray = this.getContest().getSites();
        int n = siteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            this.addTestRow(site.getSiteNumber());
            ++n2;
        }
        this.getTestMCLB().autoSizeAllColumns();
    }

    void saveClientSettings() {
        ClientSettings clientSettings = this.getContest().getClientSettings();
        clientSettings.setBalloonList(this.balloonHandler.getBalloonDeliveryList());
        this.getController().updateClientSettings(clientSettings);
    }

    void recomputeBalloonStatus(ClientId who, ElementId problemId) {
        if (!this.balloonHandler.isRunSolved(who, problemId) && this.takeBalloon(this.balloonHandler.buildBalloon("take", who, problemId, null))) {
            this.tookBalloonFrom(this.balloonHandler.getBalloonKey(who, problemId));
        }
    }

    private void recomputeBalloons(int siteNumber) {
        BalloonSettings balloonSettings = this.balloonHandler.getBalloonSettingsHash().get(siteNumber);
        if (balloonSettings == null) {
            return;
        }
        if (!balloonSettings.isBalloonsEnabled()) {
            return;
        }
        RunComparatorByTeam runComparatorByTeam = new RunComparatorByTeam();
        TreeMap<Run, Run> runTreeMap = new TreeMap<Run, Run>(runComparatorByTeam);
        Run[] runs = this.getContest().getRuns();
        int i = 0;
        while (i < runs.length) {
            Run run = runs[i];
            if (run.getSiteNumber() == siteNumber) {
                runTreeMap.put(run, run);
            }
            ++i;
        }
        Collection runColl = runTreeMap.values();
        Iterator runIterator = runColl.iterator();
        Hashtable<String, Long> goodBalloons = new Hashtable<String, Long>();
        Hashtable<String, Long> okBalloons = new Hashtable<String, Long>();
        while (runIterator.hasNext()) {
            Object o = runIterator.next();
            Run run = (Run)o;
            if (run.isDeleted() || !run.isJudged() || !run.isSolved()) continue;
            String key = this.balloonHandler.getBalloonKey(run.getSubmitter(), run.getProblemId());
            if (this.balloonHandler.isValidJudgement(run)) {
                okBalloons.put(key, 0L);
                continue;
            }
            goodBalloons.put(key, 0L);
            if (this.balloonHandler.hasBalloonBeenSent(key)) continue;
            if (this.shouldSendToTeam(run)) {
                if (this.sendBalloon(this.balloonHandler.buildBalloon("yes", run.getSubmitter(), run.getProblemId(), run))) {
                    this.sentBalloonFor(key, run.getSubmitter(), run.getProblemId());
                    continue;
                }
                this.log.info("Problem sending balloon to " + run.getSubmitter().getTripletKey() + " for " + run.getProblemId());
                continue;
            }
            this.log.info("Run not sent to team, not sending balloon to " + run.getSubmitter().getTripletKey() + " for " + run.getProblemId());
        }
        Enumeration<String> balloonEnum = this.balloonHandler.getBalloonDeliveryInfoKeys();
        while (balloonEnum.hasMoreElements()) {
            ElementId problemId;
            BalloonDeliveryInfo balloonDeliveryInfo;
            ClientId clientId;
            String key = balloonEnum.nextElement();
            if (goodBalloons.containsKey(key) || okBalloons.containsKey(key) || (clientId = (balloonDeliveryInfo = this.balloonHandler.getBalloonDeliveryInfo(key)).getClientId()).getSiteNumber() != siteNumber || !this.takeBalloon(this.balloonHandler.buildBalloon("take", clientId, problemId = balloonDeliveryInfo.getProblemId(), null))) continue;
            this.tookBalloonFrom(key);
        }
    }

    boolean shouldSendToTeam(Run run) {
        return run.isSendToTeams() || !this.getContest().isAllowed(Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
    }

    boolean sendBalloon(Balloon balloon) {
        this.log.finest("send a balloon to " + balloon.getClientId().getTripletKey() + " for " + balloon.getProblemTitle());
        return this.balloonWriter.sendBalloon(balloon);
    }

    private void sentBalloonFor(String key, ClientId clientId, ElementId problemId) {
        this.balloonHandler.updateDeliveryInfo(key, new BalloonDeliveryInfo(clientId, problemId, Calendar.getInstance().getTime().getTime()));
        this.saveClientSettings();
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.balloonHandler.setContestAndController(inContest, inController);
        this.loadBalloonSettings();
        this.balloonWriter = new BalloonWriter(this.log);
        this.balloonHandler.setBalloonDeliveryList(this.getContest().getClientSettings().getBalloonList());
        Site[] sites = inContest.getSites();
        int i = 0;
        while (i < sites.length) {
            this.recomputeBalloons(sites[i].getSiteNumber());
            ++i;
        }
        this.getContest().addRunListener(new RunListenerImplementation());
        this.getContest().addBalloonSettingsListener(new BalloonSettingsListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BalloonPane.this.reloadListBox();
            }
        });
    }

    boolean takeBalloon(Balloon balloon) {
        this.log.finest("take a balloon away from " + balloon.getClientId().getTripletKey() + " for " + balloon.getProblemTitle());
        return this.balloonWriter.sendBalloon(balloon);
    }

    private void tookBalloonFrom(String balloonKey) {
        this.balloonHandler.removeBalloonDelivery(balloonKey);
        this.saveClientSettings();
    }

    public class BalloonSettingsListenerImplementation
    implements IBalloonSettingsListener {
        public void balloonSettingsAdded(BalloonSettingsEvent event) {
            BalloonPane.this.loadBalloonSettings();
            BalloonSettings balloonSettings = event.getBalloonSettings();
            if (balloonSettings != null && balloonSettings.isBalloonsEnabled() && balloonSettings.isMatchesBalloonClient(BalloonPane.this.getContest().getClientId())) {
                BalloonPane.this.recomputeBalloons(balloonSettings.getSiteNumber());
            }
        }

        public void balloonSettingsChanged(BalloonSettingsEvent event) {
            BalloonPane.this.loadBalloonSettings();
            BalloonSettings balloonSettings = event.getBalloonSettings();
            if (balloonSettings != null && balloonSettings.isBalloonsEnabled() && balloonSettings.isMatchesBalloonClient(BalloonPane.this.getContest().getClientId())) {
                BalloonPane.this.recomputeBalloons(balloonSettings.getSiteNumber());
            }
        }

        public void balloonSettingsRemoved(BalloonSettingsEvent event) {
            BalloonPane.this.loadBalloonSettings();
        }
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
        }

        public void runChanged(RunEvent event) {
            if (event.getAction().equals((Object)RunEvent.Action.CHANGED)) {
                Run run = event.getRun();
                ClientId who = run.getSubmitter();
                BalloonSettings balloonSettings = BalloonPane.this.getContest().getBalloonSettings(who.getSiteNumber());
                if (balloonSettings == null) {
                    return;
                }
                if (!balloonSettings.isBalloonsEnabled()) {
                    return;
                }
                ElementId what = run.getProblemId();
                String key = BalloonPane.this.balloonHandler.getBalloonKey(who, what);
                if (BalloonPane.this.balloonHandler.hasBalloonBeenSent(key)) {
                    BalloonPane.this.recomputeBalloonStatus(who, what);
                } else if (BalloonPane.this.balloonHandler.shouldSendBalloon(run) && BalloonPane.this.sendBalloon(BalloonPane.this.balloonHandler.buildBalloon("yes", who, what, run))) {
                    BalloonPane.this.sentBalloonFor(key, who, what);
                }
            }
        }

        public void runRemoved(RunEvent event) {
            Run run = event.getRun();
            ClientId who = run.getSubmitter();
            ElementId what = run.getProblemId();
            String key = BalloonPane.this.balloonHandler.getBalloonKey(who, what);
            if (BalloonPane.this.balloonHandler.hasBalloonBeenSent(key)) {
                BalloonPane.this.recomputeBalloonStatus(who, what);
            }
        }
    }
}

