/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.AnswerClarificationPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class AnswerClarificationFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -3349295529036840178L;
    private IInternalContest contest;
    private IInternalController controller;
    private Clarification clarification = null;
    private AnswerClarificationPane answerClarificationPane = null;

    public AnswerClarificationFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(549, 312));
        this.setContentPane(this.getAnswerClarificationPane());
        this.setDefaultCloseOperation(0);
        this.setTitle("Select Clarification Judgement");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AnswerClarificationFrame.this.getAnswerClarificationPane().handleCancelButton();
            }
        });
        FrameUtilities.centerFrame(this);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getAnswerClarificationPane().setContestAndController(this.contest, this.controller);
        this.getAnswerClarificationPane().setParentFrame(this);
        this.getAnswerClarificationPane().setDefaultAnswerText(this.contest.getContestInformation().getJudgesDefaultAnswer());
        this.contest.addContestInformationListener(new ContestInformationListenerImplementation());
        this.contest.addClarificationListener(new ClarificationListenerImplementation());
    }

    public void setClarification(Clarification theClarification) {
        if (theClarification == null) {
            this.setTitle("Clarification not loaded");
        } else {
            this.getAnswerClarificationPane().setClarification(theClarification, false);
            this.setTitle("Select Answer for clarification " + theClarification.getNumber() + " (Site " + theClarification.getSiteNumber() + ")");
            this.clarification = theClarification;
            this.controller.checkOutClarification(this.clarification, false);
        }
    }

    public String getPluginTitle() {
        return "Edit Clarification Frame";
    }

    private AnswerClarificationPane getAnswerClarificationPane() {
        if (this.answerClarificationPane == null) {
            this.answerClarificationPane = new AnswerClarificationPane();
        }
        return this.answerClarificationPane;
    }

    public class ClarificationListenerImplementation
    implements IClarificationListener {
        public void clarificationAdded(ClarificationEvent event) {
        }

        public void clarificationChanged(ClarificationEvent event) {
            if (AnswerClarificationFrame.this.clarification != null && event.getClarification().getElementId().equals(AnswerClarificationFrame.this.clarification.getElementId())) {
                if (event.getAction().equals((Object)ClarificationEvent.Action.CLARIFICATION_NOT_AVAILABLE)) {
                    AnswerClarificationFrame.this.getAnswerClarificationPane().showMessage("Clarification " + AnswerClarificationFrame.this.clarification.getNumber() + " not available ");
                    AnswerClarificationFrame.this.getAnswerClarificationPane().enableUpdateButtons(false);
                    AnswerClarificationFrame.this.getAnswerClarificationPane().regularCursor();
                } else if (event.getSentToClientId() != null && event.getSentToClientId().equals(AnswerClarificationFrame.this.contest.getClientId())) {
                    AnswerClarificationFrame.this.getAnswerClarificationPane().setClarification(event.getClarification(), true);
                    AnswerClarificationFrame.this.clarification = null;
                }
            }
        }

        public void clarificationRemoved(ClarificationEvent event) {
        }
    }

    public class ContestInformationListenerImplementation
    implements IContestInformationListener {
        public void contestInformationAdded(ContestInformationEvent event) {
        }

        public void contestInformationChanged(ContestInformationEvent event) {
            if (event.getContestInformation() != null) {
                String answer = event.getContestInformation().getJudgesDefaultAnswer();
                AnswerClarificationFrame.this.getAnswerClarificationPane().setDefaultAnswerText(answer);
            }
        }

        public void contestInformationRemoved(ContestInformationEvent event) {
        }
    }
}

