/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JCheckBoxJList;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AccountPane
extends JPanePlugin {
    private static final long serialVersionUID = -1572390105202179281L;
    private static final String NONE_SELECTED = "NONE SELECTED";
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private Account account = null;
    private DefaultListModel defaultListModel = new DefaultListModel();
    private Log log = null;
    private JSplitPane mainSplitPane = null;
    private JPanel accountDetailPane = null;
    private JPanel permissionPane = null;
    private JLabel permissionMainTitle = null;
    private JScrollPane permissionScrollPane = null;
    private JCheckBoxJList permissionsJList = null;
    private JLabel permissionCountLabel = null;
    private JLabel displayNameLabel = null;
    private JTextField displayNameTextField = null;
    private JLabel passwordLabel = null;
    private JTextField passwordTextField = null;
    private JTextField passwordConfirmField = null;
    private JLabel jLabel = null;
    private JLabel groupTitleLabel = null;
    private JComboBox groupComboBox = null;
    private boolean populatingGUI = false;
    private Permission permission = new Permission();
    private JLabel jLabel1 = null;
    private JComboBox accountTypeComboBox = null;
    private JLabel accountLabel = null;
    private JTextField accountTextField = null;
    private JComboBox siteSelectionComboBox = null;
    private JLabel siteLabel = null;

    public AccountPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(536, 400));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AccountPane.this.getParentFrame() != null) {
                    AccountPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            AccountPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    public String getPluginTitle() {
        return "Edit Account Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(30, 30));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountPane.this.addAccount();
                }
            });
        }
        return this.addButton;
    }

    protected void addAccount() {
        Account newAccount;
        if (!this.validatedFields()) {
            return;
        }
        try {
            newAccount = this.getAccountFromFields(null);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.getController().addNewAccount(newAccount);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountPane.this.updateAccount();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateAccount() {
        Account newAccount;
        if (!this.validatedFields()) {
            return;
        }
        try {
            newAccount = this.getAccountFromFields(this.account);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.getController().updateAccount(newAccount);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private boolean validatedFields() {
        String newPassword;
        String oldPassword = this.getPasswordTextField().getText();
        if (!oldPassword.equals(newPassword = this.getPasswordConfirmField().getText())) {
            this.showMessage("Password and Confirm password do not match");
            return false;
        }
        if (this.getSiteSelectionComboBox().getSelectedIndex() == -1) {
            this.showMessage("Select a site");
            return false;
        }
        if (this.getDisplayNameTextField().getText().length() == 0) {
            this.showMessage("Enter a display name");
            return false;
        }
        return true;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Account modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addAccount();
                } else {
                    this.updateAccount();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(final Account account) {
        this.account = account;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccountPane.this.populateGUI(account);
                AccountPane.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateGUI(Account account2) {
        this.populatingGUI = true;
        this.account = account2;
        if (account2 == null) {
            this.getAccountTextField().setText("");
            this.getDisplayNameTextField().setText("");
            this.getPasswordTextField().setText("");
            this.getPasswordConfirmField().setText("");
            this.populateGroupComboBox(null);
            this.getAddButton().setVisible(true);
            this.getUpdateButton().setVisible(false);
            this.getAccountTypeComboBox().setSelectedIndex(0);
            this.getAccountTypeComboBox().setEnabled(true);
            this.loadSiteComboBox(this.getContest().getSiteNumber());
            this.getSiteSelectionComboBox().setEnabled(true);
        } else {
            this.getAccountTextField().setText(account2.getClientId().getName());
            this.getDisplayNameTextField().setText(account2.getDisplayName());
            this.getPasswordTextField().setText(account2.getPassword());
            this.getPasswordConfirmField().setText(account2.getPassword());
            this.populateGroupComboBox(account2.getGroupId());
            this.populatePermissions(account2);
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
            this.getAccountTypeComboBox().setEnabled(false);
            ClientType.Type accountType = account2.getClientId().getClientType();
            int i = 0;
            while (i < this.getAccountTypeComboBox().getItemCount()) {
                ClientType.Type type = (ClientType.Type)((Object)this.getAccountTypeComboBox().getItemAt(i));
                if (accountType.equals((Object)type)) {
                    this.getAccountTypeComboBox().setSelectedIndex(i);
                }
                ++i;
            }
            this.getAccountTypeComboBox().setEnabled(false);
            this.loadSiteComboBox(account2.getSiteNumber());
            this.getSiteSelectionComboBox().setEnabled(false);
        }
        this.populatePermissions(account2);
        this.populatingGUI = false;
        this.enableUpdateButton();
    }

    private void loadSiteComboBox(int siteNumber) {
        int selectedIndex = this.getSiteSelectionComboBox().getSelectedIndex();
        this.getSiteSelectionComboBox().removeAllItems();
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        int i = 0;
        while (i < sites.length) {
            if (sites[i].getSiteNumber() == this.getContest().getSiteNumber()) {
                Site newSite;
                sites[i] = newSite = new Site(String.valueOf(sites[i].getDisplayName()) + " (This Site)", this.getContest().getSiteNumber());
            }
            if (sites[i].getSiteNumber() == siteNumber) {
                selectedIndex = i;
            }
            this.getSiteSelectionComboBox().addItem(sites[i]);
            ++i;
        }
        if (selectedIndex != -1) {
            this.getSiteSelectionComboBox().setSelectedIndex(selectedIndex);
        }
    }

    private void populateGroupComboBox(ElementId elementId) {
        int groupIndex = 0;
        int selectedIndex = 0;
        Group[] groups = this.getContest().getGroups();
        this.getGroupComboBox().removeAllItems();
        this.getGroupComboBox().addItem(NONE_SELECTED);
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            ++groupIndex;
            this.getGroupComboBox().addItem(group);
            if (elementId != null && group.getElementId().equals(elementId)) {
                selectedIndex = groupIndex;
            }
            ++n2;
        }
        this.getGroupComboBox().setSelectedIndex(selectedIndex);
    }

    private String[] getPermissionDescriptions() {
        Object[] permissionListNames = new String[Permission.Type.values().length];
        int i = 0;
        Permission.Type[] typeArray = Permission.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Permission.Type type = typeArray[n2];
            permissionListNames[i] = this.permission.getDescription(type);
            ++i;
            ++n2;
        }
        Arrays.sort(permissionListNames);
        return permissionListNames;
    }

    private void populatePermissions(Account inAccount) {
        this.defaultListModel.removeAllElements();
        if (inAccount == null) {
            String[] stringArray = this.getPermissionDescriptions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                JCheckBox checkBox = new JCheckBox(name);
                this.defaultListModel.addElement(checkBox);
                ++n2;
            }
            this.getPermissionsJList().setSelectedIndex(-1);
        } else {
            Permission.Type type;
            int count = 0;
            Permission.Type[] typeArray = Permission.Type.values();
            int n = typeArray.length;
            int n3 = 0;
            while (n3 < n) {
                type = typeArray[n3];
                if (this.account.isAllowed(type)) {
                    ++count;
                }
                ++n3;
            }
            if (count > 0) {
                int[] indexes = new int[count];
                count = 0;
                int idx = 0;
                Permission.Type[] typeArray2 = Permission.Type.values();
                int n4 = typeArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    Permission.Type type2 = typeArray2[n5];
                    JCheckBox checkBox = new JCheckBox(this.permission.getDescription(type2));
                    this.defaultListModel.addElement(checkBox);
                    if (this.account.isAllowed(type2)) {
                        indexes[count] = idx;
                        ++count;
                    }
                    ++idx;
                    ++n5;
                }
                this.getPermissionsJList().setSelectedIndices(indexes);
                this.getPermissionsJList().ensureIndexIsVisible(0);
            } else {
                typeArray = Permission.Type.values();
                n = typeArray.length;
                n3 = 0;
                while (n3 < n) {
                    type = typeArray[n3];
                    JCheckBox checkBox = new JCheckBox(this.permission.getDescription(type));
                    this.defaultListModel.addElement(checkBox);
                    ++n3;
                }
            }
        }
        this.showPermissionCount(String.valueOf(this.getPermissionsJList().getSelectedIndices().length) + " permissions selected");
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        this.addButton.setEnabled(editedText);
        this.updateButton.setEnabled(editedText);
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccountPane.this.messageLabel.setText(message);
            }
        });
    }

    public void showPermissionCount(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccountPane.this.permissionCountLabel.setText(message);
            }
        });
    }

    private JSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new JSplitPane();
            this.mainSplitPane.setOneTouchExpandable(true);
            this.mainSplitPane.setDividerLocation(300);
            this.mainSplitPane.setLeftComponent(this.getPermissionPane());
            this.mainSplitPane.setRightComponent(this.getAccountPane());
        }
        return this.mainSplitPane;
    }

    private JPanel getPermissionPane() {
        if (this.accountDetailPane == null) {
            this.siteLabel = new JLabel();
            this.siteLabel.setBounds(new Rectangle(155, 221, 128, 16));
            this.siteLabel.setText("Site");
            this.accountLabel = new JLabel();
            this.accountLabel.setText("Account");
            this.accountLabel.setLocation(new Point(15, 15));
            this.accountLabel.setSize(new Dimension(86, 16));
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Account Type");
            this.jLabel1.setLocation(new Point(15, 220));
            this.jLabel1.setSize(new Dimension(134, 16));
            this.groupTitleLabel = new JLabel();
            this.groupTitleLabel.setText("Group");
            this.groupTitleLabel.setLocation(new Point(15, 270));
            this.groupTitleLabel.setSize(new Dimension(191, 16));
            this.jLabel = new JLabel();
            this.jLabel.setText("Password Confirmation ");
            this.jLabel.setSize(new Dimension(191, 16));
            this.jLabel.setLocation(new Point(15, 168));
            this.passwordLabel = new JLabel();
            this.passwordLabel.setText("Password");
            this.passwordLabel.setSize(new Dimension(191, 16));
            this.passwordLabel.setLocation(new Point(15, 116));
            this.displayNameLabel = new JLabel();
            this.displayNameLabel.setText("Display Name");
            this.displayNameLabel.setSize(new Dimension(191, 16));
            this.displayNameLabel.setLocation(new Point(15, 65));
            this.accountDetailPane = new JPanel();
            this.accountDetailPane.setLayout(null);
            this.accountDetailPane.setPreferredSize(new Dimension(120, 120));
            this.accountDetailPane.add((Component)this.displayNameLabel, null);
            this.accountDetailPane.add((Component)this.getDisplayNameTextField(), null);
            this.accountDetailPane.add((Component)this.passwordLabel, null);
            this.accountDetailPane.add((Component)this.getPasswordTextField(), null);
            this.accountDetailPane.add((Component)this.getPasswordConfirmField(), null);
            this.accountDetailPane.add((Component)this.jLabel, null);
            this.accountDetailPane.add((Component)this.groupTitleLabel, null);
            this.accountDetailPane.add((Component)this.getGroupComboBox(), null);
            this.accountDetailPane.add((Component)this.jLabel1, null);
            this.accountDetailPane.add((Component)this.getAccountTypeComboBox(), null);
            this.accountDetailPane.add((Component)this.accountLabel, null);
            this.accountDetailPane.add((Component)this.getAccountTextField(), null);
            this.accountDetailPane.add((Component)this.getSiteSelectionComboBox(), null);
            this.accountDetailPane.add((Component)this.siteLabel, null);
        }
        return this.accountDetailPane;
    }

    private JPanel getAccountPane() {
        if (this.permissionPane == null) {
            this.permissionCountLabel = new JLabel();
            this.permissionCountLabel.setText("XX Permissions Selected");
            this.permissionCountLabel.setPreferredSize(new Dimension(25, 25));
            this.permissionCountLabel.setHorizontalAlignment(0);
            this.permissionMainTitle = new JLabel();
            this.permissionMainTitle.setText("Permissions / Abilities");
            this.permissionMainTitle.setHorizontalAlignment(0);
            this.permissionMainTitle.setFont(new Font("Dialog", 1, 14));
            this.permissionMainTitle.setPreferredSize(new Dimension(25, 25));
            this.permissionPane = new JPanel();
            this.permissionPane.setLayout(new BorderLayout());
            this.permissionPane.add((Component)this.getPermissionScrollPane(), "Center");
            this.permissionPane.add((Component)this.permissionCountLabel, "South");
            this.permissionPane.add((Component)this.permissionMainTitle, "North");
        }
        return this.permissionPane;
    }

    private JScrollPane getPermissionScrollPane() {
        if (this.permissionScrollPane == null) {
            this.permissionScrollPane = new JScrollPane();
            this.permissionScrollPane.setViewportView(this.getPermissionsJList());
        }
        return this.permissionScrollPane;
    }

    private JList getPermissionsJList() {
        if (this.permissionsJList == null) {
            this.permissionsJList = new JCheckBoxJList();
            this.permissionsJList.setModel(this.defaultListModel);
            this.permissionsJList.addPropertyChangeListener("change", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AccountPane.this.showPermissionCount(String.valueOf(AccountPane.this.permissionsJList.getSelectedIndices().length) + " permissions selected");
                    AccountPane.this.enableUpdateButton();
                }
            });
        }
        return this.permissionsJList;
    }

    private JTextField getDisplayNameTextField() {
        if (this.displayNameTextField == null) {
            this.displayNameTextField = new JTextField();
            this.displayNameTextField.setBounds(new Rectangle(14, 88, 272, 22));
            this.displayNameTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    AccountPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNameTextField;
    }

    private JTextField getPasswordTextField() {
        if (this.passwordTextField == null) {
            this.passwordTextField = new JTextField();
            this.passwordTextField.setBounds(new Rectangle(14, 140, 272, 22));
            this.passwordTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    AccountPane.this.enableUpdateButton();
                }
            });
        }
        return this.passwordTextField;
    }

    private JTextField getPasswordConfirmField() {
        if (this.passwordConfirmField == null) {
            this.passwordConfirmField = new JTextField();
            this.passwordConfirmField.setBounds(new Rectangle(14, 191, 272, 22));
            this.passwordConfirmField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    AccountPane.this.enableUpdateButton();
                }
            });
        }
        return this.passwordConfirmField;
    }

    private JComboBox getGroupComboBox() {
        if (this.groupComboBox == null) {
            this.groupComboBox = new JComboBox();
            this.groupComboBox.setBounds(new Rectangle(14, 291, 272, 22));
            this.groupComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountPane.this.enableUpdateButton();
                }
            });
        }
        return this.groupComboBox;
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.account != null) {
            try {
                Account changedAccount = this.getAccountFromFields(null);
                if (!this.account.isSameAs(changedAccount)) {
                    enableButton = true;
                }
                if (!this.account.getPermissionList().isSameAs(changedAccount.getPermissionList())) {
                    enableButton = true;
                }
                if (!this.getPasswordTextField().getText().equals(this.getPasswordConfirmField().getText())) {
                    enableButton = true;
                }
            }
            catch (InvalidFieldValue e) {
                this.getController().getLog().log(Log.DEBUG, "Input Problem (but not saving) ", e);
                enableButton = true;
            }
        } else if (this.getAddButton().isVisible()) {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    private Account getAccountFromFields(Account checkAccount) throws InvalidFieldValue {
        Object[] objects;
        Site site = (Site)this.getSiteSelectionComboBox().getSelectedItem();
        if (checkAccount == null) {
            if (this.account == null) {
                ClientType.Type clientType = (ClientType.Type)((Object)this.getAccountTypeComboBox().getSelectedItem());
                ClientId clientId = new ClientId(this.getContest().getSiteNumber(), clientType, 0);
                checkAccount = new Account(clientId, null, site.getSiteNumber());
            } else {
                checkAccount = new Account(this.account.getClientId(), null, this.account.getSiteNumber());
            }
        }
        checkAccount.clearListAndLoadPermissions(new PermissionList());
        Object[] objectArray = objects = this.getPermissionsJList().getSelectedValues();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            JCheckBox checkBox = (JCheckBox)object;
            String name = checkBox.getText();
            Permission.Type type = this.getTypeFromDescrption(name);
            checkAccount.addPermission(type);
            ++n2;
        }
        if (objects.length == 0 && this.account == null) {
            ClientType.Type clientType = checkAccount.getClientId().getClientType();
            checkAccount.clearListAndLoadPermissions(new PermissionGroup().getPermissionList(clientType));
        }
        checkAccount.setDisplayName(this.getDisplayNameTextField().getText());
        if (this.getGroupComboBox().getSelectedIndex() > 0) {
            Group group = (Group)this.getGroupComboBox().getSelectedItem();
            checkAccount.setGroupId(group.getElementId());
        } else {
            checkAccount.setGroupId(null);
        }
        checkAccount.setSiteNumber(site.getSiteNumber());
        checkAccount.setPassword(this.getPasswordConfirmField().getText());
        return checkAccount;
    }

    private Permission.Type getTypeFromDescrption(String string) {
        Permission.Type[] typeArray = Permission.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Permission.Type type = typeArray[n2];
            if (string.equals(this.permission.getDescription(type))) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private JComboBox getAccountTypeComboBox() {
        if (this.accountTypeComboBox == null) {
            this.accountTypeComboBox = new JComboBox();
            this.accountTypeComboBox.setBounds(new Rectangle(14, 242, 137, 25));
            this.accountTypeComboBox.addItem(ClientType.Type.TEAM);
            this.accountTypeComboBox.addItem(ClientType.Type.JUDGE);
            this.accountTypeComboBox.addItem(ClientType.Type.SCOREBOARD);
            this.accountTypeComboBox.addItem(ClientType.Type.ADMINISTRATOR);
            this.accountTypeComboBox.addItem(ClientType.Type.SPECTATOR);
        }
        return this.accountTypeComboBox;
    }

    private JTextField getAccountTextField() {
        if (this.accountTextField == null) {
            this.accountTextField = new JTextField();
            this.accountTextField.setEditable(false);
            this.accountTextField.setSize(new Dimension(272, 22));
            this.accountTextField.setLocation(new Point(14, 38));
        }
        return this.accountTextField;
    }

    private JComboBox getSiteSelectionComboBox() {
        if (this.siteSelectionComboBox == null) {
            this.siteSelectionComboBox = new JComboBox();
            this.siteSelectionComboBox.setBounds(new Rectangle(157, 243, 124, 25));
        }
        return this.siteSelectionComboBox;
    }
}

