/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.core.util.IMemento;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    private XMLMemento(Document doc, Element el) {
        this.factory = doc;
        this.element = el;
    }

    @Override
    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    @Override
    public IMemento createChild(String type, String id) {
        Element child = this.factory.createElement(type);
        child.setAttribute("IMemento.internal.id", id);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    /*
     * Loose catch block
     */
    protected static XMLMemento createReadRoot(InputStream in) {
        block13: {
            block12: {
                Document document = null;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                document = parser.parse(new InputSource(in));
                Node node = document.getFirstChild();
                if (!(node instanceof Element)) break block12;
                XMLMemento xMLMemento = new XMLMemento(document, (Element)node);
                try {
                    in.close();
                }
                catch (Exception exception) {}
                return xMLMemento;
                catch (Exception exception) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (Exception exception2) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception3) {}
                    break block13;
                }
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    @Override
    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                return new XMLMemento(this.factory, element2);
            }
            ++nX;
        }
        return null;
    }

    @Override
    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        int nX = 0;
        while (nX < size) {
            Element element2;
            Node node = nodes.item(nX);
            if (node instanceof Element && (element2 = (Element)node).getNodeName().equals(type)) {
                list.add(element2);
            }
            ++nX;
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        int x = 0;
        while (x < size) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
            ++x;
        }
        return results;
    }

    public byte[] getContents() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out);
        return out.toByteArray();
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Float(strValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public String getId() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    @Override
    public String getName() {
        return this.element.getNodeName();
    }

    @Override
    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Integer(strValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public Long getLong(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Long(strValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public List<String> getNames() {
        NamedNodeMap map = this.element.getAttributes();
        int size = map.getLength();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            Node node = map.item(i);
            String name = node.getNodeName();
            list.add(name);
            ++i;
        }
        return list;
    }

    public static IMemento loadMemento(String filename) throws IOException {
        XMLMemento xMLMemento;
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filename));
            xMLMemento = XMLMemento.createReadRoot(in);
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        return xMLMemento;
    }

    private void putElement(Element element2) {
        NamedNodeMap nodeMap = element2.getAttributes();
        int size = nodeMap.getLength();
        int i = 0;
        while (i < size) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
            ++i;
        }
        NodeList nodes = element2.getChildNodes();
        size = nodes.getLength();
        int i2 = 0;
        while (i2 < size) {
            Node node = nodes.item(i2);
            if (node instanceof Element) {
                XMLMemento child = (XMLMemento)this.createChild(node.getNodeName());
                child.putElement((Element)node);
            }
            ++i2;
        }
    }

    @Override
    public void putFloat(String key, float f) {
        this.element.setAttribute(key, String.valueOf(f));
    }

    @Override
    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    @Override
    public void putLong(String key, long n) {
        this.element.setAttribute(key, Long.toString(n));
    }

    @Override
    public void putMemento(IMemento memento) {
        XMLMemento xmlMemento = (XMLMemento)memento;
        this.putElement(xmlMemento.element);
    }

    @Override
    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    public void save(OutputStream os) throws IOException {
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(this.factory);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String saveToString() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.save(outputStream);
        return outputStream.toString();
    }

    public void saveToFile(String filename) throws IOException {
        FileOutputStream w = null;
        try {
            try {
                w = new FileOutputStream(filename);
                this.save(w);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (w != null) {
            try {
                w.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Boolean getBoolean(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        if ("true".equalsIgnoreCase(strValue)) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.element.setAttribute(key, Boolean.toString(value));
    }
}

