/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import java.util.Vector;

public final class TabSeparatedValueParser {
    private static final char TAB_CHAR = '\t';
    private static final String TAB_STRING = String.valueOf('\t');

    public static String[] parseLine(String line) throws Exception {
        String[] array = new String[]{""};
        int field = 1;
        String currentField = "";
        Vector<String> v = new Vector<String>();
        boolean inQuote = false;
        int length = line.length();
        int i = 0;
        while (i < line.length()) {
            char current = line.charAt(i);
            if (current == '\"') {
                if (inQuote) {
                    if (i + 1 < length) {
                        char next = line.charAt(i + 1);
                        if (next == '\t') {
                            inQuote = false;
                        } else if (next == '\"') {
                            currentField = currentField.concat("\"");
                            ++i;
                        } else {
                            new Exception("found unexpected quote at position " + i + ", but next character '" + String.valueOf(next) + "'");
                        }
                    }
                } else {
                    inQuote = true;
                }
            } else if (current == '\t') {
                if (inQuote) {
                    currentField = currentField.concat(TAB_STRING);
                } else {
                    v.addElement(currentField);
                    ++field;
                    currentField = "";
                }
            } else {
                currentField = currentField.concat(new Character(current).toString());
            }
            ++i;
        }
        v.addElement(currentField);
        array = new String[field];
        if (field != v.size()) {
            new Exception("Incorrect number of fields (found " + field + ", but expected " + v.size() + ")");
        }
        i = 0;
        while (i < v.size()) {
            Object o = v.elementAt(i);
            array[i] = o != null ? (String)o : "";
            ++i;
        }
        return array;
    }

    public static String toString(String[] array) {
        String s = "";
        int i = 0;
        while (i < array.length) {
            String newField = "";
            int start = 0;
            boolean needsQuote = false;
            String field = array[i];
            if (field.indexOf("\"") > -1) {
                needsQuote = true;
                while (field.indexOf("\"", start) > -1) {
                    newField = newField.concat(String.valueOf(field.substring(start, field.indexOf("\"", start) + 1)) + "\"");
                    start = field.indexOf("\"", start) + 1;
                }
                field = String.valueOf(newField) + field.substring(start);
            }
            s = field.indexOf(String.valueOf(TAB_STRING)) > -1 || needsQuote ? s.concat("\"" + field + "\",") : s.concat(String.valueOf(field) + TAB_STRING);
            ++i;
        }
        s = s.substring(0, s.length() - 1);
        return s;
    }

    private TabSeparatedValueParser() {
    }
}

