/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Balloon;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Problem;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class BalloonWriter {
    private Object printingLock = new Object();
    private Log log;
    private static final String NL = System.getProperty("line.separator");
    private String myHostName = "";
    private String contestTitle = "";

    public BalloonWriter(Log aLog) {
        this.log = aLog;
        try {
            InetAddress address = InetAddress.getLocalHost();
            if (address != null) {
                this.myHostName = address.getHostName();
            } else {
                this.log.fine("getLocalHost() returned null");
                this.myHostName = "localhost";
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.log.fine("getLostHost threw a UnknownHostException");
            this.myHostName = "localhost";
        }
    }

    private String buildBalloonMessage(Balloon balloon, boolean postscript) {
        String answer = balloon.getAnswer();
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        StringBuffer message = new StringBuffer("");
        int x = 72;
        int y = 720;
        if (postscript) {
            message.append("%!" + NL + NL);
            message.append("/Time-Roman findfont 18 scalefont setfont" + NL);
        }
        if (answer.equalsIgnoreCase("revoke") || answer.equalsIgnoreCase("take")) {
            message.append(this.print("There has been a change in judgement.", postscript, x, y));
            message.append(NL);
            message.append(this.print("Please ensure " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ")", postscript, x, y -= 20));
            message.append(NL);
            message.append(this.print("does not have a " + balloonSettings.getColor(balloon.getProblemId()) + " colored balloon.", postscript, x, y -= 20));
            message.append(String.valueOf(NL) + NL + NL);
            y -= 60;
        }
        if (!answer.equalsIgnoreCase("test")) {
            y = this.buildBalloonMessageRunInfo(message, balloon, postscript, y);
        }
        y = this.buildBalloonMessageSummary(message, balloon, postscript, y - 20);
        if (postscript) {
            message.append(String.valueOf(NL) + "showpage" + NL);
        }
        return message.toString();
    }

    private int buildBalloonMessageRunInfo(StringBuffer message, Balloon balloon, boolean postscript, int y) {
        String status = balloon.getAnswer();
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        try {
            int x = 72;
            if (postscript) {
                message.append("/Time-Roman findfont 18 scalefont setfont" + NL);
            }
            String yesOrNo = "";
            yesOrNo = status.equalsIgnoreCase("yes") ? "YES" : "NO";
            message.append(this.print(String.valueOf(yesOrNo) + " for " + balloon.getClientId().getName(), postscript, x, y));
            message.append(NL);
            y -= 20;
            if (status.equalsIgnoreCase("yes")) {
                message.append(this.print("Color: " + balloonSettings.getColor(balloon.getProblemId()), postscript, x, y));
                message.append(NL);
                y -= 20;
            }
            message.append(this.print("Team: " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ")", postscript, x, y));
            message.append(NL);
            message.append(this.print("Site: " + balloon.getClientId().getSiteNumber() + " - " + balloon.getSiteTitle(), postscript, x, y -= 20));
            message.append(NL);
            message.append(this.print("Problem: " + balloon.getProblemTitle(), postscript, x, y -= 20));
            message.append(NL);
            y -= 20;
            if (balloon.getRun() != null) {
                message.append(this.print("Time: " + balloon.getRun().getElapsedMins(), postscript, x, y));
                message.append(NL);
                message.append(this.print("RunID: " + balloon.getRun().getNumber(), postscript, x, y -= 20));
                message.append(NL);
                y -= 20;
            }
            if (this.contestTitle.trim().length() > 0) {
                message.append(this.print("Contest Title: " + this.contestTitle.trim(), postscript, x, y));
                message.append(NL);
                y -= 20;
            }
            message.append(this.print("Current Date: " + new Date().toString(), postscript, x, y));
            message.append(NL);
            y -= 40;
        }
        catch (Exception e) {
            this.log.throwing(this.getClass().getName(), "buildBaloonMesageRunInfo for " + balloon.getRun().getNumber() + " error.", e);
        }
        return y;
    }

    private int buildBalloonMessageSummary(StringBuffer message, Balloon balloon, boolean postscript, int y) {
        String status = balloon.getAnswer();
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        try {
            int x = 72;
            if (postscript) {
                message.append("/Time-Roman findfont 14 scalefont setfont" + NL);
            }
            StringWriter sw = new StringWriter();
            if (status.equalsIgnoreCase("test")) {
                message.append(this.print("List of balloon colors:", postscript, x, y));
                message.append(NL);
                Problem[] problems = balloon.getProblems();
                int j = 0;
                while (j < problems.length) {
                    sw.write(NL);
                    sw.write(this.print("    " + balloonSettings.getColor(problems[j]) + " - " + problems[j].getDisplayName(), postscript, x, y -= 32));
                    sw.write(NL);
                    ++j;
                }
                message.append(sw.toString());
            } else {
                int count = 0;
                int saveY = y;
                Problem[] problems = balloon.getProblems();
                int j = 0;
                while (j < problems.length) {
                    sw.write(NL);
                    sw.write(this.print("    " + balloonSettings.getColor(problems[j]) + " - " + problems[j].getDisplayName(), postscript, x, y -= 32));
                    sw.write(NL);
                    ++count;
                    ++j;
                }
                if (count == 1) {
                    message.append(String.valueOf(NL) + NL + NL);
                    message.append(this.print("Team now has " + count + " balloon:", postscript, x, saveY));
                    message.append(String.valueOf(NL) + sw.toString());
                } else if (count > 1) {
                    message.append(String.valueOf(NL) + NL + NL);
                    message.append(this.print("Team now has " + count + " balloons:", postscript, x, saveY));
                    message.append(String.valueOf(NL) + sw.toString());
                } else {
                    message.append(String.valueOf(NL) + NL + NL);
                    message.append(this.print("This team now has 0 (zero) balloons.", postscript, x, saveY));
                    message.append(NL);
                }
                sw.close();
                sw = null;
            }
        }
        catch (Exception e) {
            this.log.throwing(this.getClass().getName(), "buildBaloonMesageSummary for " + balloon.getRun() + " error collecting list of balloons", e);
        }
        return y;
    }

    private String print(String message, boolean postscript, int x, int y) {
        if (message == null) {
            return null;
        }
        if (postscript) {
            StringWriter psString = new StringWriter(message.length() + 30);
            psString.write(String.valueOf(x) + " " + y + " moveto" + NL + "(");
            try {
                int i = 0;
                while (i < message.length()) {
                    char ch = message.charAt(i);
                    switch (ch) {
                        case '(': {
                            psString.write("\\(");
                            break;
                        }
                        case ')': {
                            psString.write("\\)");
                            break;
                        }
                        default: {
                            psString.write(ch);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.throwing(this.getClass().getName(), "Unable to postscript quote(" + message + ")", e);
                return message;
            }
            psString.write(") show");
            return psString.toString();
        }
        return message;
    }

    public boolean sendBalloon(Balloon balloon) {
        boolean sentBalloon = false;
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        try {
            try {
                this.log.entering(this.getClass().getName(), "sendBalloon", balloon.getAnswer());
                if (balloon.getContestTitle() != null) {
                    this.contestTitle = balloon.getContestTitle();
                }
                String message = this.buildBalloonMessage(balloon, false);
                String answer = balloon.getAnswer();
                if (balloonSettings.isEmailBalloons()) {
                    if (balloonSettings.getEmailContact() != null && balloonSettings.getEmailContact().trim().length() > 0) {
                        String to = balloonSettings.getEmailContact().trim();
                        if (balloonSettings.getMailServer() != null && balloonSettings.getMailServer().trim().length() > 0) {
                            String subject;
                            InetAddress mailServer;
                            try {
                                mailServer = InetAddress.getByName(balloonSettings.getMailServer());
                            }
                            catch (UnknownHostException uhe) {
                                this.log.throwing(this.getClass().getName(), "sendBalloons smtpServerString=" + balloonSettings.getMailServer(), uhe);
                                mailServer = null;
                            }
                            String emailMessage = "";
                            String date = Utilities.getRFC2822DateTime();
                            String messageId = String.format("Message-ID: <%1$tY%1$tm%1$td%1$tH%1$tM%1$tS.pc%1$tL@" + this.myHostName + ">", new GregorianCalendar());
                            if (answer.equalsIgnoreCase("yes")) {
                                subject = "Subject: YES " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ") color " + balloonSettings.getColor(balloon.getProblemId()) + NL;
                                emailMessage = String.valueOf(subject) + "Date: " + date + NL + messageId + NL + NL + message;
                            } else if (answer.equalsIgnoreCase("no")) {
                                subject = "Subject: NO " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ")" + " problem " + balloon.getProblemId() + NL;
                                emailMessage = String.valueOf(subject) + "Date: " + date + NL + messageId + NL + NL + message;
                            } else if (answer.equalsIgnoreCase("test")) {
                                subject = "Subject: List of Balloon Colors" + NL;
                                emailMessage = String.valueOf(subject) + "Date: " + date + NL + messageId + NL + NL + message;
                            } else {
                                subject = "Subject: Take away balloon from " + balloon.getClientId().getName() + " color " + balloonSettings.getColor(balloon.getProblemId()) + NL;
                                emailMessage = String.valueOf(subject) + "Date: " + date + NL + messageId + NL + NL + message;
                            }
                            if (mailServer != null && this.sendBalloonByEmail(emailMessage, mailServer, to)) {
                                sentBalloon = true;
                            }
                            emailMessage = null;
                        } else {
                            this.log.info("emailing enabled, but no mailserver set");
                        }
                    } else {
                        this.log.info("emailing enabled, but no emailContest set");
                    }
                }
                if (balloonSettings.isPrintBalloons()) {
                    if (balloonSettings.getPrintDevice() != null && balloonSettings.getPrintDevice().trim().length() > 0) {
                        if (balloonSettings.isPostscriptCapable()) {
                            message = this.buildBalloonMessage(balloon, true);
                        } else {
                            int lines = 66;
                            if (balloonSettings.getLinesPerPage() > 0) {
                                lines = balloonSettings.getLinesPerPage();
                            }
                            int index = message.indexOf(NL, 0);
                            int count = 0;
                            while (index != -1) {
                                ++count;
                                index = message.indexOf(NL, index + 1);
                            }
                            if (count < lines) {
                                StringWriter sw = new StringWriter(66);
                                int i = count;
                                while (i < lines) {
                                    sw.write(NL);
                                    ++i;
                                }
                                message = String.valueOf(message) + sw.toString();
                                sw.close();
                                sw = null;
                            }
                        }
                        if (this.sendBalloonToLocalFile(message, balloonSettings.getPrintDevice().trim())) {
                            sentBalloon = true;
                        }
                    } else {
                        this.log.info("printing enabled, but no printDevice set");
                    }
                }
                message = null;
            }
            catch (Exception e) {
                this.log.throwing(this.getClass().getName(), "sendBalloon()", e);
                if (this.log == null) {
                    System.err.println("Log is null");
                }
                if (this.getClass() == null) {
                    System.err.println("getClass is null");
                }
                this.log.exiting(this.getClass().getName(), "sendBalloon()", sentBalloon);
            }
        }
        finally {
            if (this.log == null) {
                System.err.println("Log is null");
            }
            if (this.getClass() == null) {
                System.err.println("getClass is null");
            }
            this.log.exiting(this.getClass().getName(), "sendBalloon()", sentBalloon);
        }
        return sentBalloon;
    }

    private boolean sendBalloonByEmail(String message, InetAddress host, String mailTo) {
        boolean success = false;
        try {
            try {
                this.log.entering(this.getClass().getName(), "sendBalloonByEmail()", host.toString());
                String[] rcpts = this.spliRecipients(mailTo);
                Socket socket = new Socket(host, 25);
                OutputStream os = socket.getOutputStream();
                InputStream is = socket.getInputStream();
                int arraySize = 200;
                byte[] b = new byte[arraySize];
                boolean error = false;
                String mess = "";
                int dummy = 0;
                while (dummy < 1) {
                    mess = "helo " + this.myHostName + NL;
                    os.write(mess.getBytes());
                    is.read(b);
                    if (b[0] == 52 || b[0] == 53) {
                        this.log.info("ERROR: sendBalloon I said=\"" + mess + "\" server said=\"" + new String(b).trim() + "\"");
                        error = true;
                        break;
                    }
                    mess = "mail from: <pc2@ecs.csus.edu>" + NL;
                    os.write(mess.getBytes());
                    b = new byte[arraySize];
                    is.read(b);
                    if (b[0] == 52 || b[0] == 53) {
                        this.log.info("ERROR: sendBalloon I said=\"" + mess + "\" server said=\"" + new String(b).trim() + "\"");
                        error = true;
                        break;
                    }
                    int i = 0;
                    while (i < rcpts.length) {
                        mess = "rcpt to: <" + rcpts[i] + ">" + NL;
                        os.write(mess.getBytes());
                        b = new byte[arraySize];
                        is.read(b);
                        if (b[0] == 52 || b[0] == 53) {
                            this.log.info("ERROR: sendBalloon I said=\"" + mess + "\" server said=\"" + new String(b).trim() + "\"");
                            error = true;
                            break;
                        }
                        ++i;
                    }
                    if (error) break;
                    mess = "data" + NL;
                    os.write(mess.getBytes());
                    b = new byte[arraySize];
                    is.read(b);
                    if (b[0] == 52 || b[0] == 53) {
                        this.log.info("ERROR: sendBalloon I said=\"" + mess + "\" server said=\"" + new String(b).trim() + "\"");
                        error = true;
                        break;
                    }
                    StringBuffer fromName = new StringBuffer("Balloons");
                    if (this.contestTitle.trim().length() > 0) {
                        fromName.append(" - " + this.contestTitle.trim());
                    }
                    mess = "From: " + fromName.toString() + " <pc2@ecs.csus.edu>" + NL + "To: " + mailTo + NL;
                    os.write(mess.getBytes());
                    message = String.valueOf(message) + "." + NL;
                    os.write(message.getBytes());
                    b = new byte[arraySize];
                    is.read(b);
                    if (b[0] == 52 || b[0] == 53) {
                        this.log.info("ERROR: sendBalloon I said=\"" + mess + "\" server said=\"" + new String(b).trim() + "\"");
                        error = true;
                        break;
                    }
                    os.write(new String("quit" + NL).getBytes());
                    b = new byte[arraySize];
                    is.read(b);
                    if (b[0] == 52 || b[0] == 53) {
                        this.log.info("ERROR: sendBalloon I said=\"" + mess + "\" server said=\"" + new String(b).trim() + "\"");
                        error = true;
                        break;
                    }
                    ++dummy;
                }
                socket.close();
                if (!error) {
                    success = true;
                }
            }
            catch (Exception e) {
                this.log.throwing(this.getClass().getName(), "sendBallonBalloonByEmail()", e);
                this.log.exiting(this.getClass().getName(), "sendBalloonByEmail()", success);
            }
        }
        finally {
            this.log.exiting(this.getClass().getName(), "sendBalloonByEmail()", success);
        }
        return success;
    }

    String[] spliRecipients(String mailTo) {
        String[] results = null;
        if (mailTo != null) {
            int comma = mailTo.indexOf(44);
            if (comma == -1) {
                results = new String[]{mailTo.trim()};
            } else {
                StringTokenizer st = new StringTokenizer(mailTo, ",");
                results = new String[st.countTokens()];
                int i = 0;
                while (i < results.length) {
                    results[i] = st.nextToken().trim();
                    ++i;
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBalloonToLocalFile(String message, String fileName) {
        boolean success = false;
        try {
            try {
                this.log.entering(this.getClass().getName(), "sendBalloonToLocalFile", fileName);
                this.log.finest("Obtaining lock to print");
                Object object = this.printingLock;
                synchronized (object) {
                    FileOutputStream fout = new FileOutputStream(fileName);
                    this.log.finest("Printing");
                    PrintWriter pout = new PrintWriter(fout, true);
                    pout.print(message);
                    pout.close();
                }
                this.log.finest("Printing done, lock released");
                success = true;
            }
            catch (Exception e) {
                this.log.throwing(this.getClass().getName(), "sendBallonBalloonToLocalFile()", e);
                this.log.exiting(this.getClass().getName(), "sendBalloontoLocalFile", success);
            }
        }
        finally {
            this.log.exiting(this.getClass().getName(), "sendBalloontoLocalFile", success);
        }
        return success;
    }
}

