/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.transport;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.transport.ConnectionHandler;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerThread;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.TransportManager;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.crypto.SealedObject;

public class ConnectionHandlerServerThread
extends ConnectionHandlerThread {
    public static final String SVN_ID = "$Id: ConnectionHandlerServerThread.java 1479 2008-04-30 02:19:55Z boudreat $";

    public ConnectionHandlerServerThread(Socket socket, TransportManager tmCallBack, ConnectionHandler chCallBack, Log log) {
        super(socket, tmCallBack, chCallBack);
        chCallBack.setConnectionHandlerServerThread(this);
        this.setLog(log);
        this.getLog().info("new ConnectionhandlerServerThread on Socket " + socket.toString());
    }

    public void run() {
        try {
            block9: {
                this.setToOtherModule(new ObjectOutputStream(this.getMySocket().getOutputStream()));
                InputStream iss = this.getMySocket().getInputStream();
                this.setFromOtherModule(new ObjectInputStream(iss));
                this.getTmCallBack().registerIncomingConnectionRequest(this.getMyConnectionID(), this);
                this.sendUnencrypted(this.getTmCallBack().getPublicKeyPacket());
                try {
                    this.getTmCallBack().receiveUnencrypted(this.receiveUnencrypted(), this.getMyConnectionID());
                }
                catch (Exception e) {
                    this.getLog().log(Log.INFO, "Exception - Could not receive unencrypted packet for: " + this.getMyConnectionID(), e);
                    if (this.getMyConnectionID().getSecretKey() != null) break block9;
                    this.getLog().info("Could not generate SecretKey -- Aborting connection");
                    this.getTmCallBack().connectionDropped(this.getMyConnectionID());
                    return;
                }
            }
            this.getMyConnectionID().setReadyToCommunicate(true);
            this.setStillListening(true);
            while (this.isStillListening()) {
                SealedObject sealedObject = null;
                try {
                    sealedObject = this.receive();
                    this.getTmCallBack().receive(sealedObject, this.getMyConnectionID());
                }
                catch (TransportException e) {
                    if (e.getMessage() == null) {
                        this.getLog().throwing(this.getClass().getName(), "run - e.getmessage is null()", e);
                        this.setStillListening(false);
                        continue;
                    }
                    if (!e.getMessage().equalsIgnoreCase("connection reset")) continue;
                    this.setStillListening(false);
                }
            }
        }
        catch (SocketException socketException) {
            this.getLog().info("Lost connection to " + this.getMyConnectionID());
        }
        catch (Exception e) {
            this.getLog().log(Log.DEBUG, "Exception " + e.getMessage(), e);
        }
        this.getTmCallBack().connectionDropped(this.getMyConnectionID());
    }
}

