/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.transport;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerClientThread;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerServerThread;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.TransportManager;
import edu.csus.ecs.pc2.core.transport.TransportWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.crypto.SealedObject;

public class ConnectionHandler
implements Runnable {
    public static final String SVN_ID = "$Id: ConnectionHandler.java 1001 2007-10-25 15:45:56Z ashoos $";
    private Socket mySocket = null;
    private ServerSocket serverSocket = null;
    private boolean serverListening = false;
    private ObjectOutputStream toOtherModule = null;
    private ObjectInputStream fromOtherModule = null;
    private Log log = null;
    private TransportManager tmCallBack = null;
    private int listeningPort = 50002;
    private ConnectionHandlerClientThread connectionHandlerClientThread = null;
    private ConnectionHandlerServerThread connectionHandlerServerThread = null;
    private ConnectionHandlerID connectionHandlerID = null;

    protected ConnectionHandler(Log log, String host, int port, TransportManager tmCallBack, TransportManager.tmTypes tmType) throws TransportException {
        this.setLog(log);
        this.setTmCallBack(tmCallBack);
        try {
            this.setMySocket(new Socket(host, port));
        }
        catch (UnknownHostException e) {
            this.getLog().info("could not resolve host:" + host);
            throw new TransportException(e.getMessage());
        }
        catch (IOException e) {
            this.getLog().info("IO Exception:" + host);
            throw new TransportException(e.getMessage());
        }
        catch (Exception e) {
            this.getLog().info("Exception:" + host);
            throw new TransportException(e.getMessage());
        }
        if (this.getMySocket() != null) {
            try {
                this.setConnectionHandlerID(new ConnectionHandlerID(this.getMySocket().toString()));
                new ConnectionHandlerClientThread(this.getMySocket(), this.getTmCallBack(), this, tmType, this.getLog()).start();
            }
            catch (Exception e) {
                this.getLog().info("Could spawn new client thread");
                throw new TransportException(e.getMessage());
            }
        }
    }

    protected ConnectionHandler(Log log, int port, TransportManager tmCallBack) throws TransportException {
        this.setLog(log);
        this.setTmCallBack(tmCallBack);
        this.setListeningPort(port);
        try {
            this.setServerSocket(new ServerSocket(this.getListeningPort()));
            this.setConnectionHandlerID(new ConnectionHandlerID(this.getServerSocket().toString()));
        }
        catch (IOException e) {
            this.getLog().info("Could not listen on port:" + this.getListeningPort());
            throw new TransportException(e.getMessage());
        }
    }

    public void send(SealedObject msgToSend) throws TransportException {
        try {
            if (this.getTmCallBack().getTmType() == TransportManager.tmTypes.SERVER) {
                this.getConnectionHandlerServerThread().send(msgToSend);
            } else {
                this.getConnectionHandlerClientThread().send(msgToSend);
            }
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage());
        }
    }

    public void send(TransportWrapper msgToSend) throws TransportException {
        try {
            if (this.getTmCallBack().getTmType() == TransportManager.tmTypes.SERVER) {
                this.getConnectionHandlerServerThread().send(msgToSend);
            } else {
                this.getConnectionHandlerClientThread().send(msgToSend);
            }
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage());
        }
    }

    private void setLog(Log log) {
        this.log = log;
    }

    private TransportManager getTmCallBack() {
        return this.tmCallBack;
    }

    private void setTmCallBack(TransportManager tmCallBack) {
        this.tmCallBack = tmCallBack;
    }

    private ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    private boolean isServerListening() {
        return this.serverListening;
    }

    private void setServerListening(boolean serverListening) {
        this.serverListening = serverListening;
    }

    protected int getListeningPort() {
        return this.listeningPort;
    }

    protected void setListeningPort(int listeningPort) {
        this.listeningPort = listeningPort;
    }

    private Socket getMySocket() {
        return this.mySocket;
    }

    private void setMySocket(Socket mySocket) {
        this.mySocket = mySocket;
        try {
            this.mySocket.setKeepAlive(true);
        }
        catch (SocketException e) {
            this.getLog().info("Could not set KeepAlive on socket");
            this.getLog().throwing(this.getClass().getName(), "setMySocket", e);
        }
    }

    protected ConnectionHandlerClientThread getConnectionHandlerClientThread() {
        return this.connectionHandlerClientThread;
    }

    protected void setConnectionHandlerClientThread(ConnectionHandlerClientThread connectionHandlerClientThread) {
        this.connectionHandlerClientThread = connectionHandlerClientThread;
    }

    protected ConnectionHandlerServerThread getConnectionHandlerServerThread() {
        return this.connectionHandlerServerThread;
    }

    protected void setConnectionHandlerServerThread(ConnectionHandlerServerThread connectionHandlerServerThread) {
        this.connectionHandlerServerThread = connectionHandlerServerThread;
    }

    protected ObjectInputStream getFromOtherModule() {
        return this.fromOtherModule;
    }

    protected void setFromOtherModule(ObjectInputStream fromOtherModule) {
        this.fromOtherModule = fromOtherModule;
    }

    protected ObjectOutputStream getToOtherModule() {
        return this.toOtherModule;
    }

    protected void setToOtherModule(ObjectOutputStream toOtherModule) {
        this.toOtherModule = toOtherModule;
    }

    private Log getLog() {
        return this.log;
    }

    public void run() {
        if (this.getServerSocket() != null) {
            this.setServerListening(true);
            while (this.isServerListening()) {
                try {
                    new ConnectionHandlerServerThread(this.getServerSocket().accept(), this.getTmCallBack(), this, this.getLog()).start();
                }
                catch (Exception exception) {
                    this.getLog().info("Could not spawn new thread:");
                }
            }
        }
    }

    public ConnectionHandlerID getConnectionHandlerID() {
        return this.connectionHandlerID;
    }

    private void setConnectionHandlerID(ConnectionHandlerID connectionHandlerID) {
        this.connectionHandlerID = connectionHandlerID;
    }
}

