/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.security;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.security.Crypto;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.KeyUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class FileSecurity {
    private static PBEParameterSpec algorithm;
    private static Cipher dcipher;
    private static Cipher ecipher;
    private static char[] contestPassword;
    private static SecretKey contestSecretKey;
    private static KeyPair contestKeyPair;
    private static final String CONTEST_KEY_FILENAME = "contest.key";
    private static final String RECOVERY_KEY_FILENAME = "recovery.key";
    private static final byte[] PUBLIC_KEY;
    private static boolean readyToReadWrite;
    private static Crypto fileCrypt;
    private static String contestDirectory;
    public static final String KEY_FILE_NOT_FOUND = "KEY_FILE_NOT_FOUND";

    static {
        byte[] byArray = new byte[162];
        byArray[0] = 48;
        byArray[1] = -127;
        byArray[2] = -97;
        byArray[3] = 48;
        byArray[4] = 13;
        byArray[5] = 6;
        byArray[6] = 9;
        byArray[7] = 42;
        byArray[8] = -122;
        byArray[9] = 72;
        byArray[10] = -122;
        byArray[11] = -9;
        byArray[12] = 13;
        byArray[13] = 1;
        byArray[14] = 1;
        byArray[15] = 1;
        byArray[16] = 5;
        byArray[18] = 3;
        byArray[19] = -127;
        byArray[20] = -115;
        byArray[22] = 48;
        byArray[23] = -127;
        byArray[24] = -119;
        byArray[25] = 2;
        byArray[26] = -127;
        byArray[27] = -127;
        byArray[29] = -120;
        byArray[30] = -32;
        byArray[31] = -95;
        byArray[32] = -10;
        byArray[33] = 118;
        byArray[34] = -62;
        byArray[35] = 56;
        byArray[36] = -73;
        byArray[37] = -51;
        byArray[38] = 104;
        byArray[39] = 5;
        byArray[40] = 13;
        byArray[41] = -100;
        byArray[42] = -35;
        byArray[43] = 49;
        byArray[44] = 27;
        byArray[45] = -35;
        byArray[46] = 92;
        byArray[47] = 110;
        byArray[48] = -76;
        byArray[49] = 105;
        byArray[50] = 104;
        byArray[51] = 21;
        byArray[52] = -75;
        byArray[53] = 87;
        byArray[54] = 122;
        byArray[55] = -55;
        byArray[56] = 28;
        byArray[57] = -51;
        byArray[58] = -13;
        byArray[59] = 55;
        byArray[60] = -22;
        byArray[61] = 75;
        byArray[62] = 55;
        byArray[63] = 37;
        byArray[64] = -72;
        byArray[65] = 26;
        byArray[66] = -71;
        byArray[67] = -65;
        byArray[68] = -2;
        byArray[69] = 37;
        byArray[70] = 69;
        byArray[71] = -71;
        byArray[72] = 124;
        byArray[73] = 8;
        byArray[74] = -78;
        byArray[75] = -29;
        byArray[76] = -70;
        byArray[77] = 45;
        byArray[78] = 57;
        byArray[79] = -83;
        byArray[80] = -25;
        byArray[81] = -113;
        byArray[82] = 113;
        byArray[83] = 102;
        byArray[84] = -60;
        byArray[85] = 6;
        byArray[86] = -30;
        byArray[87] = -24;
        byArray[88] = -124;
        byArray[89] = 94;
        byArray[90] = -31;
        byArray[91] = -17;
        byArray[92] = -25;
        byArray[93] = -23;
        byArray[94] = -38;
        byArray[95] = -18;
        byArray[96] = -125;
        byArray[97] = -46;
        byArray[98] = 70;
        byArray[99] = 68;
        byArray[100] = 97;
        byArray[101] = 28;
        byArray[102] = 86;
        byArray[103] = -24;
        byArray[104] = -68;
        byArray[105] = -41;
        byArray[106] = 124;
        byArray[107] = 38;
        byArray[108] = -85;
        byArray[109] = -5;
        byArray[110] = -51;
        byArray[111] = 46;
        byArray[112] = -25;
        byArray[113] = -121;
        byArray[114] = 84;
        byArray[115] = 46;
        byArray[116] = 99;
        byArray[117] = -5;
        byArray[118] = -36;
        byArray[119] = -94;
        byArray[120] = -88;
        byArray[121] = -31;
        byArray[122] = 9;
        byArray[123] = -117;
        byArray[124] = 17;
        byArray[125] = -10;
        byArray[126] = 22;
        byArray[127] = -104;
        byArray[128] = -13;
        byArray[129] = 17;
        byArray[130] = -115;
        byArray[131] = 74;
        byArray[132] = 78;
        byArray[133] = 55;
        byArray[134] = 95;
        byArray[135] = -124;
        byArray[136] = -5;
        byArray[137] = -92;
        byArray[138] = 70;
        byArray[139] = -72;
        byArray[140] = 26;
        byArray[141] = -64;
        byArray[142] = -45;
        byArray[143] = 32;
        byArray[144] = -109;
        byArray[145] = -59;
        byArray[146] = -82;
        byArray[147] = 60;
        byArray[148] = -79;
        byArray[149] = 76;
        byArray[150] = 69;
        byArray[151] = 32;
        byArray[152] = -72;
        byArray[153] = 95;
        byArray[154] = 91;
        byArray[155] = 116;
        byArray[156] = 33;
        byArray[157] = 2;
        byArray[158] = 3;
        byArray[159] = 1;
        byArray[161] = 1;
        PUBLIC_KEY = byArray;
        readyToReadWrite = false;
        fileCrypt = null;
        contestDirectory = "." + File.separator;
    }

    public FileSecurity(String inContestDirectory) {
        int iteration = 128;
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        readyToReadWrite = false;
        algorithm = new PBEParameterSpec(salt, iteration);
        Utilities.insureDir(inContestDirectory);
        if (!inContestDirectory.endsWith(File.separator)) {
            inContestDirectory = String.valueOf(inContestDirectory) + File.separator;
        }
        contestDirectory = inContestDirectory;
        fileCrypt = new Crypto();
        SecretKey sk = fileCrypt.generateSecretKey(fileCrypt.getPublicKey(), fileCrypt.getPrivateKey());
        fileCrypt.setSecretKey(sk);
    }

    public String getContestDirectory() {
        return contestDirectory;
    }

    public static boolean verifyPassword(char[] password) throws FileSecurityException {
        SealedObject objectFromDisk;
        SecretKey secretKey = null;
        KeyPair tmpKeyPair = null;
        if (!Utilities.isFileThere(String.valueOf(contestDirectory) + CONTEST_KEY_FILENAME)) {
            throw new FileSecurityException(KEY_FILE_NOT_FOUND);
        }
        try {
            objectFromDisk = (SealedObject)FileSecurity.readObjectFromFile(String.valueOf(contestDirectory) + CONTEST_KEY_FILENAME);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - failed to read file from disk", e);
            throw new FileSecurityException("FAILED_TO_READ_FILE");
        }
        try {
            secretKey = FileSecurity.makeSecretKey(password);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - failed to create key from password", e);
            throw new FileSecurityException("FAILED_TO_CREATE_KEY");
        }
        contestPassword = password;
        contestSecretKey = secretKey;
        try {
            FileSecurity.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - initialize ciphers", e);
            throw new FileSecurityException("FAILED_TO_INIT_CIPHERS");
        }
        try {
            tmpKeyPair = (KeyPair)FileSecurity.decryptObject(objectFromDisk, secretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "verify password - failed to decrypt object", e);
            throw new FileSecurityException("FAILED_TO_DECRYPT");
        }
        fileCrypt.setMyKeyPair(tmpKeyPair);
        SecretKey sk = fileCrypt.generateSecretKey(fileCrypt.getPublicKey(), fileCrypt.getPrivateKey());
        fileCrypt.setSecretKey(sk);
        readyToReadWrite = true;
        return true;
    }

    public SecretKey getSecretKey() {
        return contestSecretKey;
    }

    public void saveSecretKey(SecretKey theKey, char[] password) throws FileSecurityException {
        contestSecretKey = theKey;
        contestPassword = password;
        try {
            FileSecurity.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - initialize ciphers", e);
            throw new FileSecurityException("FAILED_TO_INIT_CIPHERS");
        }
        contestKeyPair = fileCrypt.getKeyPair();
        FileSecurity.writePC2RecoveryInfo();
        SealedObject sealedSecretKey = null;
        try {
            sealedSecretKey = FileSecurity.encryptObject(contestKeyPair, contestSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to encrypt contestSecretKey", e);
            throw new FileSecurityException("FAILED TO ENCRYPT", e);
        }
        try {
            FileSecurity.writeObjectToFile(String.valueOf(contestDirectory) + CONTEST_KEY_FILENAME, sealedSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to write file to disk", e);
            throw new FileSecurityException("FAILED TO WRITE", e);
        }
        readyToReadWrite = true;
    }

    public void saveSecretKey(PublicKey theKey, String filename) throws FileSecurityException {
        try {
            FileSecurity.writeObjectToFile(String.valueOf(contestDirectory) + filename, (Serializable)contestPassword);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writePC2RecoveryFile - failed to write file to disk", e);
            throw new FileSecurityException("FAILED TO WRITE", e);
        }
    }

    public static void saveSecretKey(char[] password) throws FileSecurityException {
        SealedObject sealedSecretKey = null;
        SecretKey secretKey = null;
        contestPassword = password;
        try {
            contestSecretKey = FileSecurity.makeSecretKey(password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FileSecurity.cipherInit();
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - initialize ciphers", e);
            throw new FileSecurityException("FAILED_TO_INIT_CIPHERS");
        }
        contestKeyPair = fileCrypt.getKeyPair();
        try {
            sealedSecretKey = FileSecurity.encryptObject(contestKeyPair, secretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to encrypt contestSecretKey", e);
            throw new FileSecurityException("FAILED TO ENCRYPT", e);
        }
        try {
            FileSecurity.writeObjectToFile(String.valueOf(contestDirectory) + CONTEST_KEY_FILENAME, sealedSecretKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "saveSecretKey - failed to write file to disk", e);
            throw new FileSecurityException("FAILED TO WRITE", e);
        }
        FileSecurity.writePC2RecoveryInfo();
        readyToReadWrite = true;
    }

    private static void writePC2RecoveryInfo() throws FileSecurityException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(PUBLIC_KEY);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            KeyUtilities.encryptString(String.valueOf(contestDirectory) + new String(contestPassword), String.valueOf(contestDirectory) + RECOVERY_KEY_FILENAME, publicKey);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writePC2RecoveryFile - failed to write file to disk", e);
            throw new FileSecurityException("FAILED TO WRITE", e);
        }
    }

    public String getPassword() {
        return new String(contestPassword);
    }

    public static void writeSealedFile(String fileName, Serializable objectToWrite) throws FileSecurityException {
        SealedObject sealedObjectToWrite;
        if (!readyToReadWrite) {
            throw new FileSecurityException("NOT_READY_TO_WRITE");
        }
        try {
            sealedObjectToWrite = fileCrypt.encrypt(objectToWrite);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writeFile - failed to encrypt object", e);
            throw new FileSecurityException("FAILED TO ENCRYPT", e);
        }
        try {
            FileSecurity.writeObjectToFile(fileName, sealedObjectToWrite);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "writeFile - failed to write file to disk", e);
            throw new FileSecurityException("FAILED TO WRITE", e);
        }
    }

    public static Serializable readSealedFile(String fileName) throws FileSecurityException {
        SealedObject sealedObjectFromDisk;
        Serializable objectToReturn = null;
        if (!readyToReadWrite) {
            throw new FileSecurityException("NOT_READY_TO_READ");
        }
        try {
            sealedObjectFromDisk = (SealedObject)FileSecurity.readObjectFromFile(fileName);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "readFile - failed to read file from disk", e);
            throw new FileSecurityException("FAILED TO READ", e);
        }
        try {
            objectToReturn = fileCrypt.decrypt(sealedObjectFromDisk);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.INFO, "readFile - failed to decrypt object", e);
            throw new FileSecurityException("FAILED TO DECRYPT", e);
        }
        return objectToReturn;
    }

    private static SecretKey makeSecretKey(char[] pwd) throws Exception {
        SecretKey key = null;
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(pwd);
            SecretKeyFactory keyBuilder = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            key = keyBuilder.generateSecret(pbeKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key;
    }

    private static void cipherInit() throws Exception {
        try {
            ecipher = Cipher.getInstance("PBEWithMD5AndDES");
            ecipher.init(1, (Key)contestSecretKey, algorithm);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new Exception(e.getMessage());
        }
        try {
            dcipher = Cipher.getInstance("PBEWithMD5AndDES");
            dcipher.init(2, (Key)contestSecretKey, algorithm);
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new Exception(e.getMessage());
        }
    }

    private static SealedObject encryptObject(Serializable objToEncrypt, SecretKey inSecretKey) throws Exception {
        SealedObject encryptedObject = null;
        try {
            encryptedObject = new SealedObject(objToEncrypt, ecipher);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception(e.getMessage());
        }
        return encryptedObject;
    }

    private static Serializable decryptObject(SealedObject encryptedObject, SecretKey inSecretKey) throws Exception {
        Serializable decryptedObject = null;
        try {
            decryptedObject = (Serializable)encryptedObject.getObject(dcipher);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new Exception(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new Exception(e.getMessage());
        }
        return decryptedObject;
    }

    public static boolean writeObjectToFile(String filename, Serializable serializable) throws IOException {
        FileOutputStream f = new FileOutputStream(filename);
        ObjectOutputStream s = new ObjectOutputStream(f);
        s.writeObject(serializable);
        s.flush();
        s.close();
        s = null;
        return true;
    }

    public static Object readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        Object object = new Object();
        FileInputStream in = new FileInputStream(filename);
        ObjectInputStream s = new ObjectInputStream(in);
        object = s.readObject();
        in.close();
        s.close();
        return object;
    }
}

