/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.scoring;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.list.BalloonSettingsComparatorbySite;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.list.RunComparatorByTeam;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.scoring.DefaultStandingsRecordComparator;
import edu.csus.ecs.pc2.core.scoring.IScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.ProblemSummaryInfo;
import edu.csus.ecs.pc2.core.scoring.StandingsRecord;
import edu.csus.ecs.pc2.core.scoring.SummaryRow;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScoringAlgorithm
implements IScoringAlgorithm {
    private static final long serialVersionUID = -2471349413867745412L;
    public static final String SVN_ID = "$Id: DefaultScoringAlgorithm.java 1857 2009-04-10 05:12:32Z boudreat $";
    private static final String POINTS_PER_NO = "Points per No";
    private static final String POINTS_PER_YES_MINUTE = "Points per Minute (for 1st yes)";
    private static final String BASE_POINTS_PER_YES = "Base Points per Yes";
    private String[][] propList = new String[][]{{"Points per No", "20:Integer"}, {"Points per Minute (for 1st yes)", "1:Integer"}, {"Base Points per Yes", "0:Integer"}};
    private Properties props = new Properties();
    private Object mutex = new Object();
    private int grandTotalAttempts;
    private int grandTotalSolutions;
    private int grandTotalProblemAttempts;
    private int[] problemBestTime = null;
    private int[] problemLastTime = null;
    private int[] problemSolutions = null;
    private int[] problemAttempts = null;
    private Log log;
    private boolean countPreliminaryJudgements = false;
    private PermissionList permissionList = new PermissionList();
    private boolean respectSendToTeam = false;
    private boolean respectEOC = false;

    public DefaultScoringAlgorithm() {
        int i = 0;
        while (i < this.propList.length) {
            String key = this.propList[i][0];
            String value = this.propList[i][1];
            int colon = value.indexOf(":");
            String defaultValue = value.substring(0, colon);
            this.props.put(key, defaultValue);
            ++i;
        }
    }

    AccountList getAccountList(IInternalContest theContest) {
        Vector<Account> accountVect = theContest.getAccounts(ClientType.Type.ALL);
        AccountList accountList = new AccountList();
        Enumeration<Account> accountEnum = accountVect.elements();
        while (accountEnum.hasMoreElements()) {
            Account a = accountEnum.nextElement();
            accountList.add(a);
        }
        return accountList;
    }

    private ProblemSummaryInfo calcProblemScoreData(TreeMap<Run, Run> treeMap) throws IllegalContestState {
        ProblemSummaryInfo problemSummaryInfo = new ProblemSummaryInfo();
        int score = 0;
        int attempts = 0;
        ElementId problemId = null;
        long solutionTime = -1L;
        boolean solved = false;
        boolean unJudgedRun = false;
        if (treeMap.isEmpty()) {
            problemSummaryInfo = null;
        } else {
            Collection<Run> coll = treeMap.values();
            Object[] o = coll.toArray();
            int i = 0;
            while (i < o.length) {
                Run run = (Run)o[i];
                if (!run.isDeleted()) {
                    ++attempts;
                    problemId = run.getProblemId();
                    if (run.isSolved() && this.isValidJudgement(run)) {
                        solved = true;
                        solutionTime = run.getElapsedMins();
                        score = (int)((long)score + (solutionTime * (long)this.getPenaltyPointsPerYesMinute() + (long)this.getBasePointsPerYes()));
                        break;
                    }
                    if (this.isValidJudgement(run)) {
                        score += this.getPenaltyPointsPerNo();
                    } else {
                        unJudgedRun = true;
                    }
                }
                ++i;
            }
        }
        if (!solved) {
            score = 0;
        }
        problemSummaryInfo.setSolved(solved);
        problemSummaryInfo.setSolutionTime(solutionTime);
        problemSummaryInfo.setProblemId(problemId);
        problemSummaryInfo.setNumberSubmitted(attempts);
        problemSummaryInfo.setPenaltyPoints(score);
        problemSummaryInfo.setUnJudgedRuns(unJudgedRun);
        return problemSummaryInfo;
    }

    private int getPropIntValue(String key) {
        String s = this.props.getProperty(key);
        Integer i = Integer.parseInt(s);
        return i;
    }

    private int getBasePointsPerYes() {
        return this.getPropIntValue(BASE_POINTS_PER_YES);
    }

    private int getPenaltyPointsPerNo() {
        return this.getPropIntValue(POINTS_PER_NO);
    }

    private int getPenaltyPointsPerYesMinute() {
        return this.getPropIntValue(POINTS_PER_YES_MINUTE);
    }

    public Properties getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStandings(IInternalContest theContest, Properties properties, Log inputLog) throws IllegalContestState {
        String xmlString;
        BalloonSettings[] balloonSettings;
        if (theContest == null) {
            throw new InvalidParameterException("Invalid model (null)");
        }
        if (properties == null) {
            throw new InvalidParameterException("Invalid properties (null)");
        }
        if (properties.isEmpty()) {
            properties = this.getProperties();
        }
        this.log = inputLog;
        this.props = properties;
        this.respectSendToTeam = this.isAllowed(theContest, theContest.getClientId(), Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        this.respectEOC = this.isAllowed(theContest, theContest.getClientId(), Permission.Type.RESPECT_EOC_SUPPRESSION);
        this.countPreliminaryJudgements = theContest.getContestInformation().isPreliminaryJudgementsUsedByBoard();
        XMLMemento mementoRoot = XMLMemento.createWriteRoot("contestStandings");
        IMemento summaryMememento = this.createSummaryMomento(theContest.getContestInformation(), mementoRoot);
        AccountList accountList = this.getAccountList(theContest);
        Problem[] problems = theContest.getProblems();
        summaryMememento.putLong("problemCount", problems.length);
        Site[] sites = theContest.getSites();
        summaryMememento.putInteger("siteCount", sites.length);
        Group[] groups = theContest.getGroups();
        if (groups != null) {
            this.dumpGroupList(groups, summaryMememento);
        }
        if ((balloonSettings = theContest.getBalloonSettings()) != null) {
            Arrays.sort(balloonSettings, new BalloonSettingsComparatorbySite());
            IMemento listMemento = summaryMememento.createChild("colorList");
            int i = 0;
            while (i < balloonSettings.length) {
                int id = i + 1;
                IMemento balloonSettingsMemento = listMemento.createChild("colors");
                balloonSettingsMemento.putInteger("id", id);
                this.dumpBalloonSettings(balloonSettings[i], problems, balloonSettingsMemento);
                ++i;
            }
        }
        Hashtable<ElementId, Integer> problemsIndexHash = new Hashtable<ElementId, Integer>();
        int p = 1;
        while (p <= problems.length) {
            problemsIndexHash.put(problems[p - 1].getElementId(), new Integer(p));
            ++p;
        }
        Run[] runs = theContest.getRuns();
        Object id = this.mutex;
        synchronized (id) {
            Account[] accounts = accountList.getList();
            Hashtable<String, StandingsRecord> standingsRecordHash = new Hashtable<String, StandingsRecord>();
            RunComparatorByTeam runComparatorByTeam = new RunComparatorByTeam();
            TreeMap<Run, Run> runTreeMap = new TreeMap<Run, Run>(runComparatorByTeam);
            Hashtable<String, Problem> problemHash = new Hashtable<String, Problem>();
            int i = 0;
            while (i < problems.length) {
                Problem problem = problems[i];
                if (problem.isActive()) {
                    problemHash.put(problem.getElementId().toString(), problem);
                }
                ++i;
            }
            this.initializeStandingsRecordHash(accountList, accounts, problems, standingsRecordHash);
            i = 0;
            while (i < runs.length) {
                Account account = accountList.getAccount(runs[i].getSubmitter());
                if (account == null) {
                    this.log.info("account could not be located for " + runs[i].getSubmitter());
                } else if (!runs[i].isDeleted() && account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD) && problemHash.containsKey(runs[i].getProblemId().toString())) {
                    Run runToAdd = runs[i];
                    if (this.respectSendToTeam && runToAdd.getAllJudgementRecords().length > 0 && !runToAdd.getJudgementRecord().isSendToTeam()) {
                        runToAdd = RunUtilities.createNewRun(runs[i], theContest);
                    }
                    JudgementNotificationsList judgementNotificationsList = theContest.getContestInformation().getJudgementNotificationsList();
                    ContestTime contestTime = theContest.getContestTime();
                    if (this.respectEOC && RunUtilities.supppressJudgement(judgementNotificationsList, runs[i], contestTime)) {
                        runToAdd = RunUtilities.createNewRun(runs[i], theContest);
                    }
                    runTreeMap.put(runToAdd, runToAdd);
                }
                ++i;
            }
            if (!runTreeMap.isEmpty()) {
                this.generateStandingsValues(runTreeMap, standingsRecordHash, problemsIndexHash);
            }
            DefaultStandingsRecordComparator src = new DefaultStandingsRecordComparator();
            src.setCachedAccountList(accountList);
            TreeMap<StandingsRecord, StandingsRecord> treeMap = new TreeMap<StandingsRecord, StandingsRecord>(src);
            Collection<StandingsRecord> enumeration = standingsRecordHash.values();
            for (StandingsRecord record : enumeration) {
                treeMap.put(record, record);
            }
            this.createStandingXML(treeMap, mementoRoot, accountList, problems, problemsIndexHash, groups, summaryMememento);
        }
        try {
            xmlString = mementoRoot.saveToString();
        }
        catch (IOException e) {
            this.log.log(Log.WARNING, "Trouble saving momentoRoot to String ", e);
            xmlString = "";
        }
        return xmlString;
    }

    private void initializePermissions(IInternalContest theContest, ClientId clientId) {
        Account account = theContest.getAccount(clientId);
        if (account != null) {
            this.permissionList.clearAndLoadPermissions(account.getPermissionList());
        } else {
            this.permissionList.clearAndLoadPermissions(new PermissionGroup().getPermissionList(clientId.getClientType()));
        }
    }

    private boolean isAllowed(IInternalContest theContest, ClientId clientId, Permission.Type type) {
        this.initializePermissions(theContest, clientId);
        return this.permissionList.isAllowed(type);
    }

    private void dumpBalloonSettings(BalloonSettings balloonSettings, Problem[] problems, IMemento memento) {
        memento.putInteger("siteNum", balloonSettings.getSiteNumber());
        if (problems != null) {
            int i = 0;
            while (i < problems.length) {
                int id = i + 1;
                IMemento problemMemento = memento.createChild("problem");
                problemMemento.putInteger("id", id);
                problemMemento.putString("color", balloonSettings.getColor(problems[i]));
                ++i;
            }
        }
    }

    private void dumpGroupList(Group[] groups, IMemento memento) {
        memento.putInteger("groupCount", groups.length + 1);
        IMemento groupsMemento = memento.createChild("groupList");
        int id = 0;
        int i = 0;
        while (i < groups.length) {
            if (groups[i].isDisplayOnScoreboard()) {
                IMemento groupMemento = groupsMemento.createChild("group");
                groupMemento.putInteger("id", ++id);
                groupMemento.putString("title", groups[i].getDisplayName());
                groupMemento.putInteger("externalId", groups[i].getGroupId());
                if (groups[i].getSite() != null) {
                    groupMemento.putInteger("pc2Site", groups[i].getSite().getSiteNumber());
                }
            }
            ++i;
        }
    }

    private void createStandingXML(TreeMap<StandingsRecord, StandingsRecord> treeMap, XMLMemento mementoRoot, AccountList accountList, Problem[] problems, Hashtable<ElementId, Integer> problemsIndexHash, Group[] groups, IMemento summaryMememento) {
        Hashtable<ElementId, Group> groupHash = new Hashtable<ElementId, Group>();
        Hashtable<Group, Integer> groupIndexHash = new Hashtable<Group, Integer>();
        int groupCount = 0;
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            if (group.isDisplayOnScoreboard()) {
                groupHash.put(group.getElementId(), group);
                groupIndexHash.put(group, groupCount);
                ++groupCount;
            }
            ++n2;
        }
        StandingsRecord[] srArray = new StandingsRecord[treeMap.size()];
        Collection<StandingsRecord> coll = treeMap.values();
        Iterator<StandingsRecord> iterator = coll.iterator();
        this.problemBestTime = new int[problems.length + 1];
        this.problemLastTime = new int[problems.length + 1];
        this.problemSolutions = new int[problems.length + 1];
        this.problemAttempts = new int[problems.length + 1];
        int p = 1;
        while (p <= problems.length) {
            this.problemBestTime[p] = -1;
            ++p;
        }
        this.grandTotalAttempts = 0;
        this.grandTotalSolutions = 0;
        this.grandTotalProblemAttempts = 0;
        long numSolved = -1L;
        long score = 0L;
        long lastSolved = 0L;
        int rank = 0;
        int indexRank = 0;
        int index = 0;
        long[] groupNumSolved = new long[groupCount];
        int i = 0;
        while (i < groupNumSolved.length) {
            groupNumSolved[i] = -1L;
            ++i;
        }
        long[] groupScore = new long[groupCount];
        long[] groupLastSolved = new long[groupCount];
        int[] groupRank = new int[groupCount];
        int[] groupIndexRank = new int[groupCount];
        int i2 = 0;
        while (i2 < groupIndexRank.length) {
            groupScore[i2] = 0L;
            groupLastSolved[i2] = 0L;
            groupRank[i2] = 0;
            groupIndexRank[i2] = 0;
            ++i2;
        }
        while (iterator.hasNext()) {
            StandingsRecord o;
            StandingsRecord standingsRecord = o = iterator.next();
            ++indexRank;
            if (!this.isTeamTied(standingsRecord, numSolved, score, lastSolved)) {
                numSolved = standingsRecord.getNumberSolved();
                score = standingsRecord.getPenaltyPoints();
                lastSolved = standingsRecord.getLastSolved();
                rank = indexRank;
                standingsRecord.setRankNumber(rank);
            } else {
                standingsRecord.setRankNumber(rank);
            }
            long totalAttempts = 0L;
            long problemsAttempted = 0L;
            IMemento standingsRecordMemento = mementoRoot.createChild("teamStanding");
            standingsRecordMemento.putLong("firstSolved", standingsRecord.getFirstSolved());
            standingsRecordMemento.putLong("lastSolved", standingsRecord.getLastSolved());
            standingsRecordMemento.putLong("points", standingsRecord.getPenaltyPoints());
            standingsRecordMemento.putInteger("solved", standingsRecord.getNumberSolved());
            standingsRecordMemento.putInteger("rank", standingsRecord.getRankNumber());
            standingsRecordMemento.putInteger("index", index);
            Account account = accountList.getAccount(standingsRecord.getClientId());
            standingsRecordMemento.putString("teamName", account.getDisplayName());
            standingsRecordMemento.putInteger("teamId", account.getClientId().getClientNumber());
            standingsRecordMemento.putInteger("teamSiteId", account.getClientId().getSiteNumber());
            standingsRecordMemento.putString("teamKey", account.getClientId().getTripletKey());
            standingsRecordMemento.putString("teamExternalId", account.getExternalId());
            if (account.getAliasName().trim().equals("")) {
                standingsRecordMemento.putString("teamAlias", String.valueOf(account.getDisplayName()) + " (not aliasesd)");
            } else {
                standingsRecordMemento.putString("teamAlias", account.getAliasName().trim());
            }
            Group group = null;
            if (account.getGroupId() != null) {
                group = (Group)groupHash.get(account.getGroupId());
            }
            if (group != null) {
                int groupIndex;
                int n3 = groupIndex = ((Integer)groupIndexHash.get(group)).intValue();
                groupIndexRank[n3] = groupIndexRank[n3] + 1;
                if (!this.isTeamTied(standingsRecord, groupNumSolved[groupIndex], groupScore[groupIndex], groupLastSolved[groupIndex])) {
                    groupNumSolved[groupIndex] = standingsRecord.getNumberSolved();
                    groupScore[groupIndex] = standingsRecord.getPenaltyPoints();
                    groupLastSolved[groupIndex] = standingsRecord.getLastSolved();
                    groupRank[groupIndex] = groupIndexRank[groupIndex];
                    standingsRecord.setGroupRankNumber(groupRank[groupIndex]);
                } else {
                    standingsRecord.setGroupRankNumber(groupRank[groupIndex]);
                }
                standingsRecordMemento.putInteger("groupRank", standingsRecord.getGroupRankNumber());
                standingsRecordMemento.putString("teamGroupName", group.getDisplayName());
                standingsRecordMemento.putInteger("teamGroupId", groupIndex + 1);
                standingsRecordMemento.putInteger("teamGroupExternalId", group.getGroupId());
            }
            SummaryRow summaryRow = standingsRecord.getSummaryRow();
            int i3 = 0;
            while (i3 < problems.length) {
                int id = i3 + 1;
                ProblemSummaryInfo psi = summaryRow.get(id);
                if (psi == null) {
                    this.log.log(Log.WARNING, "ProblemSummaryInfo not generated/found for problem " + id + " " + problems[i3]);
                    System.out.println("error or normal? ProblemSummaryInfo not found for problem " + id);
                } else {
                    IMemento psiMemento = standingsRecordMemento.createChild("problemSummaryInfo");
                    psiMemento.putInteger("index", problemsIndexHash.get(psi.getProblemId()));
                    psiMemento.putString("problemId", psi.getProblemId().toString());
                    psiMemento.putInteger("attempts", psi.getNumberSubmitted());
                    psiMemento.putInteger("points", psi.getPenaltyPoints());
                    psiMemento.putLong("solutionTime", psi.getSolutionTime());
                    psiMemento.putBoolean("isSolved", psi.isSolved());
                    psiMemento.putBoolean("isPending", psi.isUnJudgedRuns());
                    int n4 = id;
                    this.problemAttempts[n4] = this.problemAttempts[n4] + psi.getNumberSubmitted();
                    totalAttempts += (long)psi.getNumberSubmitted();
                    this.grandTotalAttempts += psi.getNumberSubmitted();
                    if (psi.getNumberSubmitted() > 0) {
                        ++problemsAttempted;
                    }
                    if (psi.isSolved()) {
                        int n5 = id;
                        this.problemSolutions[n5] = this.problemSolutions[n5] + 1;
                        ++this.grandTotalSolutions;
                        if (psi.getSolutionTime() > (long)this.problemLastTime[id]) {
                            this.problemLastTime[id] = new Long(psi.getSolutionTime()).intValue();
                        }
                        if (this.problemBestTime[id] < 0 || psi.getSolutionTime() < (long)this.problemBestTime[id]) {
                            this.problemBestTime[id] = new Long(psi.getSolutionTime()).intValue();
                        }
                    }
                }
                ++i3;
            }
            standingsRecordMemento.putLong("totalAttempts", totalAttempts);
            standingsRecordMemento.putLong("problemsAttempted", problemsAttempted);
            srArray[index++] = standingsRecord;
        }
        summaryMememento.putInteger("medianProblemsSolved", this.getMedian(srArray));
        this.generateSummaryTotalsForProblem(problems, problemsIndexHash, summaryMememento);
    }

    private int getMedian(StandingsRecord[] srArray) {
        int median;
        if (srArray == null || srArray.length == 0) {
            median = 0;
        } else if (srArray.length == 1) {
            median = srArray[0].getNumberSolved();
        } else if (srArray.length % 2 == 0) {
            int low = srArray[srArray.length / 2 - 1].getNumberSolved();
            int high = srArray[(srArray.length + 1) / 2].getNumberSolved();
            median = (low + high) / 2;
        } else {
            median = srArray[(srArray.length + 1) / 2 - 1].getNumberSolved();
        }
        return median;
    }

    boolean isValidJudgement(Run run) {
        boolean result = false;
        if (run.getStatus().equals((Object)Run.RunStates.JUDGED)) {
            result = true;
        } else if (run.getJudgementRecord() != null) {
            if (run.getJudgementRecord().isPreliminaryJudgement()) {
                if (this.countPreliminaryJudgements) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    boolean isTeamTied(StandingsRecord standingsRecord, long numSolved, long score, long lastSolved) {
        if (numSolved != (long)standingsRecord.getNumberSolved()) {
            return false;
        }
        if (score != standingsRecord.getPenaltyPoints()) {
            return false;
        }
        return lastSolved == standingsRecord.getLastSolved();
    }

    private void generateSummaryTotalsForProblem(Problem[] problems, Hashtable<ElementId, Integer> problemsIndexHash, IMemento summaryMememento) {
        int i = 0;
        while (i < problems.length) {
            int id = i + 1;
            problemsIndexHash.put(problems[i].getElementId(), new Integer(id));
            IMemento problemMemento = summaryMememento.createChild("problem");
            problemMemento.putInteger("id", id);
            problemMemento.putString("title", problems[i].getDisplayName());
            problemMemento.putLong("attempts", this.problemAttempts[id]);
            if (this.problemAttempts[id] > 0) {
                ++this.grandTotalProblemAttempts;
            }
            problemMemento.putLong("numberSolved", this.problemSolutions[id]);
            if (this.problemSolutions[id] > 0) {
                problemMemento.putLong("bestSolutionTime", this.problemBestTime[id]);
                problemMemento.putLong("lastSolutionTime", this.problemLastTime[id]);
            }
            ++i;
        }
        summaryMememento.putInteger("totalAttempts", this.grandTotalAttempts);
        summaryMememento.putInteger("totalSolved", this.grandTotalSolutions);
        summaryMememento.putInteger("problemsAttempted", this.grandTotalProblemAttempts);
    }

    private void generateStandingsValues(TreeMap<Run, Run> runTreeMap, Hashtable<String, StandingsRecord> standingsHash, Hashtable<ElementId, Integer> problemsHash) throws IllegalContestState {
        long oldTime = 0L;
        long youngTime = -1L;
        RunComparatorByTeam runComparatorByTeam = new RunComparatorByTeam();
        TreeMap<Run, Run> problemTreeMap = new TreeMap<Run, Run>(runComparatorByTeam);
        Collection<Run> runColl = runTreeMap.values();
        Iterator<Run> runIterator = runColl.iterator();
        String lastUser = "";
        String lastProblem = "";
        while (runIterator.hasNext()) {
            Run o = runIterator.next();
            Run run = o;
            if (!lastUser.equals(run.getSubmitter().toString()) || !lastProblem.equals(run.getProblemId().toString())) {
                if (!problemTreeMap.isEmpty()) {
                    ProblemSummaryInfo problemSummaryInfo = this.calcProblemScoreData(problemTreeMap);
                    StandingsRecord standingsRecord = standingsHash.get(lastUser);
                    SummaryRow summaryRow = standingsRecord.getSummaryRow();
                    summaryRow.put(problemsHash.get(problemSummaryInfo.getProblemId()), problemSummaryInfo);
                    standingsRecord.setSummaryRow(summaryRow);
                    standingsRecord.setPenaltyPoints(standingsRecord.getPenaltyPoints() + (long)problemSummaryInfo.getPenaltyPoints());
                    if (problemSummaryInfo.isSolved()) {
                        standingsRecord.setNumberSolved(standingsRecord.getNumberSolved() + 1);
                        oldTime = standingsRecord.getLastSolved();
                        youngTime = standingsRecord.getFirstSolved();
                        if (problemSummaryInfo.getSolutionTime() > oldTime) {
                            standingsRecord.setLastSolved(problemSummaryInfo.getSolutionTime());
                        }
                        if (youngTime < 0L || problemSummaryInfo.getSolutionTime() < youngTime) {
                            standingsRecord.setFirstSolved(problemSummaryInfo.getSolutionTime());
                        }
                    }
                    standingsHash.put(lastUser, standingsRecord);
                    problemTreeMap.clear();
                }
                lastUser = run.getSubmitter().toString();
                lastProblem = run.getProblemId().toString();
            }
            problemTreeMap.put(run, run);
        }
        if (!problemTreeMap.isEmpty()) {
            ProblemSummaryInfo problemSummaryInfo = this.calcProblemScoreData(problemTreeMap);
            StandingsRecord standingsRecord = standingsHash.get(lastUser);
            SummaryRow summaryRow = standingsRecord.getSummaryRow();
            summaryRow.put(problemsHash.get(problemSummaryInfo.getProblemId()), problemSummaryInfo);
            standingsRecord.setSummaryRow(summaryRow);
            standingsRecord.setPenaltyPoints(standingsRecord.getPenaltyPoints() + (long)problemSummaryInfo.getPenaltyPoints());
            if (problemSummaryInfo.isSolved()) {
                standingsRecord.setNumberSolved(standingsRecord.getNumberSolved() + 1);
                oldTime = standingsRecord.getLastSolved();
                youngTime = standingsRecord.getFirstSolved();
                if (problemSummaryInfo.getSolutionTime() > oldTime) {
                    standingsRecord.setLastSolved(problemSummaryInfo.getSolutionTime());
                }
                if (youngTime < 0L || problemSummaryInfo.getSolutionTime() < youngTime) {
                    standingsRecord.setFirstSolved(problemSummaryInfo.getSolutionTime());
                }
            }
            standingsHash.put(lastUser, standingsRecord);
        }
        problemTreeMap.clear();
        problemTreeMap = null;
    }

    private void initializeStandingsRecordHash(AccountList accountList, Account[] accounts, Problem[] problems, Hashtable<String, StandingsRecord> standingsRecordHash) {
        int i = 0;
        while (i < accountList.size()) {
            Account account = accounts[i];
            if (account.getClientId().getClientType() == ClientType.Type.TEAM && account.isAllowed(Permission.Type.DISPLAY_ON_SCOREBOARD)) {
                StandingsRecord standingsRecord = new StandingsRecord();
                SummaryRow summaryRow = standingsRecord.getSummaryRow();
                int j = 0;
                while (j < problems.length) {
                    ProblemSummaryInfo problemSummaryInfo = new ProblemSummaryInfo();
                    problemSummaryInfo.setProblemId(problems[j].getElementId());
                    problemSummaryInfo.setPenaltyPoints(0);
                    summaryRow.put(j + 1, problemSummaryInfo);
                    ++j;
                }
                standingsRecord.setSummaryRow(summaryRow);
                standingsRecord.setClientId(account.getClientId());
                standingsRecordHash.put(account.getClientId().toString(), standingsRecord);
            }
            ++i;
        }
    }

    private IMemento createSummaryMomento(ContestInformation contestInformation, XMLMemento mementoRoot) {
        IMemento memento = mementoRoot.createChild("standingsHeader");
        String title = contestInformation.getContestTitle();
        if (title == null || title.length() == 0) {
            title = "Contest";
        }
        memento.putString("title", title);
        VersionInfo versionInfo = new VersionInfo();
        memento.putString("systemName", versionInfo.getSystemName());
        memento.putString("systemVersion", String.valueOf(versionInfo.getVersionNumber()) + " build " + versionInfo.getBuildNumber());
        memento.putString("systemURL", versionInfo.getSystemURL());
        memento.putString("currentDate", new Date().toString());
        memento.putString("generatorId", SVN_ID);
        return memento;
    }
}

