/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StandingsReport
implements IReport {
    private static final long serialVersionUID = -914245980900707408L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    void formatXML(PrintWriter printWriter, String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
        this.formatDocument(printWriter, document);
    }

    public void writeReport(PrintWriter printWriter) throws ParserConfigurationException, SAXException, IOException, IllegalContestState {
        printWriter.println();
        DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
        String xmlString = defaultScoringAlgorithm.getStandings(this.contest, new Properties(), this.controller.getLog());
        printWriter.println(xmlString);
        printWriter.println();
        this.formatXML(printWriter, xmlString);
        printWriter.println();
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
        try {
            return defaultScoringAlgorithm.getStandings(this.contest, new Properties(), this.controller.getLog());
        }
        catch (IllegalContestState e) {
            e.printStackTrace();
            return "Exception in report: " + e.getMessage();
        }
    }

    public String getReportTitle() {
        return "Standings XML ";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Standings XML Report";
    }

    public void formatDocument(PrintWriter printWriter, Document doc) {
        this.formatLoop(printWriter, doc, "");
    }

    private void formatLoop(PrintWriter printWriter, Node node, String indent) {
        String name = node.getNodeName();
        String prefix = String.valueOf(indent) + " " + name + " ";
        switch (node.getNodeType()) {
            case 4: {
                printWriter.println(String.valueOf(prefix) + "CDATA_SECTION_NODE");
                break;
            }
            case 8: {
                printWriter.println(String.valueOf(prefix) + "COMMENT_NODE");
                break;
            }
            case 11: {
                printWriter.println(String.valueOf(prefix) + "DOCUMENT_FRAGMENT_NODE");
                break;
            }
            case 9: {
                printWriter.println(String.valueOf(prefix) + "DOCUMENT_NODE");
                break;
            }
            case 10: {
                printWriter.println(String.valueOf(prefix) + "DOCUMENT_TYPE_NODE");
                break;
            }
            case 1: {
                printWriter.println(String.valueOf(prefix) + "ELEMENT_NODE");
                break;
            }
            case 6: {
                printWriter.println(String.valueOf(prefix) + "ENTITY_NODE");
                break;
            }
            case 5: {
                printWriter.println(String.valueOf(prefix) + "ENTITY_REFERENCE_NODE");
                break;
            }
            case 12: {
                printWriter.println(String.valueOf(prefix) + "NOTATION_NODE");
                break;
            }
            case 7: {
                printWriter.println(String.valueOf(prefix) + "PROCESSING_INSTRUCTION_NODE");
                break;
            }
            case 3: {
                printWriter.println(String.valueOf(prefix) + "TEXT_NODE");
                break;
            }
            default: {
                printWriter.println(String.valueOf(prefix) + "Unknown node");
            }
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            this.formatLoop(printWriter, list.item(i), String.valueOf(indent) + "   ");
            ++i;
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

