/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class SiteListReport
implements IReport {
    private static final long serialVersionUID = 7194244117875846407L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Site[] sites = this.contest.getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        printWriter.println("# -- " + sites.length + " sites --");
        Site[] siteArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            printWriter.print(site.getSiteNumber());
            printWriter.print("|");
            printWriter.print(site.getDisplayName());
            printWriter.print("|");
            printWriter.print(site.getPassword());
            printWriter.print("|");
            printWriter.print(site.getConnectionInfo().getProperty("IP_KEY"));
            printWriter.print("|");
            printWriter.print(site.getConnectionInfo().getProperty("PORT_KEY"));
            printWriter.print("|");
            printWriter.print(site.getElementId());
            printWriter.print("|");
            ++n2;
        }
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println("# " + new VersionInfo().getSystemName());
        printWriter.println("# Date: " + Utilities.getL10nDateTime());
        printWriter.println("# " + new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println("# " + this.getReportTitle() + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("# end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Site List";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Site List Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

