/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class ProblemsReport
implements IReport {
    private static final long serialVersionUID = 977130815676827828L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    private void writeRow(PrintWriter printWriter, Problem problem, ProblemDataFiles problemDataFiles) {
        printWriter.println("  Problem '" + problem + "' ver=" + problem.getElementId().getVersionNumber() + " id=" + problem.getElementId());
        printWriter.println("       Data file name   : " + problem.getDataFileName());
        printWriter.println("       Answer file name : " + problem.getAnswerFileName());
        printWriter.print("   Execution time limit : " + problem.getTimeOutInSeconds() + " seconds");
        if (problem.getTimeOutInSeconds() == 0) {
            printWriter.print(" (no time limit when zero seconds)");
        }
        printWriter.println();
        printWriter.println("        Using validator : " + problem.isValidatedProblem());
        printWriter.println("         Validator name : " + problem.getValidatorProgramName());
        printWriter.println("     Validator cmd line : " + problem.getValidatorCommandLine());
        printWriter.println("     Validator option # : " + problem.getWhichPC2Validator());
        printWriter.println("    Using pc2 validator : " + problem.isUsingPC2Validator());
        if (problem.getAnswerFileName() != null) {
            if (problemDataFiles != null) {
                if (problemDataFiles.getJudgesAnswerFiles().length == 0) {
                    printWriter.println("                          Warning - no answer files defined (no contents) ");
                }
            } else {
                printWriter.println("                          Warning - no data/answer files defined (null problemDataFiles) ");
            }
        }
        if (problem.getAnswerFileName() != null) {
            if (problemDataFiles != null) {
                if (problemDataFiles.getJudgesDataFiles().length == 0) {
                    printWriter.println("                          Warning - no judges data files defined (no contents) ");
                }
            } else {
                printWriter.println("                          Warning - no data/judge files defined (null problemDataFiles) ");
            }
        }
        this.writeProblemDataFiles(printWriter, problemDataFiles);
    }

    private void writeProblemDataFiles(PrintWriter printWriter, ProblemDataFiles problemDataFiles) {
        if (problemDataFiles != null) {
            int bytes;
            SerializedFile serializedFile;
            int n;
            int n2;
            SerializedFile[] serializedFileArray;
            SerializedFile[] judgesDataFiles = problemDataFiles.getJudgesDataFiles();
            SerializedFile[] judgesAnswerFiles = problemDataFiles.getJudgesAnswerFiles();
            SerializedFile validatorFile = problemDataFiles.getValidatorFile();
            if (judgesDataFiles != null) {
                printWriter.println("                  " + judgesDataFiles.length + " judge data files");
                if (judgesDataFiles.length > 0) {
                    serializedFileArray = judgesDataFiles;
                    n2 = judgesDataFiles.length;
                    n = 0;
                    while (n < n2) {
                        serializedFile = serializedFileArray[n];
                        bytes = 0;
                        if (serializedFile.getBuffer() != null) {
                            bytes = serializedFile.getBuffer().length;
                        }
                        printWriter.println("                    judge data file '" + serializedFile.getName() + "' " + bytes + " bytes");
                        ++n;
                    }
                }
            } else {
                printWriter.println("                  * No judge's data files *");
            }
            if (judgesAnswerFiles != null) {
                printWriter.println("                  " + judgesAnswerFiles.length + " judge answer files");
                if (judgesAnswerFiles.length > 0) {
                    serializedFileArray = judgesAnswerFiles;
                    n2 = judgesAnswerFiles.length;
                    n = 0;
                    while (n < n2) {
                        serializedFile = serializedFileArray[n];
                        bytes = 0;
                        if (serializedFile.getBuffer() != null) {
                            bytes = serializedFile.getBuffer().length;
                        }
                        printWriter.println("                    judge ans. file '" + serializedFile.getName() + "' " + bytes + " bytes");
                        ++n;
                    }
                }
            } else {
                printWriter.println("                  * No judge's answer files *");
            }
            if (validatorFile != null) {
                printWriter.println("                  1 validator file");
                int bytes2 = 0;
                if (validatorFile.getBuffer() != null) {
                    bytes2 = validatorFile.getBuffer().length;
                }
                printWriter.println("                    validator file '" + validatorFile.getName() + "' " + bytes2 + " bytes");
            } else {
                printWriter.println("                  * No validator files *");
            }
        } else {
            printWriter.println("                  * No judge's files *");
        }
    }

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblems().length + " problems --");
        IElementObject[] iElementObjectArray = this.contest.getProblems();
        int n = iElementObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = iElementObjectArray[n2];
            printWriter.println();
            ProblemDataFiles problemDataFiles = this.contest.getProblemDataFile(problem);
            this.writeRow(printWriter, problem, problemDataFiles);
            ++n2;
        }
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblemDataFiles().length + " problem data file sets --");
        iElementObjectArray = this.contest.getProblemDataFiles();
        n = iElementObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IElementObject problemDataFile = iElementObjectArray[n2];
            printWriter.println();
            Problem problem = this.contest.getProblem(((ProblemDataFiles)problemDataFile).getProblemId());
            printWriter.println("  Problem Data File set for " + problem + " id=" + ((ProblemDataFiles)problemDataFile).getProblemId());
            this.writeProblemDataFiles(printWriter, (ProblemDataFiles)problemDataFile);
            ++n2;
        }
        if (this.contest.getGeneralProblem() == null) {
            printWriter.println(" General Problem: (not defined) ");
        } else {
            printWriter.println(" General Problem: " + this.contest.getGeneralProblem().getElementId());
        }
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Problems";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Problems Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

