/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;

public class OldRunsReport
implements IReport {
    private static final long serialVersionUID = 2758681678568110981L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    private void writeRow(PrintWriter printWriter, Run run) {
        ClientId clientId = run.getSubmitter();
        printWriter.print("run " + run.getNumber() + "|");
        printWriter.print("site " + run.getSiteNumber() + "|");
        printWriter.print("proxy |");
        printWriter.print("team " + clientId.getClientNumber() + "|");
        printWriter.print(String.valueOf(clientId.getName()) + ":" + this.getClientName(clientId) + "|");
        printWriter.print("prob " + run.getProblemId() + ":" + this.contest.getProblem(run.getProblemId()) + "|");
        printWriter.print("lang " + run.getLanguageId() + ":" + this.contest.getLanguage(run.getLanguageId()) + "|");
        printWriter.print("tocj |");
        printWriter.print("os " + run.getSystemOS() + "|");
        printWriter.print("sel " + run.getStatus().equals((Object)Run.RunStates.BEING_JUDGED) + "|");
        printWriter.print("tocj false|");
        printWriter.print("jc " + run.isJudged() + "|");
        printWriter.print(String.valueOf(run.getElapsedMins()) + "|");
        printWriter.print("rid " + run.getElementId() + "|");
        printWriter.print("mmfr " + run.isSolved() + "|");
        printWriter.print("del? " + run.isDeleted() + "|");
        String jciString = "";
        String jbyString = "";
        String jtString = "";
        if (run.isJudged()) {
            JudgementRecord judgementRecord = run.getJudgementRecord();
            jbyString = judgementRecord.getJudgerClientId().getName();
            jtString = new Long(judgementRecord.getJudgedMinutes()).toString();
            ElementId elementId = judgementRecord.getJudgementId();
            jciString = "??";
            if (elementId != null) {
                Judgement judgement = this.contest.getJudgement(elementId);
                if (judgement != null) {
                    jciString = judgement.toString();
                } else {
                    System.err.println(" Run " + run + " judgement not found for judgement id " + elementId);
                }
            }
            String validatorJudgementName = judgementRecord.getValidatorResultString();
            if (judgementRecord.isUsedValidator() && validatorJudgementName != null) {
                if (validatorJudgementName.trim().length() == 0) {
                    validatorJudgementName = "undetermined";
                }
                jciString = validatorJudgementName;
            }
        }
        printWriter.print("jt " + jtString + "|");
        printWriter.print("jby " + jbyString + "|");
        printWriter.print("jci " + jciString + "|");
        printWriter.println();
    }

    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        printWriter.println("-- " + runs.length + " runs --");
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            this.writeRow(printWriter, run);
            ++n2;
        }
    }

    private String getClientName(ClientId clientId) {
        Account account = this.contest.getAccount(clientId);
        if (account != null) {
            return account.getDisplayName();
        }
        return clientId.getName();
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + new Date());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Runs (Version 8 content and format)";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Runs Report (Version 8)";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

