/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.SummaryCounts;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;

public class ListRunLanguages
implements IReport {
    private static final long serialVersionUID = 1389857029019327047L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Hashtable<ElementId, Integer> langLookup = new Hashtable();
    private Filter filter = new Filter();

    protected void printClientsShort(PrintWriter printWriter, ClientId[] clientIds) {
        ClientId clientId = null;
        int i = 0;
        while (i < clientIds.length - 1) {
            clientId = clientIds[i];
            printWriter.print(String.valueOf(clientId.getClientNumber()) + "s" + clientId.getSiteNumber() + ",");
            ++i;
        }
        clientId = clientIds[clientIds.length - 1];
        printWriter.print(String.valueOf(clientId.getClientNumber()) + "s" + clientId.getSiteNumber() + ".");
    }

    protected void printClients(PrintWriter printWriter, ClientId[] clientIds) {
        ClientId clientId = null;
        if (clientIds.length == 0) {
            return;
        }
        ClientId lastClientId = clientIds[0];
        printWriter.print("Site " + lastClientId.getSiteNumber() + " team " + lastClientId.getClientNumber());
        boolean inRange = false;
        int i = 1;
        while (i < clientIds.length) {
            clientId = clientIds[i];
            if (lastClientId.getSiteNumber() != clientId.getSiteNumber()) {
                if (inRange) {
                    printWriter.print(lastClientId.getClientNumber());
                    inRange = false;
                }
                printWriter.print(" Site " + clientId.getSiteNumber() + " team " + clientId.getClientNumber());
            } else if (lastClientId.getSiteNumber() == clientId.getSiteNumber() && lastClientId.getClientNumber() + 1 == clientId.getClientNumber()) {
                if (!inRange) {
                    printWriter.print("-");
                    inRange = true;
                }
            } else {
                if (inRange) {
                    printWriter.print(lastClientId.getClientNumber());
                }
                printWriter.print("," + clientId.getClientNumber());
                inRange = false;
            }
            lastClientId = clientId;
            ++i;
        }
        if (inRange) {
            printWriter.print(clientId.getClientNumber());
        }
    }

    public void writeReport(PrintWriter printWriter) {
        int theIndex;
        SummaryCounts summaryCounts = new SummaryCounts();
        Language[] languages = this.contest.getLanguages();
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        int count = this.filter.countRuns(runs);
        printWriter.println("There are " + count + " runs.");
        printWriter.println();
        if (languages == null || languages.length == 0) {
            printWriter.println("No languages defined, no summary");
            return;
        }
        int idx = 0;
        Language[] languageArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            this.langLookup.put(language.getElementId(), new Integer(idx));
            ++idx;
            ++n2;
        }
        int[] numberSolved = new int[languages.length];
        int[] numberAttempted = new int[languages.length];
        int[] didNotSolve = new int[languages.length];
        int numDeleted = 0;
        IElementObject[] iElementObjectArray = runs;
        int n3 = runs.length;
        int n4 = 0;
        while (n4 < n3) {
            Run run = iElementObjectArray[n4];
            if (!run.isDeleted() && this.filter.matches(run)) {
                theIndex = this.langLookup.get(run.getLanguageId());
                if (run.isSolved()) {
                    int n5 = theIndex;
                    numberSolved[n5] = numberSolved[n5] + 1;
                    summaryCounts.increment(run.getSubmitter(), run.getLanguageId());
                } else {
                    int n6 = theIndex;
                    didNotSolve[n6] = didNotSolve[n6] + 1;
                }
                int n7 = theIndex;
                numberAttempted[n7] = numberAttempted[n7] + 1;
            } else if (run.isDeleted() && this.filter.matches(run)) {
                ++numDeleted;
            }
            ++n4;
        }
        iElementObjectArray = languages;
        n3 = languages.length;
        n4 = 0;
        while (n4 < n3) {
            IElementObject language = iElementObjectArray[n4];
            theIndex = this.langLookup.get(((Language)language).getElementId());
            if (this.filter.matchesLanguage((Language)language)) {
                printWriter.println("Language " + language);
                ClientId[] clientIds = summaryCounts.getClients(((Language)language).getElementId());
                printWriter.print("      " + clientIds.length + " teams: ");
                Arrays.sort(clientIds, new ClientIdComparator());
                this.printClients(printWriter, clientIds);
                printWriter.println();
                printWriter.println("      " + numberSolved[theIndex] + " submissions solved problems");
                printWriter.println("      " + didNotSolve[theIndex] + " submissions did not solved problems");
                printWriter.println("      " + numberAttempted[theIndex] + " total ");
                printWriter.println();
            }
            ++n4;
        }
        if (numDeleted > 0) {
            printWriter.println("There are " + numDeleted + " runs marked deleted");
        }
    }

    private void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public String[] createReport(Filter arg0) {
        return null;
    }

    public String createReportXML(Filter arg0) {
        return null;
    }

    public String getReportTitle() {
        return "Submissions by Language";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Submissions by Language Report";
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

