/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.ClientSettingsComparator;
import edu.csus.ecs.pc2.core.list.ContestTimeComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class InternalDumpReport
implements IReport {
    private static final long serialVersionUID = -82937493006891083L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    private void printClientSettings(PrintWriter printWriter) {
        ClientSettings[] clientSettingsArray = this.contest.getClientSettingsList();
        printWriter.println();
        printWriter.println("-- Client Settings --");
        Arrays.sort(clientSettingsArray, new ClientSettingsComparator());
        ClientSettings[] clientSettingsArray2 = clientSettingsArray;
        int n = clientSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings = clientSettingsArray2[n2];
            printWriter.println("    For: " + clientSettings.getClientId());
            String[] stringArray = clientSettings.getKeys();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String key = stringArray[n4];
                printWriter.println("      " + key + " = " + clientSettings.getProperty(key));
                ++n4;
            }
            ++n2;
        }
    }

    private void printNotificationSettings(PrintWriter printWriter) {
        ClientSettings[] clientSettingsArray = this.contest.getClientSettingsList();
        printWriter.println();
        printWriter.println("-- Notification Settings --");
        Arrays.sort(clientSettingsArray, new ClientSettingsComparator());
        ClientSettings[] clientSettingsArray2 = clientSettingsArray;
        int n = clientSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings = clientSettingsArray2[n2];
            NotificationSetting notificationSetting = clientSettings.getNotificationSetting();
            if (notificationSetting != null) {
                printWriter.println("    For: " + clientSettings.getClientId());
                this.dumpNotification(printWriter, clientSettings.getNotificationSetting());
            }
            ++n2;
        }
    }

    protected void dumpNotification(PrintWriter printWriter, NotificationSetting notificationSetting2) {
        printWriter.println();
        if (notificationSetting2 == null) {
            printWriter.println("          No delivery notification settings defined.");
        } else {
            JudgementNotification judgementNotification = null;
            judgementNotification = notificationSetting2.getPreliminaryNotificationYes();
            printWriter.println("          Prelim Yes suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getPreliminaryNotificationNo();
            printWriter.println("          Prelim No  suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationYes();
            printWriter.println("          Final  Yes suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationNo();
            printWriter.println("          Final  No  suppress " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
        }
    }

    private void printContestInformation(PrintWriter printWriter) {
        ContestInformation contestInformation = this.contest.getContestInformation();
        printWriter.println();
        printWriter.println("-- Contest Information --");
        printWriter.println("  Title : '" + contestInformation.getContestTitle() + "'");
        printWriter.println("  URL   : '" + contestInformation.getContestURL() + "'");
        printWriter.println();
        printWriter.println("  Include Preliminary Judgements in Scoring Algorithm : " + Utilities.yesNoString(contestInformation.isPreliminaryJudgementsUsedByBoard()));
        printWriter.println("  Send Notifications for Preliminary Judgements       : " + Utilities.yesNoString(contestInformation.isPreliminaryJudgementsTriggerNotifications()));
        printWriter.println("  Send Additional Run Status Information              : " + Utilities.yesNoString(contestInformation.isSendAdditionalRunStatusInformation()));
        printWriter.println();
        printWriter.println("  Judges' Default Answer: '" + contestInformation.getJudgesDefaultAnswer() + "'");
        if (contestInformation.getTeamDisplayMode() != null) {
            printWriter.println("  Judges see: " + (Object)((Object)contestInformation.getTeamDisplayMode()));
        } else {
            printWriter.println("  Judges see: " + (Object)((Object)ContestInformation.TeamDisplayMask.LOGIN_NAME_ONLY));
        }
    }

    private void printAccounts(PrintWriter printWriter, Account[] accounts) {
        Arrays.sort(accounts, new AccountComparator());
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (this.filter.matchesAccount(account)) {
                printWriter.print("   Site " + account.getSiteNumber());
                printWriter.format(" %-15s", account.getClientId().getName());
                printWriter.println(" id=" + account.getElementId());
            }
            ++n2;
        }
    }

    private void printAccounts(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Accounts -- " + this.getFilterText());
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            Vector<Account> vector = this.contest.getAccounts(ctype);
            Account[] accounts = vector.toArray(new Account[vector.size()]);
            int accountCount = this.filter.countAccounts(accounts);
            printWriter.print("Accounts " + ctype.toString() + " there are " + accountCount);
            printWriter.println();
            this.printAccounts(printWriter, accounts);
            ++n2;
        }
        this.printAllAccounts(printWriter);
    }

    private void printAllAccounts(PrintWriter printWriter) {
        Vector<Account> vector = this.contest.getAccounts(ClientType.Type.ALL);
        printWriter.println();
        Account[] accounts = vector.toArray(new Account[vector.size()]);
        int accountCount = this.filter.countAccounts(accounts);
        printWriter.print("There are " + accountCount);
        printWriter.println();
        this.printAccounts(printWriter, accounts);
    }

    private String getFilterText() {
        if (this.filter != null) {
            return " (filtered) ";
        }
        return "";
    }

    public void writeReport(PrintWriter printWriter) {
        this.printLocalContestTime(printWriter);
        this.printCurrentClientInfo(printWriter);
        this.printSites(printWriter);
        this.printContestTimes(printWriter);
        this.printContestInformation(printWriter);
        this.printProblems(printWriter);
        this.printLanguages(printWriter);
        this.printJudgements(printWriter);
        this.printAccounts(printWriter);
        this.printRuns(printWriter);
        this.printClarifications(printWriter);
        this.printLogins(printWriter);
        this.printConnections(printWriter);
        this.printClientSettings(printWriter);
        this.printNotificationSettings(printWriter);
    }

    private void printCurrentClientInfo(PrintWriter printWriter) {
        printWriter.println();
        Account account = this.contest.getAccount(this.contest.getClientId());
        String name = this.contest.getClientId().getName();
        if (account != null) {
            name = account.getDisplayName();
        }
        printWriter.println("* Client Id = " + this.contest.getClientId() + " " + name);
    }

    private void printLocalContestTime(PrintWriter printWriter) {
        ContestTime localContestTime = this.contest.getContestTime();
        printWriter.println();
        if (localContestTime != null) {
            if (localContestTime.isContestRunning()) {
                printWriter.print("Contest is RUNNING");
            } else {
                printWriter.print("Contest is STOPPED");
            }
            printWriter.print(" elapsed = " + localContestTime.getElapsedTimeStr());
            printWriter.print(" remaining = " + localContestTime.getRemainingTimeStr());
            printWriter.print(" length = " + localContestTime.getContestLengthStr());
            printWriter.println();
        } else {
            printWriter.println("Contest Time is undefined (null)");
        }
    }

    private void printContestTimes(PrintWriter printWriter) {
        printWriter.println();
        ContestTime[] contestTimes = this.contest.getContestTimes();
        Arrays.sort(contestTimes, new ContestTimeComparator());
        printWriter.println("-- " + contestTimes.length + " Contest Times --");
        ContestTime[] contestTimeArray = contestTimes;
        int n = contestTimes.length;
        int n2 = 0;
        while (n2 < n) {
            ContestTime contestTime = contestTimeArray[n2];
            if (this.contest.getSiteNumber() == contestTime.getSiteNumber()) {
                printWriter.print("  * ");
            } else {
                printWriter.print("    ");
            }
            String state = "STOPPED";
            if (contestTime.isContestRunning()) {
                state = "STARTED";
            }
            printWriter.println("  Site " + contestTime.getSiteNumber() + " " + state + " " + contestTime.getElapsedTimeStr() + " " + contestTime.getRemainingTimeStr() + " " + contestTime.getContestLengthStr());
            printWriter.println("         past end " + contestTime.isPastEndOfContest() + ", halt at end " + contestTime.isHaltContestAtTimeZero() + ", offset " + contestTime.getLocalClockOffset() + ", id=" + contestTime.getElementId() + " site " + contestTime.getElementId().getSiteNumber());
            ++n2;
        }
    }

    private void printLanguages(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- " + this.contest.getLanguages().length + " languages --");
        Language[] languageArray = this.contest.getLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            printWriter.println("  '" + language + "' id=" + language.getElementId());
            ++n2;
        }
    }

    private void printProblems(PrintWriter printWriter) {
        printWriter.println();
        if (this.contest.getGeneralProblem() == null) {
            printWriter.println(" General Problem: (not defined) ");
        } else {
            printWriter.println(" General Problem: " + this.contest.getGeneralProblem().getElementId());
        }
        printWriter.println();
        printWriter.println("-- " + this.contest.getProblems().length + " problems --");
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            printWriter.println("  '" + problem + "' id=" + problem.getElementId());
            ++n2;
        }
    }

    private void printLogins(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- Logins -- ");
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            ClientId[] clientIds = this.contest.getAllLoggedInClients(ctype);
            if (clientIds.length > 0) {
                printWriter.println("Logged in " + ctype.toString());
                ClientId[] clientIdArray = clientIds;
                int n3 = clientIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    ClientId clientId = clientIdArray[n4];
                    ConnectionHandlerID connectionHandlerID = this.contest.getConnectionHandleID(clientId);
                    printWriter.println("   " + clientId + " on " + connectionHandlerID);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void printSites(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("-- " + this.contest.getSites().length + " sites --");
        Site[] sites = this.contest.getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        Site[] siteArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site1 = siteArray[n2];
            String hostName = site1.getConnectionInfo().getProperty("IP_KEY");
            String portStr = site1.getConnectionInfo().getProperty("PORT_KEY");
            printWriter.println("Site " + site1.getSiteNumber() + " " + hostName + ":" + portStr + " '" + site1.getDisplayName() + "' " + " password='" + site1.getPassword() + "' id=" + site1.getElementId());
            ++n2;
        }
    }

    private void printJudgements(PrintWriter printWriter) {
        printWriter.println();
        Judgement[] judgements = this.contest.getJudgements();
        printWriter.println("-- " + judgements.length + " Judgements --");
        Judgement[] judgementArray = judgements;
        int n = judgements.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement judgement = judgementArray[n2];
            printWriter.println("  '" + judgement + "' id=" + judgement.getElementId());
            ++n2;
        }
    }

    public void printConnections(PrintWriter printWriter) {
        printWriter.println();
        ConnectionHandlerID[] connectionHandlerIDs = this.contest.getConnectionHandleIDs();
        printWriter.println("-- " + connectionHandlerIDs.length + " Connections --");
        ConnectionHandlerID[] connectionHandlerIDArray = connectionHandlerIDs;
        int n = connectionHandlerIDs.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionHandlerID connectionHandlerID = connectionHandlerIDArray[n2];
            printWriter.println("  " + connectionHandlerID);
            ++n2;
        }
    }

    private void printHeader(PrintWriter printWriter) {
        VersionInfo versionInfo = new VersionInfo();
        printWriter.println(versionInfo.getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(versionInfo.getSystemVersionInfo());
        printWriter.println("Build " + versionInfo.getBuildNumber());
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    public void createReportFile(String filename, Filter inFilter) throws IOException {
        if (inFilter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
        this.filter = inFilter;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
        printWriter.close();
        printWriter = null;
    }

    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String createReportXML(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    public String getReportTitle() {
        return "Internal Dump";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    public String getPluginTitle() {
        return "Internal Dump Report";
    }

    private void printRuns(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        int count = this.filter.countRuns(runs);
        printWriter.print("-- " + count + " runs --" + this.getFilterText());
        printWriter.println();
        if (count > 0) {
            Run[] runArray = runs;
            int n = runs.length;
            int n2 = 0;
            while (n2 < n) {
                Run run = runArray[n2];
                if (this.filter.matches(run)) {
                    printWriter.println("  " + run);
                }
                ++n2;
            }
        }
    }

    private void printClarifications(PrintWriter printWriter) {
        printWriter.println();
        Clarification[] clarifications = this.contest.getClarifications();
        Arrays.sort(clarifications, new ClarificationComparator());
        int count = this.filter.countClarifications(clarifications);
        printWriter.print("-- " + count + " clarifications -- " + this.getFilterText());
        printWriter.println();
        Clarification[] clarificationArray = clarifications;
        int n = clarifications.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clarification = clarificationArray[n2];
            if (this.filter.matches(clarification)) {
                printWriter.println("  " + clarification);
            }
            ++n2;
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public int countClientSettings(ClientSettings[] clientSettings) {
        int count = 0;
        ClientSettings[] clientSettingsArray = clientSettings;
        int n = clientSettings.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings2 = clientSettingsArray[n2];
            if (this.filter.matches(clientSettings2.getClientId())) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

